/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapFlagCache
implements Iterable<ImapFlag> {
    private final Mailbox mMailbox;
    private final Map<String, ImapFlag> mNames;
    private final Map<Long, ImapFlag> mBitmasks;

    ImapFlagCache() {
        this.mNames = new LinkedHashMap<String, ImapFlag>();
        this.mBitmasks = new HashMap<Long, ImapFlag>();
        this.mMailbox = null;
    }

    ImapFlagCache(Mailbox mbox, OperationContext octxt) throws ServiceException {
        block3: {
            this.mNames = new LinkedHashMap<String, ImapFlag>();
            this.mBitmasks = new HashMap<Long, ImapFlag>();
            this.mMailbox = mbox;
            try {
                for (Tag ltag : mbox.getTagList(octxt)) {
                    if (ltag instanceof Flag) continue;
                    this.cache(new ImapFlag(ltag.getName(), ltag, true));
                }
            }
            catch (ServiceException e) {
                if (e.getCode().equals("service.PERM_DENIED")) break block3;
                throw e;
            }
        }
    }

    static ImapFlagCache getSystemFlags(Mailbox mbox) throws ServiceException {
        ImapFlagCache i4cache = new ImapFlagCache();
        i4cache.cache(new ImapFlag("\\Answered", mbox.getFlagById(-3), true));
        i4cache.cache(new ImapFlag("\\Deleted", mbox.getFlagById(-8), true));
        i4cache.cache(new ImapFlag("\\Draft", mbox.getFlagById(-7), true));
        i4cache.cache(new ImapFlag("\\Flagged", mbox.getFlagById(-6), true));
        i4cache.cache(new ImapFlag("\\Seen", mbox.getFlagById(-10), false));
        i4cache.cache(new ImapFlag("$Forwarded", mbox.getFlagById(-4), true));
        i4cache.cache(new ImapFlag("$MDNSent", mbox.getFlagById(-9), true));
        i4cache.cache(new ImapFlag("Forwarded", mbox.getFlagById(-4), true));
        i4cache.cache(new ImapFlag("\\Recent", 1, false));
        i4cache.cache(new ImapFlag("$Junk", 2, true));
        i4cache.cache(new ImapFlag("$NotJunk", 4, true));
        i4cache.cache(new ImapFlag("Junk", 2, true));
        i4cache.cache(new ImapFlag("JunkRecorded", 8, true));
        i4cache.cache(new ImapFlag("NonJunk", 4, true));
        i4cache.cache(new ImapFlag("NotJunk", 4, true));
        return i4cache;
    }

    ImapFlag getByName(String name) {
        return this.mNames.get(name.toUpperCase());
    }

    ImapFlag getByMask(long mask) {
        return this.mBitmasks.get(mask);
    }

    List<String> listNames(boolean permanentOnly) {
        if (this.mNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, ImapFlag> entry : this.mNames.entrySet()) {
            ImapFlag i4flag = entry.getValue();
            if (!i4flag.mListed || permanentOnly && !i4flag.mPermanent) continue;
            names.add(i4flag.mImapName);
        }
        return names;
    }

    int getMaximumModseq() {
        int modseq = 0;
        for (ImapFlag i4flag : this.mNames.values()) {
            modseq = Math.max(modseq, i4flag.mModseq);
        }
        return modseq;
    }

    ImapFlag createTag(OperationContext octxt, String name, List<Tag> newTags) throws ServiceException {
        ImapFlag i4flag;
        block6: {
            if (this.mMailbox == null) {
                return null;
            }
            i4flag = this.getByName(name);
            if (i4flag != null) {
                return i4flag;
            }
            if (name.startsWith("\\")) {
                throw MailServiceException.INVALID_NAME(name);
            }
            try {
                Tag ltag = this.mMailbox.createTag(octxt, name, (byte)0);
                newTags.add(ltag);
                i4flag = this.getByName(name);
                if (i4flag == null) {
                    i4flag = new ImapFlag(name, ltag, true);
                    return this.cache(i4flag);
                }
            }
            catch (ServiceException e) {
                if (e.getCode().equals("service.PERM_DENIED") || e.getCode().equals("mail.TOO_MANY_TAGS")) break block6;
                throw e;
            }
        }
        return i4flag;
    }

    ImapFlag cache(ImapFlag i4flag) {
        this.mNames.put(i4flag.mImapName.toUpperCase(), i4flag);
        Long bitmask = new Long(i4flag.mBitmask);
        if (!this.mBitmasks.containsKey(bitmask)) {
            this.mBitmasks.put(bitmask, i4flag);
        }
        return i4flag;
    }

    void uncache(long bitmask) {
        ImapFlag i4flag = this.mBitmasks.remove(bitmask);
        if (i4flag != null) {
            this.mNames.remove(i4flag.mImapName.toUpperCase());
        }
    }

    void clear() {
        this.mNames.clear();
        this.mBitmasks.clear();
    }

    @Override
    public Iterator<ImapFlag> iterator() {
        return this.mNames.values().iterator();
    }

    static final class ImapFlag {
        final String mName;
        final String mImapName;
        final int mId;
        final long mBitmask;
        final boolean mPositive;
        final boolean mPermanent;
        final boolean mListed;
        final int mModseq;
        static final boolean VISIBLE = true;
        static final boolean HIDDEN = false;

        ImapFlag(String name, Tag ltag, boolean positive) {
            this.mId = ltag.getId();
            this.mBitmask = ltag.getBitmask();
            this.mName = ltag.getName();
            this.mImapName = this.normalize(name, this.mId);
            this.mPositive = positive;
            this.mPermanent = true;
            this.mListed = true;
            this.mModseq = ltag.getSavedSequence();
        }

        ImapFlag(String name, short bitmask, boolean listed) {
            this.mId = 0;
            this.mBitmask = bitmask;
            this.mName = name;
            this.mImapName = name;
            this.mPositive = true;
            this.mPermanent = false;
            this.mListed = listed;
            this.mModseq = -1;
        }

        private String normalize(String name, int id) {
            StringBuilder sb = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c <= ' ' || c >= '\u007f' || c == '(' || c == ')' || c == '{' || c == '%' || c == '*' || c == '\"' || c == ']' || i != 0 && c == '\\') continue;
                sb.append(c);
            }
            if (sb.length() != name.length()) {
                sb.append(":FLAG").append(Tag.getIndex(id));
            }
            return sb.toString();
        }

        boolean matches(ImapMessage i4msg) {
            long mask = this.mId == 0 ? (long)i4msg.sflags : (this.mId > 0 ? i4msg.tags : (long)i4msg.flags);
            return (mask & this.mBitmask) != 0L;
        }

        public String toString() {
            return this.mImapName;
        }
    }
}

