/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.imap.ImapPath;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mailbox.OperationContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImapCredentials {
    private static final String SN_IMAP = "imap";
    private static final String FN_SUBSCRIPTIONS = "subs";
    private final String mAccountId;
    private final String mUsername;
    private final boolean mIsLocal;
    private final EnabledHack mEnabledHack;

    ImapCredentials(Account acct, EnabledHack hack) throws ServiceException {
        this.mAccountId = acct.getId();
        this.mUsername = acct.getName();
        this.mIsLocal = Provisioning.onLocalServer(acct);
        this.mEnabledHack = hack == null ? EnabledHack.NONE : hack;
    }

    String getUsername() {
        return this.mUsername;
    }

    boolean isLocal() {
        return this.mIsLocal;
    }

    boolean isHackEnabled(EnabledHack hack) {
        return this.mEnabledHack == hack;
    }

    EnabledHack[] getEnabledHacks() {
        if (this.mEnabledHack == null || this.mEnabledHack == EnabledHack.NONE) {
            return null;
        }
        return new EnabledHack[]{this.mEnabledHack};
    }

    String getAccountId() {
        return this.mAccountId;
    }

    Account getAccount() throws ServiceException {
        return Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mAccountId);
    }

    OperationContext getContext() throws ServiceException {
        return new OperationContext(this.mAccountId);
    }

    Mailbox getMailbox() throws ServiceException {
        if (!this.mIsLocal) {
            throw ServiceException.WRONG_HOST(this.getAccount().getAttr("zimbraMailHost"), null);
        }
        return MailboxManager.getInstance().getMailboxByAccountId(this.mAccountId);
    }

    private Set<String> parseConfig(Metadata config) throws ServiceException {
        if (config == null || !config.containsKey(FN_SUBSCRIPTIONS)) {
            return null;
        }
        MetadataList slist = config.getList(FN_SUBSCRIPTIONS, true);
        if (slist == null || slist.isEmpty()) {
            return null;
        }
        HashSet<String> subscriptions = new HashSet<String>(slist.size());
        for (int i = 0; i < slist.size(); ++i) {
            subscriptions.add(slist.get(i));
        }
        return subscriptions;
    }

    private void saveConfig(Set<String> subscriptions) throws ServiceException {
        MetadataList slist = new MetadataList();
        if (subscriptions != null && !subscriptions.isEmpty()) {
            for (String sub : subscriptions) {
                slist.add(sub);
            }
        }
        this.getMailbox().setConfig(this.getContext(), SN_IMAP, new Metadata().put(FN_SUBSCRIPTIONS, slist));
    }

    Set<String> listSubscriptions() throws ServiceException {
        return this.parseConfig(this.getMailbox().getConfig(this.getContext(), SN_IMAP));
    }

    void subscribe(ImapPath path) throws ServiceException {
        Set<String> subscriptions = this.listSubscriptions();
        if (subscriptions != null && !subscriptions.isEmpty()) {
            String upcase = path.asImapPath().toUpperCase();
            for (String sub : subscriptions) {
                if (!upcase.equals(sub.toUpperCase())) continue;
                return;
            }
        }
        if (subscriptions == null) {
            subscriptions = new HashSet<String>();
        }
        subscriptions.add(path.asImapPath());
        this.saveConfig(subscriptions);
    }

    void unsubscribe(ImapPath path) throws ServiceException {
        Set<String> subscriptions = this.listSubscriptions();
        if (subscriptions == null || subscriptions.isEmpty()) {
            return;
        }
        String upcase = path.asImapPath().toUpperCase();
        boolean found = false;
        Iterator<String> it = subscriptions.iterator();
        while (it.hasNext()) {
            if (!upcase.equals(it.next().toUpperCase())) continue;
            it.remove();
            found = true;
        }
        if (!found) {
            return;
        }
        this.saveConfig(subscriptions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EnabledHack {
        NONE,
        WM5("/wm"),
        THUNDERBIRD("/tb"),
        NO_IDLE("/ni");

        private String extension;

        private EnabledHack() {
        }

        private EnabledHack(String ext) {
            this.extension = ext;
        }

        public String toString() {
            return this.extension;
        }
    }
}

