/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.server.ServerConfig;
import com.zimbra.cs.util.BuildInfo;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapConfig
extends ServerConfig {
    private int mUnauthMaxIdleSeconds = 0;
    private String mBanner;
    private String mGoodbye;
    private Set<String> mDisabledExtensions;
    private boolean mSaslGssapiEnabled;
    private int mMaxRequestSize;
    private int mMaxMessageSize;
    private static final int DEFAULT_NUM_THREADS = 10;
    private static final int DEFAULT_BIND_PORT = 143;
    private static final int DEFAULT_SSL_BIND_PORT = 993;
    private static final int DEFAULT_MAX_IDLE_SECONDS = 1800;
    private static final int DEFAULT_UNAUTH_MAX_IDLE_SECONDS = 60;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x6400000;

    public ImapConfig(boolean ssl) throws ServiceException {
        this.setMaxIdleSeconds(1800);
        this.setUnauthMaxIdleSeconds(60);
        this.setNumThreads(10);
        this.setBindPort(ssl ? 993 : 143);
        this.mDisabledExtensions = new HashSet<String>();
        this.validate();
    }

    public ImapConfig(Provisioning prov, boolean ssl) throws ServiceException {
        Server server = prov.getLocalServer();
        this.setSSLEnabled(ssl);
        Config config = prov.getConfig();
        this.setSSLExcludeCiphers(config.getMultiAttr("zimbraSSLExcludeCipherSuites"));
        String name = server.getAttr("zimbraImapAdvertisedName");
        if (name != null && name.length() > 0) {
            this.setName(name);
        }
        this.setMaxIdleSeconds(1800);
        this.setUnauthMaxIdleSeconds(60);
        this.setNumThreads(server.getIntAttr("zimbraImapNumThreads", 10));
        if (ssl) {
            this.setBindAddress(server.getAttr("zimbraImapSSLBindAddress"));
            this.setBindPort(server.getIntAttr("zimbraImapSSLBindPort", 993));
            this.mDisabledExtensions = this.getDisabledExtensions(server.getMultiAttr("zimbraImapSSLDisabledCapability"));
        } else {
            this.setBindAddress(server.getAttr("zimbraImapBindAddress"));
            this.setBindPort(server.getIntAttr("zimbraImapBindPort", 143));
            this.mDisabledExtensions = this.getDisabledExtensions(server.getMultiAttr("zimbraImapDisabledCapability"));
        }
        this.mSaslGssapiEnabled = server.getBooleanAttr("zimbraImapSaslGssapiEnabled", false);
        this.mMaxRequestSize = LC.imap_max_request_size.intValue();
        this.mMaxMessageSize = config.getIntAttr("zimbraMtaMaxMessageSize", 0x6400000);
        this.validate();
    }

    @Override
    public void validate() throws ServiceException {
        if (this.getUnauthMaxIdleSeconds() < 0) {
            this.failure("Invalid unauth max idle seconds: " + this.getUnauthMaxIdleSeconds());
        }
        super.validate();
    }

    private Set<String> getDisabledExtensions(String[] names) {
        HashSet<String> disabled = new HashSet<String>(names.length);
        for (String name : names) {
            disabled.add(name.toUpperCase());
        }
        return disabled;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        String version = "";
        try {
            Server server = Provisioning.getInstance().getLocalServer();
            if (server.getBooleanAttr("zimbraImapExposeVersionOnBanner", false)) {
                version = " " + BuildInfo.VERSION;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.mBanner = "OK " + name + " Zimbra" + version + " IMAP4rev1 service ready";
        this.mGoodbye = name + " IMAP4rev1 server terminating connection";
    }

    public String getBanner() {
        return this.mBanner;
    }

    public String getGoodbye() {
        return this.mGoodbye;
    }

    public int getUnauthMaxIdleSeconds() {
        return this.mUnauthMaxIdleSeconds;
    }

    public void setUnauthMaxIdleSeconds(int secs) {
        this.mUnauthMaxIdleSeconds = secs;
    }

    public boolean isExtensionDisabled(String name) {
        return this.mDisabledExtensions.contains(name.toUpperCase());
    }

    public boolean isSaslGssapiEnabled() {
        return this.mSaslGssapiEnabled;
    }

    public int getMaxRequestSize() {
        return this.mMaxRequestSize;
    }

    public int getMaxMessageSize() {
        return this.mMaxMessageSize;
    }

    public boolean allowCleartextLogins() {
        try {
            Server server = Provisioning.getInstance().getLocalServer();
            return server.getBooleanAttr("zimbraImapCleartextLoginEnabled", false);
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)"Unable to determine state of zimbraImapCleartextLoginEnabled", e);
            return false;
        }
    }
}

