/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.security.sasl.Authenticator;
import com.zimbra.cs.security.sasl.AuthenticatorUser;
import java.io.IOException;

class ImapAuthenticatorUser
implements AuthenticatorUser {
    private final ImapHandler mHandler;
    private final String mTag;
    private boolean canContinue = true;

    ImapAuthenticatorUser(ImapHandler handler, String tag) {
        this.mHandler = handler;
        this.mTag = tag;
    }

    String getTag() {
        return this.mTag;
    }

    boolean canContinue() {
        return this.canContinue;
    }

    public String getProtocol() {
        return "imap";
    }

    public void sendBadRequest(String s) throws IOException {
        this.mHandler.sendBAD(this.mTag, s);
    }

    public void sendFailed() throws IOException {
        this.mHandler.sendNO(this.mTag, "AUTHENTICATE failed");
    }

    public void sendFailed(String msg) throws IOException {
        this.mHandler.sendNO(this.mTag, "AUTHENTICATE failed: " + msg);
    }

    public void sendSuccessful() throws IOException {
        this.mHandler.sendOK(this.mTag, '[' + this.mHandler.getCapabilityString() + "] AUTHENTICATE completed");
    }

    public void sendContinuation(String s) throws IOException {
        this.mHandler.sendContinuation(s);
    }

    public boolean authenticate(String authorizationId, String authenticationId, String password, Authenticator auth) throws IOException {
        this.canContinue = this.mHandler.authenticate(authorizationId, authenticationId, password, this.mTag, auth);
        return this.mHandler.isAuthenticated();
    }

    public Log getLog() {
        return ZimbraLog.imap;
    }

    public boolean isSSLEnabled() {
        return this.mHandler.isSSLEnabled();
    }

    public boolean allowCleartextLogin() {
        return this.mHandler.getConfig().allowCleartextLogins();
    }

    public boolean isGssapiAvailable() {
        return this.mHandler.getConfig().isSaslGssapiEnabled();
    }
}

