/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.imap.ImapCredentials;
import com.zimbra.cs.imap.ImapFlagCache;
import com.zimbra.cs.imap.ImapFolder;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.imap.ImapParseException;
import com.zimbra.cs.imap.ImapRequest;
import com.zimbra.cs.imap.ImapURL;
import com.zimbra.cs.imap.Literal;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.BlobBuilder;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MailDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppendMessage {
    final ImapHandler handler;
    final String tag;
    private Date date;
    private boolean catenate;
    private List<Part> parts;
    private Blob content;
    private List<String> flagNames;
    private int flags = Flag.BITMASK_UNREAD;
    private long tags;
    private short sflags;

    public static AppendMessage parse(ImapHandler handler, String tag, ImapRequest req) throws ImapParseException, IOException {
        AppendMessage append = new AppendMessage(handler, tag);
        append.parse(req);
        return append;
    }

    private AppendMessage(ImapHandler handler, String tag) {
        this.handler = handler;
        this.tag = tag;
    }

    private void parse(ImapRequest req) throws ImapParseException, IOException {
        if (req.peekChar() == 40) {
            this.flagNames = req.readFlags();
            req.skipSpace();
        }
        if (req.peekChar() == 34) {
            this.date = req.readDate(true, true);
            req.skipSpace();
        }
        if ((req.peekChar() == 99 || req.peekChar() == 67) && this.handler.extensionEnabled("CATENATE")) {
            req.skipAtom("CATENATE");
            req.skipSpace();
            req.skipChar('(');
            this.catenate = true;
            this.parts = new ArrayList<Part>(5);
            while (req.peekChar() != 41) {
                if (!this.parts.isEmpty()) {
                    req.skipSpace();
                }
                String type = req.readATOM();
                req.skipSpace();
                if (type.equals("TEXT")) {
                    this.parts.add(new Part(req.readLiteral()));
                    continue;
                }
                if (type.equals("URL")) {
                    this.parts.add(new Part(new ImapURL(this.tag, this.handler, req.readAstring())));
                    continue;
                }
                throw new ImapParseException(this.tag, "unknown CATENATE cat-part: " + type);
            }
            req.skipChar(')');
        } else {
            this.parts = Arrays.asList(new Part(req.readLiteral8()));
        }
    }

    public void checkFlags(ImapFlagCache flagSet, ImapFlagCache tagSet, List<Tag> newTags) throws ServiceException {
        if (this.flagNames == null) {
            return;
        }
        for (String name : this.flagNames) {
            ImapFlagCache.ImapFlag i4flag = flagSet.getByName(name);
            if (i4flag != null && !i4flag.mListed) {
                i4flag = null;
            } else if (i4flag == null && !name.startsWith("\\")) {
                i4flag = tagSet.getByName(name);
            }
            if (i4flag == null) {
                i4flag = tagSet.createTag(this.handler.getContext(), name, newTags);
            }
            if (i4flag == null) continue;
            if (!i4flag.mPermanent) {
                this.sflags = (short)((long)this.sflags | i4flag.mBitmask);
                continue;
            }
            if (Tag.validateId(i4flag.mId)) {
                this.tags |= i4flag.mBitmask;
                continue;
            }
            if (i4flag.mPositive) {
                this.flags = (int)((long)this.flags | i4flag.mBitmask);
                continue;
            }
            this.flags = (int)((long)this.flags & (i4flag.mBitmask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.flagNames = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int storeContent(Object mboxObj, Object folderObj) throws IOException, ServiceException, ImapParseException {
        block3: {
            try {
                this.checkDate(this.content);
                if (!(mboxObj instanceof Mailbox)) break block3;
                int n = this.store((Mailbox)mboxObj, (Folder)folderObj);
                Object var5_5 = null;
                this.cleanup();
                return n;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.cleanup();
                throw throwable;
            }
        }
        int n = this.store((ZMailbox)mboxObj, (ZFolder)folderObj);
        Object var5_6 = null;
        this.cleanup();
        return n;
    }

    private int store(Mailbox mbox, Folder folder) throws ServiceException, IOException {
        ImapFolder selectedFolder;
        ImapMessage i4msg;
        boolean idxAttach = mbox.attachmentsIndexingEnabled();
        Long receivedDate = this.date != null ? Long.valueOf(this.date.getTime()) : null;
        ParsedMessage pm = new ParsedMessage(this.content.getFile(), receivedDate, idxAttach);
        try {
            if (!pm.getSender().equals("")) {
                InternetAddress ia = new InternetAddress(pm.getSender());
                if (AccountUtil.addressMatchesAccount(mbox.getAccount(), ia.getAddress())) {
                    this.flags |= Flag.BITMASK_FROM_ME;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Message msg = mbox.addMessage(this.handler.getContext(), pm, folder.getId(), true, this.flags, Tag.bitmaskToTags(this.tags));
        if (msg != null && this.sflags != 0 && this.handler.getState() == ImapHandler.State.SELECTED && (i4msg = (selectedFolder = this.handler.getSelectedFolder()).getById(msg.getId())) != null) {
            i4msg.setSessionFlags(this.sflags, selectedFolder);
        }
        return msg == null ? -1 : msg.getId();
    }

    private int store(ZMailbox mbox, ZFolder folder) throws IOException, ServiceException {
        InputStream is = this.content.getInputStream();
        String id = mbox.addMessage(folder.getId(), Flag.bitmaskToFlags(this.flags), null, this.date.getTime(), is, this.content.getRawSize(), true);
        return new ItemId(id, this.getCredentials().getAccountId()).getId();
    }

    public void checkContent() throws IOException, ImapParseException, ServiceException {
        Blob blob = this.content = this.catenate ? this.doCatenate() : this.parts.get((int)0).literal.getBlob();
        if (this.content.getRawSize() > (long)this.handler.getConfig().getMaxMessageSize()) {
            this.cleanup();
            if (this.catenate) {
                throw new ImapParseException(this.tag, "TOOBIG", "maximum message size exceeded", false);
            }
            throw new ImapParseException(this.tag, "maximum message size exceeded", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Blob doCatenate() throws IOException, ImapParseException, ServiceException {
        Blob blob;
        BlobBuilder bb = StoreManager.getInstance().getBlobBuilder();
        try {
            for (Part part : this.parts) {
                this.copyBytes(part.getInputStream(), bb);
                part.cleanup();
            }
            blob = bb.finish();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            for (Part part : this.parts) {
                part.cleanup();
            }
            this.parts = null;
            throw throwable;
        }
        for (Part part : this.parts) {
            part.cleanup();
        }
        this.parts = null;
        return blob;
    }

    public void cleanup() {
        if (this.content != null) {
            StoreManager.getInstance().quietDelete(this.content);
            this.content = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBytes(InputStream is, BlobBuilder bb) throws IOException {
        try {
            bb.append(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
    }

    private void checkDate(Blob content) throws IOException, ServiceException {
        if (this.date == null && this.getCredentials().isHackEnabled(ImapCredentials.EnabledHack.THUNDERBIRD)) {
            this.date = AppendMessage.getSentDate(content);
        }
        if (this.date != null && this.date.getTime() > 2147483647000L) {
            ZimbraLog.imap.info("APPEND failed: date out of range");
            throw ServiceException.FAILURE("APPEND failed (date out of range)", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date getSentDate(Blob content) throws IOException {
        Date date;
        BufferedInputStream is = new BufferedInputStream(content.getInputStream());
        try {
            date = AppendMessage.getSentDate(new InternetHeaders((InputStream)is));
            Object var5_4 = null;
        }
        catch (MessagingException e) {
            Date date2;
            try {
                date2 = null;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
            return date2;
        }
        ByteUtil.closeStream(is);
        return date;
    }

    public static Date getSentDate(InternetHeaders ih) throws MessagingException {
        String s = ih.getHeader("Date", null);
        if (s != null) {
            try {
                return new MailDateFormat().parse(s);
            }
            catch (ParseException pex) {
                return null;
            }
        }
        return null;
    }

    private ImapCredentials getCredentials() {
        return this.handler.getCredentials();
    }

    private class Part {
        Literal literal;
        ImapURL url;

        Part(Literal literal) {
            this.literal = literal;
        }

        Part(ImapURL url) {
            this.url = url;
        }

        InputStream getInputStream() throws IOException, ImapParseException {
            if (this.literal != null) {
                return this.literal.getInputStream();
            }
            return this.url.getContentAsStream(AppendMessage.this.handler, AppendMessage.this.handler.getCredentials(), AppendMessage.this.tag).getSecond();
        }

        void cleanup() {
            if (this.literal != null) {
                this.literal.cleanup();
            }
        }
    }
}

