/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im.provider;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jivesoftware.wildfire.user.User;
import org.jivesoftware.wildfire.user.UserAlreadyExistsException;
import org.jivesoftware.wildfire.user.UserNotFoundException;
import org.jivesoftware.wildfire.user.UserProvider;
import org.xmpp.packet.JID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraUserProvider
implements UserProvider {
    static ZimbraUserProvider sInstance = null;

    static ZimbraUserProvider getInstance() {
        return sInstance;
    }

    public ZimbraUserProvider() {
        sInstance = this;
    }

    public User loadUser(String username, boolean ignoreServerCheck) throws UserNotFoundException {
        username = JID.unescapeNode((String)username);
        try {
            Account acct = this.lookupAccount(username);
            if (acct == null) {
                throw new UserNotFoundException("Unknown user: " + username);
            }
            if (!ignoreServerCheck && !Provisioning.onLocalServer(acct)) {
                throw new UserNotFoundException("User " + username + " is not local to this server");
            }
            String un = acct.getName();
            return new User(un, acct.getAttr("displayName", null), acct.getAttr("zimbraMailDeliveryAddress"), new Date(0L), new Date(0L));
        }
        catch (ServiceException e) {
            throw new UserNotFoundException((Throwable)e);
        }
    }

    Account lookupAccount(String username) throws ServiceException {
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, username);
        return acct;
    }

    public User createUser(String username, String password, String name, String email) throws UserAlreadyExistsException {
        throw new UnsupportedOperationException();
    }

    public void deleteUser(String username) {
        throw new UnsupportedOperationException();
    }

    public int getUserCount() {
        throw new UnsupportedOperationException();
    }

    public Collection<User> getUsers() {
        throw new UnsupportedOperationException();
    }

    public Collection<User> getUsers(int startIndex, int numResults) {
        throw new UnsupportedOperationException();
    }

    public String getPassword(String username) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setPassword(String username, String password) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setName(String username, String name) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void setEmail(String username, String email) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void setCreationDate(String username, Date creationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void setModificationDate(String username, Date modificationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean supportsPasswordRetrieval() {
        return false;
    }

    public Collection<User> findUsers(Set<String> fields, String query) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Collection<User> findUsers(Set<String> fields, String query, int startIndex, int numResults) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Set<String> getSearchFields() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getUsernames() {
        return null;
    }
}

