/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im.provider;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.im.provider.CloudRouteManager;
import com.zimbra.cs.im.provider.CloudRouteSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.wildfire.ChannelHandler;
import org.jivesoftware.wildfire.ClientSession;
import org.jivesoftware.wildfire.RoutableChannelHandler;
import org.jivesoftware.wildfire.RoutingTable;
import org.jivesoftware.wildfire.XMPPServer;
import org.jivesoftware.wildfire.component.InternalComponentManager;
import org.jivesoftware.wildfire.container.BasicModule;
import org.jivesoftware.wildfire.server.OutgoingSessionPromise;
import org.xmpp.packet.JID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraRoutingTableImpl
extends BasicModule
implements RoutingTable {
    private static Log sLog = LogFactory.getLog(ZimbraRoutingTableImpl.class);
    private Map routes = new ConcurrentHashMap();
    private InternalComponentManager componentManager = InternalComponentManager.getInstance();

    public ZimbraRoutingTableImpl() {
        super("Routing table");
    }

    public String dumpRoutingTable() {
        StringBuilder toRet = new StringBuilder("LocalRoutes:");
        for (Map.Entry entry : this.routes.entrySet()) {
            toRet.append(entry.getKey().toString()).append(": ").append(entry.getValue().toString()).append("\n");
        }
        toRet.append("\nCloudRoutes: ").append(CloudRouteManager.dumpRoutingTable());
        return toRet.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoute(JID node, RoutableChannelHandler destination) {
        String resourceJID;
        sLog.debug("Adding route: " + node + " to handler " + destination.toString());
        String nodeJID = node.getNode() == null ? "" : node.getNode();
        String string = resourceJID = node.getResource() == null ? "" : node.getResource();
        if (destination instanceof ClientSession) {
            Object resourceRoutes;
            Object nameRoutes = this.routes.get(node.getDomain());
            if (nameRoutes == null) {
                String string2 = node.getDomain().intern();
                synchronized (string2) {
                    nameRoutes = this.routes.get(node.getDomain());
                    if (nameRoutes == null) {
                        nameRoutes = new ConcurrentHashMap();
                        this.routes.put(node.getDomain(), nameRoutes);
                    }
                }
            }
            if ((resourceRoutes = ((Map)nameRoutes).get(nodeJID)) == null) {
                String string3 = nodeJID.intern();
                synchronized (string3) {
                    resourceRoutes = ((Map)nameRoutes).get(nodeJID);
                    if (resourceRoutes == null) {
                        resourceRoutes = new ConcurrentHashMap();
                        ((Map)nameRoutes).put(nodeJID, resourceRoutes);
                    }
                }
            }
            ((Map)resourceRoutes).put(resourceJID, destination);
        } else {
            this.routes.put(node.getDomain(), destination);
        }
    }

    public ChannelHandler getRoute(JID node) {
        if (node == null) {
            return null;
        }
        return this.getRoute(node.toString(), node.getNode() == null ? "" : node.getNode(), node.getDomain(), node.getResource() == null ? "" : node.getResource());
    }

    protected RoutableChannelHandler getCloudRoute(String node, String domain) {
        try {
            String componentServerName = XMPPServer.getInstance().getServerForComponent(domain);
            if (componentServerName != null) {
                Server componentServer = Provisioning.getInstance().get(Provisioning.ServerBy.name, componentServerName);
                Server localServer = Provisioning.getInstance().getLocalServer();
                if (localServer == componentServer) {
                    return null;
                }
                CloudRouteSession route = CloudRouteManager.get(componentServer);
                if (route == null) {
                    return CloudRouteManager.getInstance();
                }
                return route;
            }
            Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, node + "@" + domain);
            if (acct == null) {
                return null;
            }
            if (!Provisioning.onLocalServer(acct)) {
                Server acctServer = Provisioning.getInstance().getServer(acct);
                if (acctServer == null) {
                    return null;
                }
                CloudRouteSession route = CloudRouteManager.get(acctServer);
                if (route == null) {
                    return CloudRouteManager.getInstance();
                }
                return route;
            }
        }
        catch (ServiceException ex) {
            return null;
        }
        return null;
    }

    private ChannelHandler getRoute(String jid, String node, String domain, String resource) {
        Object route;
        block10: {
            route = null;
            if (!XMPPServer.getInstance().isLocalDomain(domain) && this.routes.get(domain) == null && !XMPPServer.getInstance().isCloudComponent(domain)) {
                OutgoingSessionPromise toRet = OutgoingSessionPromise.getInstance();
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Returning OutgoingSessionPromise route for jid:" + jid + " node:" + node + " domain:" + domain + " resource:" + resource + " result=" + toRet);
                }
                return toRet;
            }
            RoutableChannelHandler remoteInThisCloud = this.getCloudRoute(node, domain);
            if (remoteInThisCloud != null) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Returning CloudRoute for jid:" + jid + " node:" + node + " domain:" + domain + " resource:" + resource + " result=" + remoteInThisCloud);
                }
                return remoteInThisCloud;
            }
            try {
                Object nameRoutes = this.routes.get(domain);
                if (nameRoutes instanceof ChannelHandler) {
                    route = (RoutableChannelHandler)nameRoutes;
                } else if (nameRoutes != null) {
                    Object resourceRoutes = ((Map)nameRoutes).get(node);
                    route = resourceRoutes instanceof ChannelHandler ? (RoutableChannelHandler)resourceRoutes : (resourceRoutes != null ? (RoutableChannelHandler)((Map)resourceRoutes).get(resource) : null);
                }
            }
            catch (Exception e) {
                if (!org.jivesoftware.util.Log.isDebugEnabled()) break block10;
                org.jivesoftware.util.Log.debug((String)("Route not found for JID: " + jid), (Throwable)e);
            }
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("Returning local route for jid:" + jid + " node:" + node + " domain:" + domain + " resource:" + resource + " result=" + route);
        }
        return route;
    }

    public List<ChannelHandler> getRoutes(JID node) {
        if (!XMPPServer.getInstance().isLocalDomain(node.getDomain()) && this.routes.get(node.getDomain()) == null && !XMPPServer.getInstance().isCloudComponent(node.getDomain())) {
            ArrayList<ChannelHandler> list = new ArrayList<ChannelHandler>();
            OutgoingSessionPromise toRet = OutgoingSessionPromise.getInstance();
            if (sLog.isDebugEnabled()) {
                sLog.debug("Returning OutgoingSessionPromise route for jid:" + node + " result=" + toRet);
            }
            list.add((ChannelHandler)toRet);
            return list;
        }
        RoutableChannelHandler remoteInThisCloud = this.getCloudRoute(node.getNode(), node.getDomain());
        if (remoteInThisCloud != null) {
            ArrayList<ChannelHandler> list = new ArrayList<ChannelHandler>();
            list.add((ChannelHandler)remoteInThisCloud);
            if (sLog.isDebugEnabled()) {
                sLog.debug("Returning CloudRoute for jid:" + node + " result=" + remoteInThisCloud);
            }
            return list;
        }
        LinkedList<Object> list = null;
        Object nameRoutes = this.routes.get(node.getDomain());
        if (nameRoutes != null) {
            if (nameRoutes instanceof ChannelHandler) {
                list = new LinkedList<ChannelHandler>();
                list.add(nameRoutes);
            } else if (node.getNode() == null) {
                list = new LinkedList();
                this.getRoutes(list, (Map)nameRoutes);
            } else {
                Object resourceRoutes = ((Map)nameRoutes).get(node.getNode());
                if (resourceRoutes != null) {
                    if (resourceRoutes instanceof ChannelHandler) {
                        list = new LinkedList();
                        list.add(resourceRoutes);
                    } else if (node.getResource() == null || node.getResource().length() == 0) {
                        list = new LinkedList();
                        this.getRoutes(list, (Map)resourceRoutes);
                    } else {
                        Object entry = ((Map)resourceRoutes).get(node.getResource());
                        if (entry != null) {
                            list = new LinkedList();
                            list.add(entry);
                        }
                    }
                }
            }
        }
        if (list == null) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Returning null local route for jid:" + node);
            }
            return Collections.emptyList();
        }
        if (sLog.isDebugEnabled()) {
            StringBuilder routes = new StringBuilder();
            boolean atFirst = false;
            for (Object e : list) {
                if (!atFirst) {
                    routes.append(", ");
                }
                routes.append("route=").append(e);
            }
            sLog.debug("Returning local route for " + node + " result=" + routes);
        }
        return list;
    }

    private void getRoutes(LinkedList list, Map table) {
        for (Object entry : table.values()) {
            if (entry instanceof ConcurrentHashMap) {
                this.getRoutes(list, (Map)entry);
                continue;
            }
            if (list.contains(entry)) continue;
            list.add(entry);
        }
    }

    public ChannelHandler getBestRoute(JID node) {
        ChannelHandler route = this.getRoute(node);
        if (route == null) {
            String nodeJID = node.getNode() == null ? "" : node.getNode();
            route = this.getRoute(node.toBareJID(), nodeJID, node.getDomain(), "");
        }
        return route;
    }

    public ChannelHandler removeRoute(JID node) {
        if (sLog.isDebugEnabled()) {
            Object currentRoute = this.routes.get(node);
            if (currentRoute == null) {
                currentRoute = "none";
            }
            sLog.debug("Removing route: " + node + "(current route: " + currentRoute.toString() + ")");
        }
        ChannelHandler route = null;
        String nodeJID = node.getNode() == null ? "" : node.getNode();
        String resourceJID = node.getResource() == null ? "" : node.getResource();
        try {
            Object nameRoutes = this.routes.get(node.getDomain());
            if (nameRoutes instanceof ConcurrentHashMap) {
                Object resourceRoutes = ((Map)nameRoutes).get(nodeJID);
                if (resourceRoutes instanceof ConcurrentHashMap) {
                    route = (ChannelHandler)((Map)resourceRoutes).remove(resourceJID);
                    if (((Map)resourceRoutes).isEmpty()) {
                        ((Map)nameRoutes).remove(nodeJID);
                        if (((Map)nameRoutes).isEmpty()) {
                            this.routes.remove(node.getDomain());
                        }
                    }
                } else {
                    ((Map)nameRoutes).remove(nodeJID);
                }
            } else if (nameRoutes != null && ("".equals(nodeJID) && "".equals(resourceJID) || ((RoutableChannelHandler)nameRoutes).getAddress().equals((Object)node))) {
                this.routes.remove(node.getDomain());
            }
        }
        catch (Exception e) {
            org.jivesoftware.util.Log.error((String)"Error removing route", (Throwable)e);
        }
        return route;
    }

    public void initialize(XMPPServer server) {
        super.initialize(server);
    }
}

