/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im.provider;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.XMPPComponent;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.wildfire.LocationManager;
import org.jivesoftware.wildfire.user.UserNotFoundException;
import org.xmpp.packet.JID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraLocationManager
implements LocationManager {
    private static final ZimbraLocationManager sInstance = new ZimbraLocationManager();

    private CloudComponentIdentifier fromXMPPComponent(XMPPComponent in) throws ServiceException {
        CloudComponentIdentifier toRet = new CloudComponentIdentifier();
        toRet.serverId = in.getServerId();
        toRet.serviceDomain = in.getName();
        toRet.serviceName = in.getShortName();
        toRet.category = in.getComponentCategory();
        toRet.type = in.getComponentType();
        toRet.features = in.getComponentFeatures();
        toRet.className = in.getClassName();
        return toRet;
    }

    private List<XMPPComponent> getCloudComponents() throws ServiceException {
        return Provisioning.getInstance().getAllXMPPComponents();
    }

    public List<LocationManager.ComponentIdentifier> getAllServerComponents() throws ServiceException {
        ArrayList<LocationManager.ComponentIdentifier> toRet = new ArrayList<LocationManager.ComponentIdentifier>();
        for (XMPPComponent component : this.getCloudComponents()) {
            try {
                toRet.add(this.fromXMPPComponent(component));
            }
            catch (ServiceException ex) {
                ZimbraLog.im.warn((Object)("XMPP Component configuration invalid for: " + component + ", disabled"), ex);
            }
        }
        return toRet;
    }

    public List<LocationManager.ComponentIdentifier> getRemoteServerComponents() throws ServiceException {
        ArrayList<LocationManager.ComponentIdentifier> toRet = new ArrayList<LocationManager.ComponentIdentifier>();
        String serverId = Provisioning.getInstance().getLocalServer().getId();
        for (XMPPComponent component : this.getCloudComponents()) {
            if (serverId.equals(component.getServerId())) continue;
            try {
                toRet.add(this.fromXMPPComponent(component));
            }
            catch (ServiceException ex) {
                ZimbraLog.im.warn((Object)("XMPP Component configuration invalid for: " + component + ", disabled"), ex);
            }
        }
        return toRet;
    }

    public List<LocationManager.ComponentIdentifier> getThisServerComponents(String componentType) throws ServiceException {
        ArrayList<LocationManager.ComponentIdentifier> toRet = new ArrayList<LocationManager.ComponentIdentifier>();
        String serverId = Provisioning.getInstance().getLocalServer().getId();
        for (XMPPComponent component : this.getCloudComponents()) {
            if (!serverId.equals(component.getServerId()) || componentType != null && !componentType.equals(component.getComponentType())) continue;
            try {
                toRet.add(this.fromXMPPComponent(component));
            }
            catch (ServiceException ex) {
                ZimbraLog.im.warn((Object)("XMPP Component configuration invalid for: " + component + ", disabled"), ex);
            }
        }
        return toRet;
    }

    public boolean isCloudComponent(String domain) {
        try {
            if (domain == null || domain.length() < 3) {
                return false;
            }
            for (XMPPComponent component : this.getCloudComponents()) {
                if (!domain.equals(component.getName())) continue;
                return true;
            }
        }
        catch (ServiceException ex) {
            ZimbraLog.im.warn((Object)("Ignoring exception in ZimbraLocationManager.isCloudComponent(" + domain + ")"), ex);
        }
        return false;
    }

    public String getServerForComponent(String domain) {
        if (domain == null || domain.length() < 3) {
            return null;
        }
        try {
            for (XMPPComponent component : this.getCloudComponents()) {
                if (!domain.equals(component.getName())) continue;
                return component.getServer().getName();
            }
        }
        catch (ServiceException ex) {
            ZimbraLog.im.warn((Object)("Ignoring exception in ZimbraLocationManager.getServerForComponent(" + domain + ")"), ex);
        }
        return null;
    }

    public static ZimbraLocationManager getInstance() {
        return sInstance;
    }

    private ZimbraLocationManager() {
    }

    public boolean isLocal(String username) throws UserNotFoundException {
        return this.isLocal(new JID(username));
    }

    public boolean isLocal(JID jid) throws UserNotFoundException {
        if (jid.getNode() == null || jid.getDomain() == null) {
            return false;
        }
        try {
            String node = jid.getNode();
            node = JID.unescapeNode((String)node);
            Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, node + "@" + jid.getDomain());
            if (acct == null) {
                throw new UserNotFoundException("Unable to find user: " + jid.toString());
            }
            return Provisioning.onLocalServer(acct);
        }
        catch (ServiceException ex) {
            return false;
        }
    }

    public boolean isRemote(JID jid) throws UserNotFoundException {
        return !this.isLocal(jid);
    }

    static class CloudComponentIdentifier
    extends LocationManager.ComponentIdentifier {
        public String serverId;

        CloudComponentIdentifier() {
        }
    }
}

