/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im.provider;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.db.DbPool;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.jivesoftware.database.ConnectionProvider;

public class ZimbraConnectionProvider
implements ConnectionProvider {
    public boolean isPooled() {
        return true;
    }

    public Connection getConnection() throws SQLException {
        try {
            DbPool.Connection conn = DbPool.getConnection();
            if (conn == null) {
                return null;
            }
            return new ZimbraConnection(conn);
        }
        catch (ServiceException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException("Caught ServiceException: " + ex.toString());
        }
    }

    public void restart() {
    }

    public void start() {
    }

    public void destroy() {
    }

    private static class ZimbraConnection
    extends DelegatingConnection {
        private DbPool.Connection mConnection;

        ZimbraConnection(DbPool.Connection conn) {
            super(conn.getConnection());
            this.mConnection = conn;
        }

        public void close() throws SQLException {
            try {
                this.mConnection.close();
            }
            catch (ServiceException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException("Caught ServiceException " + ex.toString());
            }
        }

        public void commit() throws SQLException {
            try {
                this.mConnection.commit();
            }
            catch (ServiceException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException("Caught ServiceException " + ex.toString());
            }
        }

        public void rollback() throws SQLException {
            try {
                this.mConnection.rollback();
            }
            catch (ServiceException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException("Caught ServiceException: " + ex);
            }
        }

        public void setTransactionIsolation(int level) throws SQLException {
            try {
                this.mConnection.setTransactionIsolation(level);
            }
            catch (ServiceException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException("Caught ServiceException: " + ex);
            }
        }
    }
}

