/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im.provider;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class ServerDialbackKey {
    public static final int KEY_SIZE_BYTES = 32;
    private byte[] mKey;
    private long mVersion;
    private long mCreated;
    private static HashMap<String, ServerDialbackKey> mCache = new HashMap();
    private static ServerDialbackKey sLatestKey;

    private ServerDialbackKey(long version, byte[] key) throws ServiceException {
        this.mVersion = version;
        this.mCreated = System.currentTimeMillis();
        if (key != null) {
            this.mKey = key;
        } else {
            SecureRandom random = new SecureRandom();
            this.mKey = new byte[32];
            random.nextBytes(this.mKey);
        }
    }

    private ServerDialbackKey(String k) throws ServiceException {
        String[] parts = k.split(":");
        if (parts.length != 3) {
            throw ServiceException.INVALID_REQUEST("invalid auth token key", null);
        }
        String ver = parts[0];
        String created = parts[1];
        String data = parts[2];
        try {
            this.mVersion = Long.parseLong(ver);
        }
        catch (NumberFormatException e) {
            throw ServiceException.INVALID_REQUEST("invalid auth token key version", e);
        }
        try {
            this.mCreated = Long.parseLong(created);
        }
        catch (NumberFormatException e) {
            throw ServiceException.INVALID_REQUEST("invalid auth token key created data", e);
        }
        try {
            this.mKey = Hex.decodeHex((char[])data.toCharArray());
        }
        catch (DecoderException e) {
            throw ServiceException.INVALID_REQUEST("invalid auth token key data", e);
        }
    }

    public String getEncoded() {
        return this.mVersion + ":" + this.mCreated + ":" + new String(Hex.encodeHex((byte[])this.mKey));
    }

    private static synchronized void refresh(boolean reload) throws ServiceException {
        String[] keys;
        Provisioning prov = Provisioning.getInstance();
        Config config = prov.getConfig();
        if (reload) {
            prov.reload(config);
        }
        if ((keys = config.getMultiAttr("zimbraAuthTokenKey")).length == 0) {
            prov.reload(config);
            keys = config.getMultiAttr("zimbraAuthTokenKey");
        }
        if (keys.length == 0) {
            ServerDialbackKey key = new ServerDialbackKey(0L, null);
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zimbraAuthTokenKey", key.getEncoded());
            Provisioning.getInstance().modifyAttrs(config, attrs);
            keys = config.getMultiAttr("zimbraAuthTokenKey");
        }
        for (int i = 0; i < keys.length; ++i) {
            ServerDialbackKey key = mCache.get(keys[i]);
            if (key != null) continue;
            key = new ServerDialbackKey(keys[i]);
            mCache.put(keys[i], key);
            mCache.put(Long.toString(key.mVersion), key);
            if (sLatestKey != null && ServerDialbackKey.sLatestKey.mVersion >= key.mVersion) continue;
            sLatestKey = key;
        }
    }

    static synchronized ServerDialbackKey getCurrentKey() throws ServiceException {
        if (sLatestKey == null) {
            ServerDialbackKey.refresh(false);
        }
        return sLatestKey;
    }

    byte[] getKey() {
        return this.mKey;
    }

    public static String getHmac(String data) throws ServiceException {
        try {
            ByteKey bk = new ByteKey(ServerDialbackKey.getCurrentKey().getKey());
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(bk);
            return new String(Hex.encodeHex((byte[])mac.doFinal(data.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("fatal error", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("fatal error", e);
        }
    }

    static class ByteKey
    implements SecretKey {
        private static final long serialVersionUID = 7300100462083389328L;
        private byte[] mKey;

        ByteKey(byte[] key) {
            this.mKey = (byte[])key.clone();
        }

        public byte[] getEncoded() {
            return this.mKey;
        }

        public String getAlgorithm() {
            return "HmacSHA1";
        }

        public String getFormat() {
            return "RAW";
        }
    }
}

