/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im.provider;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ZimbraAuthToken;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.dom4j.Element;
import org.jivesoftware.util.IMConfig;
import org.jivesoftware.wildfire.ChannelHandler;
import org.jivesoftware.wildfire.Connection;
import org.jivesoftware.wildfire.ConnectionCloseListener;
import org.jivesoftware.wildfire.PacketDeliverer;
import org.jivesoftware.wildfire.PacketException;
import org.jivesoftware.wildfire.RoutingTable;
import org.jivesoftware.wildfire.Session;
import org.jivesoftware.wildfire.SessionManager;
import org.jivesoftware.wildfire.StreamID;
import org.jivesoftware.wildfire.XMPPServer;
import org.jivesoftware.wildfire.auth.UnauthorizedException;
import org.jivesoftware.wildfire.net.CloudRoutingSocketReader;
import org.jivesoftware.wildfire.net.SSLConfig;
import org.jivesoftware.wildfire.net.SocketConnection;
import org.jivesoftware.wildfire.net.StdSocketConnection;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;
import org.xmpp.packet.StreamError;

public class CloudRouteSession
extends Session {
    private static RoutingTable sRoutingTable = XMPPServer.getInstance().getRoutingTable();
    private Server mServer;
    private static CloseListener sCloseListener = new CloseListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudRouteSession create(String hostname, CloudRoutingSocketReader reader, SocketConnection connection, Element streamElt) {
        String encodedAuthToken = streamElt.attributeValue("authtoken");
        try {
            AuthToken token = AuthToken.getAuthToken(encodedAuthToken);
            if (token.isAdmin()) {
                CloudRouteSession toRet = new CloudRouteSession((Connection)connection, XMPPServer.getInstance().getSessionManager().nextStreamID());
                connection.init((Session)toRet);
                ZimbraLog.im.info("Accepted CloudRouting connection from host " + connection.toString());
                CloseListener closeListener = sCloseListener;
                synchronized (closeListener) {
                    connection.registerCloseListener((ConnectionCloseListener)sCloseListener, (Object)toRet);
                    SessionManager.getInstance().registerCloudRoutingSession((Session)toRet);
                }
                return toRet;
            }
            ZimbraLog.im.warn("Rejecting CloudRouting connection -- Got non-admin auth token on cloud routing connection from " + connection.toString() + " token = " + token);
        }
        catch (Exception e) {
            ZimbraLog.im.warn((Object)("Rejecting CloudRouting connection -- caught exception attempting to create CloudRoutingSession from " + connection.toString()), e);
        }
        StreamError error = new StreamError(StreamError.Condition.not_authorized);
        connection.deliverRawText(error.toXML());
        connection.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CloudRouteSession connect(Server targetServer) throws Exception {
        String hostname = targetServer.getAttr("zimbraServiceHostname");
        int port = IMConfig.XMPP_CLOUDROUTING_PORT.getInt();
        AuthToken adminAuthToken = ZimbraAuthToken.getZimbraAdminAuthToken();
        Socket socket = SSLConfig.createSSLSocket();
        try {
            ZimbraLog.im.info("LocalCloudRoute: Trying to connect (3)  " + hostname + ":" + port);
            socket.connect(new InetSocketAddress(hostname, port), 30000);
            ZimbraLog.im.debug("LocalCloudRoute: Plain connection to " + hostname + ":" + port + " successful");
            StdSocketConnection connection = new StdSocketConnection((PacketDeliverer)new ErrorPacketDeliverer(), socket, false);
            StringBuilder openingStream = new StringBuilder();
            openingStream.append("<stream:stream");
            openingStream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
            openingStream.append(" xmlns=\"jabber:cloudrouting\"");
            openingStream.append(" to=\"").append(hostname).append("\"");
            openingStream.append(" authtoken=\"").append(adminAuthToken.getEncoded()).append("\"");
            openingStream.append(" version=\"1.0\">\n");
            ZimbraLog.im.debug("LocalCloudRoute - Sending stream header: " + openingStream.toString());
            connection.deliverRawText(openingStream.toString());
            CloudRoutingSocketReader ssReader = new CloudRoutingSocketReader(XMPPServer.getInstance().getPacketRouter(), XMPPServer.getInstance().getRoutingTable(), socket, (SocketConnection)connection);
            Thread readerThread = new Thread((Runnable)ssReader, "CloudRoutingReaderThread-" + connection.toString());
            readerThread.setDaemon(true);
            readerThread.start();
            CloudRouteSession toRet = new CloudRouteSession(targetServer, (Connection)connection, XMPPServer.getInstance().getSessionManager().nextStreamID());
            connection.init((Session)toRet);
            ssReader.setSession((Session)toRet);
            CloseListener closeListener = sCloseListener;
            synchronized (closeListener) {
                connection.registerCloseListener((ConnectionCloseListener)sCloseListener, (Object)toRet);
                SessionManager.getInstance().registerCloudRoutingSession((Session)toRet);
            }
            return toRet;
        }
        catch (Exception e) {
            if (ZimbraLog.im.isDebugEnabled()) {
                ZimbraLog.im.debug((Object)("Error trying to connect to remote server: " + hostname + ":" + port), e);
            } else if (ZimbraLog.im.isInfoEnabled()) {
                ZimbraLog.im.info("Error trying to connect to remote server: " + hostname + ":" + port);
            }
            throw e;
        }
    }

    private static void remoteDeliveryFailed(Packet packet) {
        JID from = packet.getFrom();
        JID to = packet.getTo();
        ZimbraLog.im.debug("CloudRouteSession.remoteDeliveryFailed for packet " + packet);
        try {
            if (packet instanceof IQ) {
                IQ reply = new IQ();
                reply.setID(((IQ)packet).getID());
                reply.setTo(from);
                reply.setFrom(to);
                reply.setChildElement(((IQ)packet).getChildElement().createCopy());
                reply.setError(PacketError.Condition.remote_server_not_found);
                ChannelHandler route = sRoutingTable.getRoute(reply.getTo());
                if (route != null) {
                    route.process((Packet)reply);
                }
            } else if (packet instanceof Presence) {
                Presence reply = new Presence();
                reply.setID(packet.getID());
                reply.setTo(from);
                reply.setFrom(to);
                reply.setError(PacketError.Condition.remote_server_not_found);
                ChannelHandler route = sRoutingTable.getRoute(reply.getTo());
                if (route != null) {
                    route.process((Packet)reply);
                }
            } else if (packet instanceof Message) {
                Message reply = new Message();
                reply.setID(packet.getID());
                reply.setTo(from);
                reply.setFrom(to);
                reply.setType(((Message)packet).getType());
                reply.setThread(((Message)packet).getThread());
                reply.setError(PacketError.Condition.remote_server_not_found);
                ChannelHandler route = sRoutingTable.getRoute(reply.getTo());
                if (route != null) {
                    route.process((Packet)reply);
                }
            }
        }
        catch (UnauthorizedException e) {
        }
        catch (Exception e) {
            ZimbraLog.im.warn((Object)("Error returning error to sender. Original packet: " + packet), e);
        }
    }

    private CloudRouteSession(Connection conn, StreamID streamID) {
        super("cloudroute.fake.domain.com", conn, streamID);
        this.mServer = null;
    }

    private CloudRouteSession(Server targetServer, Connection conn, StreamID streamID) {
        super(targetServer.getName(), conn, streamID);
        this.mServer = targetServer;
    }

    public JID getAddress() {
        if (this.mServer != null) {
            return new JID(this.mServer.getName());
        }
        return null;
    }

    public String getAvailableStreamFeatures() {
        return null;
    }

    public void process(Packet packet) throws UnauthorizedException, PacketException {
        String curHopCount = packet.getElement().attributeValue("x-zimbra-hopcount", "0");
        int hopCount = Integer.parseInt(curHopCount);
        packet.getElement().addAttribute("x-zimbra-hopcount", Integer.toString(++hopCount));
        if (hopCount < 5 && this.conn != null && !this.conn.isClosed()) {
            ZimbraLog.im.debug("CloudRouteSession delivering packet: " + packet);
            this.conn.deliver(packet);
        } else {
            CloudRouteSession.remoteDeliveryFailed(packet);
        }
    }

    Server getServer() {
        return this.mServer;
    }

    private static class ErrorPacketDeliverer
    implements PacketDeliverer {
        private ErrorPacketDeliverer() {
        }

        public void deliver(Packet packet) throws UnauthorizedException, PacketException {
            CloudRouteSession.remoteDeliveryFailed(packet);
        }
    }

    private static class CloseListener
    implements ConnectionCloseListener {
        private CloseListener() {
        }

        public synchronized void onConnectionClose(Object handback) {
            SessionManager.getInstance().unregisterCloudRoutingSession((Session)handback);
        }
    }
}

