/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im.provider;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.im.provider.CloudRouteSession;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.wildfire.ConnectionCloseListener;
import org.jivesoftware.wildfire.server.OutgoingSessionPromise;
import org.xmpp.packet.Packet;

public class CloudRouteManager
extends OutgoingSessionPromise {
    private static ConcurrentHashMap<Server, CloudRouteSession> localServers = new ConcurrentHashMap();
    private static final CloudConnectionCloseListener sCloseListener = new CloudConnectionCloseListener();
    private static CloudRouteManager sInstance = new CloudRouteManager();

    public static CloudRouteSession get(Server server) {
        return localServers.get(server);
    }

    public static CloudRouteManager getInstance() {
        return sInstance;
    }

    public static String dumpRoutingTable() {
        StringBuilder toRet = new StringBuilder();
        for (Map.Entry<Server, CloudRouteSession> entry : localServers.entrySet()) {
            toRet.append(entry.getKey().getName().toString()).append(": ").append(entry.getValue().toString()).append("\n");
        }
        return toRet.toString();
    }

    static void remove(Server server, CloudRouteSession route) {
        localServers.remove(server, (Object)route);
    }

    private CloudRouteManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSessionAndSendPacket(Packet packet) throws Exception {
        String node = packet.getTo().getNode();
        String domain = packet.getTo().getDomain();
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, node + "@" + domain);
        if (!Provisioning.onLocalServer(acct)) {
            Server acctServer = Provisioning.getInstance().getServer(acct);
            CloudRouteSession route = localServers.get(acctServer);
            if (route == null) {
                CloudRouteManager cloudRouteManager = this;
                synchronized (cloudRouteManager) {
                    route = localServers.get(acctServer);
                    if (route == null) {
                        route = CloudRouteSession.connect(acctServer);
                        localServers.put(acctServer, route);
                        route.getConnection().registerCloseListener((ConnectionCloseListener)sCloseListener, (Object)route);
                    }
                }
            }
            if (route != null) {
                route.process(packet);
            } else {
                ZimbraLog.im.info("Failed to connect to cloud server: " + acctServer.getName() + " for account " + acct.getName());
                throw new Exception("Failed to connect to cloud server: " + acctServer.getName());
            }
        }
    }

    private static final class CloudConnectionCloseListener
    implements ConnectionCloseListener {
        private CloudConnectionCloseListener() {
        }

        public void onConnectionClose(Object handback) {
            CloudRouteSession route = (CloudRouteSession)((Object)handback);
            Server server = route.getServer();
            if (server != null) {
                CloudRouteManager.remove(server, route);
            }
        }
    }
}

