/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.im.PacketInterceptor;
import com.zimbra.cs.im.interop.Interop;
import com.zimbra.cs.im.interop.InteropRegistrationProvider;
import com.zimbra.cs.im.provider.CloudRouteSession;
import com.zimbra.cs.im.provider.IMServerConfig;
import com.zimbra.cs.im.provider.InteropRegistrationProviderImpl;
import com.zimbra.cs.im.provider.ZimbraLocationManager;
import java.util.ArrayList;
import org.dom4j.Element;
import org.jivesoftware.util.LdapConfig;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.wildfire.LocationManager;
import org.jivesoftware.wildfire.Session;
import org.jivesoftware.wildfire.XMPPServer;
import org.jivesoftware.wildfire.interceptor.InterceptorManager;
import org.jivesoftware.wildfire.net.CloudRoutingSocketReader;
import org.jivesoftware.wildfire.net.SocketConnection;
import org.xmpp.component.ComponentManager;

public class ZimbraIM {
    private static boolean sRunning = false;

    public static synchronized void startup() throws ServiceException {
        try {
            LdapConfig.setProvider((LdapConfig.ServerConfigProvider)new IMServerConfig());
            final ArrayList<String> domainStrs = new ArrayList<String>();
            String defaultDomain = Provisioning.getInstance().getConfig().getAttr("zimbraDefaultDomainName", null);
            if (defaultDomain != null) {
                ZimbraLog.im.info("Setting default XMPP domain to: " + defaultDomain);
                domainStrs.add(defaultDomain);
            }
            NamedEntry.Visitor visitor = new NamedEntry.Visitor(){

                public void visit(NamedEntry entry) {
                    domainStrs.add(entry.getName());
                }
            };
            Provisioning.getInstance().getAllDomains(visitor, new String[]{"zimbraDomainName"});
            LocaleUtils.sMsgsClassLoader = L10nUtil.getMsgClassLoader();
            CloudRoutingSocketReader.setSessionFactory((CloudRoutingSocketReader.CloudRoutingSessionFactory)new CloudRoutingSocketReader.CloudRoutingSessionFactory(){

                public Session createSession(String hostname, CloudRoutingSocketReader reader, SocketConnection connection, Element streamElt) {
                    return CloudRouteSession.create(hostname, reader, connection, streamElt);
                }
            });
            ZimbraLocationManager locMgr = ZimbraLocationManager.getInstance();
            String[] excludedCiphers = Provisioning.getInstance().getConfig().getMultiAttr("zimbraSSLExcludeCipherSuites");
            XMPPServer srv = new XMPPServer(excludedCiphers, (LocationManager)locMgr, domainStrs);
            InterceptorManager.getInstance().addInterceptor((org.jivesoftware.wildfire.interceptor.PacketInterceptor)new PacketInterceptor());
            Interop.getInstance().start(XMPPServer.getInstance(), (ComponentManager)XMPPServer.getInstance().getInternalComponentManager());
            Interop.setDataProvider((InteropRegistrationProvider)new InteropRegistrationProviderImpl());
            sRunning = true;
        }
        catch (Exception e) {
            ZimbraLog.system.warn("Could not start XMPP server: " + e.toString());
            e.printStackTrace();
        }
    }

    public static synchronized void shutdown() {
        XMPPServer instance = XMPPServer.getInstance();
        if (instance != null) {
            instance.stop();
        }
        if (sRunning) {
            sRunning = false;
        }
    }
}

