/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.cs.im.IMAddr;

public class PrivacyListEntry {
    public static final byte BLOCK_MESSAGES = 1;
    public static final byte BLOCK_PRESENCE_OUT = 2;
    public static final byte BLOCK_PRESENCE_IN = 4;
    public static final byte BLOCK_IQ = 8;
    public static final byte BLOCK_ALL = 15;
    private IMAddr mAddr;
    private int mOrder;
    private byte mBlockTypes;
    private Action mAction;

    public PrivacyListEntry(IMAddr addr, int order, Action action, byte blockTypes) {
        this.mAddr = addr;
        this.mOrder = order;
        this.mBlockTypes = blockTypes;
        this.mAction = action;
    }

    public boolean isBlockMessages() {
        return (this.mBlockTypes & 1) != 0;
    }

    public boolean isBlockPresenceOut() {
        return (this.mBlockTypes & 2) != 0;
    }

    public boolean isBlockPresenceIn() {
        return (this.mBlockTypes & 4) != 0;
    }

    public boolean isBlockIQ() {
        return (this.mBlockTypes & 8) != 0;
    }

    public IMAddr getAddr() {
        return this.mAddr;
    }

    public int getOrder() {
        return this.mOrder;
    }

    public byte getTypes() {
        return this.mBlockTypes;
    }

    public Action getAction() {
        return this.mAction;
    }

    public String toString() {
        try {
            return this.toXml(null).toString();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            return ex.toString();
        }
    }

    public Element toXml(Element parent) throws ServiceException {
        Element item = parent != null ? parent.addElement("item") : Element.create(SoapProtocol.Soap12, "item");
        item.addAttribute("addr", this.getAddr().toString());
        item.addAttribute("action", this.mAction.name());
        item.addAttribute("order", this.getOrder());
        if (this.getTypes() != 15) {
            if (this.isBlockMessages()) {
                item.addElement("message");
            }
            if (this.isBlockPresenceOut()) {
                item.addElement("presence-out");
            }
            if (this.isBlockPresenceIn()) {
                item.addElement("presence-in");
            }
            if (this.isBlockIQ()) {
                item.addElement("iq");
            }
        }
        return item;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        allow,
        deny;

    }
}

