/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.cs.im.PrivacyListEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivacyList
implements Iterable<PrivacyListEntry> {
    private String mName;
    private List<PrivacyListEntry> mList = new ArrayList<PrivacyListEntry>();
    private Set<Integer> mOrders = new HashSet<Integer>();

    public PrivacyList(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        try {
            return this.toXml(null).toString();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            return ex.toString();
        }
    }

    public Element toXml(Element parent) throws ServiceException {
        Element list = parent != null ? parent.addElement("list") : Element.create(SoapProtocol.Soap12, "list");
        list.addAttribute("name", this.mName);
        for (PrivacyListEntry entry : this.mList) {
            entry.toXml(list);
        }
        return list;
    }

    public void addEntry(PrivacyListEntry entry) throws DuplicateOrderException {
        if (this.mOrders.contains(entry.getOrder())) {
            throw new DuplicateOrderException();
        }
        this.mOrders.add(entry.getOrder());
        this.mList.add(entry);
    }

    @Override
    public Iterator<PrivacyListEntry> iterator() {
        return this.mList.iterator();
    }

    public static final class DuplicateOrderException
    extends Exception {
        public String toString() {
            return "The privacy list entry's Order value must be unique to the list. " + super.toString();
        }
    }
}

