/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.cs.im.IMPresence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class PresencePriorityMap {
    HashMap<Integer, List<ResourcePresence>> mPriorityMap = new HashMap();

    PresencePriorityMap() {
    }

    boolean isEmpty() {
        return this.mPriorityMap.isEmpty();
    }

    void addPresenceUpdate(String resource, IMPresence pres) {
        if (resource == null) {
            resource = "";
        }
        this.removePresence(resource);
        List<ResourcePresence> list = this.mPriorityMap.get(pres.getPriority());
        if (list == null) {
            list = new ArrayList<ResourcePresence>();
            this.mPriorityMap.put(Integer.valueOf(pres.getPriority()), list);
        }
        list.add(new ResourcePresence(resource, pres));
    }

    void removePresence(String resource) {
        if (resource == null) {
            resource = "";
        }
        Iterator<List<ResourcePresence>> listIter = this.mPriorityMap.values().iterator();
        while (listIter.hasNext()) {
            List<ResourcePresence> list = listIter.next();
            Iterator<ResourcePresence> rpIter = list.iterator();
            while (rpIter.hasNext()) {
                ResourcePresence rp = rpIter.next();
                if (!rp.resource.equals(resource)) continue;
                rpIter.remove();
            }
            if (list.size() != 0) continue;
            listIter.remove();
        }
    }

    IMPresence getEffectivePresence() {
        ArrayList<Integer> priorities = new ArrayList<Integer>();
        priorities.addAll(this.mPriorityMap.keySet());
        Collections.sort(priorities);
        if (priorities.size() > 0) {
            int priority = (Integer)priorities.get(priorities.size() - 1);
            List<ResourcePresence> list = this.mPriorityMap.get(priority);
            ResourcePresence toRet = null;
            for (ResourcePresence rp : list) {
                if (rp.resource.length() == 0) {
                    toRet = rp;
                    break;
                }
                toRet = rp;
            }
            if (toRet != null) {
                return toRet.presence;
            }
        }
        return IMPresence.UNAVAILABLE;
    }

    public static void main(String[] args) {
        PresencePriorityMap map = new PresencePriorityMap();
        IMPresence check = map.getEffectivePresence();
        assert (check.getShow() == IMPresence.Show.OFFLINE);
        map.addPresenceUpdate("foo", new IMPresence(IMPresence.Show.AWAY, 0, ""));
        map.addPresenceUpdate("bar", new IMPresence(IMPresence.Show.CHAT, 0, ""));
        check = map.getEffectivePresence();
        assert (check.getShow() == IMPresence.Show.CHAT);
        assert (check.getPriority() == 0);
        map.addPresenceUpdate("foo", new IMPresence(IMPresence.Show.DND, 1, ""));
        check = map.getEffectivePresence();
        assert (check.getShow() == IMPresence.Show.DND);
        assert (check.getPriority() == 1);
        map.removePresence("foo");
        check = map.getEffectivePresence();
        assert (check.getShow() == IMPresence.Show.CHAT);
        assert (check.getPriority() == 0);
        map.removePresence("bar");
        check = map.getEffectivePresence();
        assert (check.getShow() == IMPresence.Show.OFFLINE);
        assert (check.getPriority() == 0);
    }

    private static class ResourcePresence {
        public String resource;
        public IMPresence presence;

        public ResourcePresence(String resource, IMPresence presence) {
            this.resource = resource;
            this.presence = presence;
        }

        public String toString() {
            return (this.resource == null ? "" : this.resource) + ": " + this.presence.toString();
        }
    }
}

