/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMGroup;
import com.zimbra.cs.im.IMNotification;
import java.util.Collection;
import java.util.List;
import org.xmpp.packet.Roster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IMSubscribedNotification
extends IMNotification {
    IMAddr mAddr;
    String mName;
    String[] mGroups;
    boolean mSubscribed;
    boolean mSubscribedFrom;
    Roster.Ask mAsk;

    static IMSubscribedNotification create(IMAddr address, String name, List<IMGroup> groups, boolean subscribedTo, boolean subscribedFrom, Roster.Ask ask) {
        String[] str = new String[groups.size()];
        int i = 0;
        for (IMGroup grp : groups) {
            str[i++] = grp.getName();
        }
        return new IMSubscribedNotification(address, name, str, subscribedTo, subscribedFrom, ask);
    }

    static IMSubscribedNotification create(IMAddr address, String name, Collection<String> groups, boolean subscribedTo, boolean subscribedFrom, Roster.Ask ask) {
        String[] str = new String[groups.size()];
        int i = 0;
        for (String s : groups) {
            str[i++] = s;
        }
        return new IMSubscribedNotification(address, name, str, subscribedTo, subscribedFrom, ask);
    }

    static IMSubscribedNotification create(IMAddr address, String name, String[] groups, boolean subscribedTo, boolean subscribedFrom, Roster.Ask ask) {
        return new IMSubscribedNotification(address, name, groups, subscribedTo, subscribedFrom, ask);
    }

    static IMSubscribedNotification create(IMAddr address, String name, boolean subscribedTo, boolean subscribedFrom, Roster.Ask ask) {
        return new IMSubscribedNotification(address, name, null, subscribedTo, subscribedFrom, ask);
    }

    private IMSubscribedNotification(IMAddr address, String name, String[] groups, boolean subscribedTo, boolean subscribedFrom, Roster.Ask ask) {
        this.mAddr = address;
        this.mName = name;
        this.mGroups = groups;
        this.mSubscribed = subscribedTo;
        this.mSubscribedFrom = subscribedFrom;
        this.mAsk = ask;
    }

    public boolean isSubscribedTo() {
        return this.mSubscribed;
    }

    public boolean isSubscribedFrom() {
        return this.mSubscribedFrom;
    }

    @Override
    public Element toXml(Element parent) {
        ZimbraLog.im.info("IMSubscribedNotification " + this.mAddr + " " + this.mName + " Subscribed=" + this.mSubscribed + (this.mAsk != null ? " Ask=" + this.mAsk.toString() : ""));
        Element e = this.mSubscribed ? IMSubscribedNotification.create(parent, "subscribed") : IMSubscribedNotification.create(parent, "unsubscribed");
        e.addAttribute("name", this.mName);
        if (this.mAsk != null && this.mAsk != Roster.Ask.unsubscribe) {
            e.addAttribute("ask", this.mAsk.name());
        }
        if (this.mGroups != null) {
            e.addAttribute("groups", StringUtil.join(",", this.mGroups));
        }
        e.addAttribute("to", this.mAddr.getAddr());
        return e;
    }
}

