/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMEvent;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.wildfire.PacketRouter;
import org.jivesoftware.wildfire.XMPPServer;
import org.xmpp.packet.Packet;

public class IMRouter {
    private ExecutorService mExecutor = Executors.newSingleThreadExecutor();
    private static final IMRouter sRouter = new IMRouter();

    private IMRouter() {
    }

    public static IMRouter getInstance() {
        return sRouter;
    }

    public IMPersona findPersona(OperationContext octxt, IMAddr addr) throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(Provisioning.getInstance().get(Provisioning.AccountBy.name, addr.getAddr()));
        return mbox.getPersona();
    }

    public void postEvent(IMEvent event) {
        this.mExecutor.execute(event);
    }

    public void postEvent(Packet packet) {
        this.mExecutor.execute(new PostPacket(packet));
    }

    public void shutdown() {
        this.mExecutor.shutdownNow();
    }

    private static final class PostPacket
    implements Runnable {
        Packet mPacket = null;

        PostPacket(Packet packet) {
            this.mPacket = packet;
        }

        public void run() {
            PacketRouter router;
            XMPPServer server = XMPPServer.getInstance();
            if (server != null && (router = server.getPacketRouter()) != null) {
                router.route(this.mPacket);
            }
        }
    }
}

