/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.Metadata;
import org.xmpp.packet.Presence;

public class IMPresence {
    private Show mShow;
    private byte mPriority;
    private String mStatus;
    public static final IMPresence UNAVAILABLE = new IMPresence(Show.OFFLINE, 0, "");
    private static final String FN_SHOW = "h";
    private static final String FN_PRIORITY = "p";
    private static final String FN_STATUS = "t";

    public String toString() {
        return this.mShow.toString() + " pri=" + this.mPriority + " st=" + this.mStatus;
    }

    public IMPresence(Show show, byte prio, String status) {
        assert (show != null);
        this.mShow = show;
        this.mPriority = prio;
        this.mStatus = status;
    }

    public IMPresence(Presence pres) {
        this.mPriority = (byte)pres.getPriority();
        this.mStatus = pres.getStatus();
        Presence.Type ptype = pres.getType();
        if (ptype == null) {
            Presence.Show pShow = pres.getShow();
            this.mShow = Show.ONLINE;
            if (pShow != null) {
                switch (pShow) {
                    case chat: {
                        this.mShow = Show.CHAT;
                        break;
                    }
                    case away: {
                        this.mShow = Show.AWAY;
                        break;
                    }
                    case xa: {
                        this.mShow = Show.XA;
                        break;
                    }
                    case dnd: {
                        this.mShow = Show.DND;
                    }
                }
            }
        } else {
            this.mShow = Show.OFFLINE;
        }
    }

    Presence getXMPPPresence() {
        Presence xmppPresence;
        if (this.getShow() == Show.OFFLINE) {
            xmppPresence = new Presence(Presence.Type.unavailable);
        } else {
            xmppPresence = new Presence();
            if (this.getShow() == Show.CHAT) {
                xmppPresence.setShow(Presence.Show.chat);
            } else if (this.getShow() == Show.AWAY) {
                xmppPresence.setShow(Presence.Show.away);
            } else if (this.getShow() == Show.XA) {
                xmppPresence.setShow(Presence.Show.xa);
            } else if (this.getShow() == Show.DND) {
                xmppPresence.setShow(Presence.Show.dnd);
            }
        }
        if (this.getStatus() != null && this.getStatus().length() > 0) {
            xmppPresence.setStatus(this.getStatus());
        }
        if (this.getPriority() != 0) {
            xmppPresence.setPriority((int)this.getPriority());
        }
        return xmppPresence;
    }

    Metadata encodeAsMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_SHOW, this.mShow.toString());
        meta.put(FN_PRIORITY, Byte.toString(this.mPriority));
        if (this.mStatus != null && this.mStatus.length() > 0) {
            meta.put(FN_STATUS, this.mStatus);
        }
        return meta;
    }

    static IMPresence decodeMetadata(Metadata meta) throws ServiceException {
        Show show = Show.valueOf(meta.get(FN_SHOW));
        byte priority = Byte.parseByte(meta.get(FN_PRIORITY));
        String status = null;
        if (meta.containsKey(FN_STATUS)) {
            status = meta.get(FN_STATUS);
        }
        return new IMPresence(show, priority, status);
    }

    public void toXml(Element parent) {
        Show show = this.mShow;
        if (show != null) {
            parent.addAttribute("show", show.toString());
        }
        if (this.mStatus != null) {
            parent.addAttribute("status", this.mStatus);
        }
    }

    public Show getShow() {
        return this.mShow;
    }

    public byte getPriority() {
        return this.mPriority;
    }

    public String getStatus() {
        return this.mStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Show {
        AWAY,
        CHAT,
        DND,
        XA,
        ONLINE,
        OFFLINE;

    }
}

