/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ClassLogger;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.im.FakeClientConnection;
import com.zimbra.cs.im.GatewayRegistrationStatus;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMChat;
import com.zimbra.cs.im.IMChatCloseNotification;
import com.zimbra.cs.im.IMConferenceRoom;
import com.zimbra.cs.im.IMGatewayStateNotification;
import com.zimbra.cs.im.IMGroup;
import com.zimbra.cs.im.IMMessage;
import com.zimbra.cs.im.IMMessageNotification;
import com.zimbra.cs.im.IMNotification;
import com.zimbra.cs.im.IMOtherLocationNotification;
import com.zimbra.cs.im.IMPresence;
import com.zimbra.cs.im.IMPresenceUpdateNotification;
import com.zimbra.cs.im.IMPrivacyListNotification;
import com.zimbra.cs.im.IMRosterNotification;
import com.zimbra.cs.im.IMRouter;
import com.zimbra.cs.im.IMServiceException;
import com.zimbra.cs.im.IMSubscribeNotification;
import com.zimbra.cs.im.IMSubscribedNotification;
import com.zimbra.cs.im.PresencePriorityMap;
import com.zimbra.cs.im.PrivacyList;
import com.zimbra.cs.im.PrivacyListEntry;
import com.zimbra.cs.im.interop.Interop;
import com.zimbra.cs.im.interop.UserStatus;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.session.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.wildfire.ClientSession;
import org.jivesoftware.wildfire.Connection;
import org.jivesoftware.wildfire.XMPPServer;
import org.jivesoftware.wildfire.auth.AuthToken;
import org.jivesoftware.wildfire.group.Group;
import org.jivesoftware.wildfire.group.GroupManager;
import org.jivesoftware.wildfire.group.GroupNotFoundException;
import org.jivesoftware.wildfire.roster.Roster;
import org.jivesoftware.wildfire.roster.RosterItem;
import org.jivesoftware.wildfire.user.UserNotFoundException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;
import org.xmpp.packet.Roster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMPersona
extends ClassLogger {
    private static final String FN_ADDRESS = "a";
    private static final String FN_INTEROP_SERVICE_PREFIX = "isvc-";
    private Mailbox mMailbox = null;
    private boolean mHaveInitialRoster = false;
    private String mDefaultPrivacyListName = null;
    private Map<IMAddr, IMSubscribedNotification> mRoster = new HashMap<IMAddr, IMSubscribedNotification>();
    private Map<IMAddr, IMSubscribeNotification> mPendingSubscribes = new HashMap<IMAddr, IMSubscribeNotification>();
    private Map<IMAddr, PresencePriorityMap> mBufferedPresence = new HashMap<IMAddr, PresencePriorityMap>();
    private IMAddr mAddr;
    private Map<String, IMChat> mChats = new HashMap<String, IMChat>();
    private int mCurChatId = 0;
    private int mCurRequestId = 0;
    private Map<String, IMGroup> mGroups = new HashMap<String, IMGroup>();
    private Map<Session, IdleInfo> mListeners = new HashMap<Session, IdleInfo>();
    private IMPresence mMyPresence = new IMPresence(IMPresence.Show.ONLINE, 0, null);
    private boolean mIsOnline = false;
    private boolean mIsIdle = false;
    private long mIdleStartTime = 0L;
    private ClientSession mXMPPSession;
    private Map<String, Map<String, String>> mInteropRegistrationData;
    private Map<String, RequestCompletionHandler> mPendingRequests = new HashMap<String, RequestCompletionHandler>();

    public static void deleteIMPersona(String acctName) {
        block6: {
            try {
                if (!Provisioning.getInstance().getLocalServer().getBooleanAttr("zimbraXMPPEnabled", false)) break block6;
                IMAddr addr = new IMAddr(acctName);
                JID jid = addr.makeJID();
                try {
                    XMPPServer.getInstance().getRosterManager().deleteRoster(jid, true);
                }
                catch (Exception e) {
                    ZimbraLog.im.warn((Object)("Exception deleting IM Roster data for: " + acctName), e);
                }
                try {
                    GroupManager.getInstance().deleteUser(jid.toBareJID());
                }
                catch (Exception e) {
                    ZimbraLog.im.warn((Object)("Exception deleting IM Group data for: " + acctName), e);
                }
            }
            catch (Exception e) {
                ZimbraLog.im.warn((Object)("Exception deleting IM data for: " + acctName), e);
            }
        }
    }

    public static void offlineRenameIMPersona(String oldName, String newName) {
        IMPersona.deleteIMPersona(oldName);
    }

    public static IMPersona loadPersona(Mailbox mbox) throws ServiceException {
        IMPersona toRet = null;
        Metadata meta = mbox.getConfig(null, "im");
        IMAddr addr = new IMAddr(mbox.getAccount().getName());
        HashMap<String, Map<String, String>> interopReg = new HashMap<String, Map<String, String>>();
        if (meta != null) {
            String mdAddr = meta.get(FN_ADDRESS, null);
            if (mdAddr != null && mdAddr.equals(addr.getAddr())) {
                toRet = new IMPersona(mbox, addr);
            }
            for (Map.Entry o : meta.asMap().entrySet()) {
                Map.Entry e = o;
                if (!((String)e.getKey()).startsWith(FN_INTEROP_SERVICE_PREFIX)) continue;
                HashMap<String, String> svcData = new HashMap<String, String>();
                Metadata tmp = (Metadata)e.getValue();
                Iterator i$ = tmp.asMap().entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry tmpo;
                    Map.Entry tmpEntry = tmpo = i$.next();
                    svcData.put((String)tmpEntry.getKey(), (String)tmpEntry.getValue());
                }
                String svcName = ((String)e.getKey()).substring(FN_INTEROP_SERVICE_PREFIX.length());
                interopReg.put(svcName, svcData);
            }
        }
        if (toRet == null) {
            toRet = new IMPersona(mbox, addr);
        }
        toRet.mInteropRegistrationData = interopReg;
        return toRet;
    }

    private IMPersona(Mailbox mbox, IMAddr addr) {
        super(ZimbraLog.im);
        assert (addr != null);
        this.mAddr = addr;
        this.mMailbox = mbox;
        ZimbraLog.im.info("Creating IMPersona " + this.toString() + " at addr " + System.identityHashCode(this) + " mbox at addr " + System.identityHashCode(mbox));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renamePersona(String newName) {
        String oldName = this.mAddr.getAddr();
        HashMap<IMAddr, IMSubscribedNotification> startRoster = new HashMap<IMAddr, IMSubscribedNotification>();
        startRoster.putAll(this.mRoster);
        ArrayList<RosterItem> rosterItemsBeforeDelete = new ArrayList<RosterItem>();
        try {
            Roster oldRoster = XMPPServer.getInstance().getRosterManager().getRoster(oldName);
            for (RosterItem item : oldRoster.getRosterItems()) {
                rosterItemsBeforeDelete.add(item);
            }
        }
        catch (UserNotFoundException e) {
            ZimbraLog.im.debug((Object)("usernotfound: " + oldName), e);
        }
        Object object = this.getLock();
        synchronized (object) {
            boolean fakeOnline = false;
            if (!this.mIsOnline) {
                fakeOnline = true;
                this.mIsOnline = true;
                this.connectToIMServer();
            }
            for (RosterItem item : rosterItemsBeforeDelete) {
                if (item.getSubStatus() != RosterItem.SUB_BOTH && item.getSubStatus() != RosterItem.SUB_FROM) continue;
                try {
                    this.authorizeSubscribe(null, new IMAddr(item.getJid()), false, false, item.getNickname(), item.getGroups());
                }
                catch (ServiceException e) {
                    ZimbraLog.im.debug((Object)"in authSubscribe before changing name", e);
                }
            }
            if (fakeOnline) {
                this.mIsOnline = false;
                this.disconnectFromIMServer();
            }
            if (this.mIsOnline) {
                this.mIsOnline = false;
                try {
                    this.pushMyPresence();
                }
                catch (ServiceException e) {
                    ZimbraLog.im.debug("Couldn't push offline presence before disconnect during rename to " + newName);
                }
                this.disconnectFromIMServer();
            }
            IMPersona.deleteIMPersona(oldName);
            this.mAddr = new IMAddr(newName);
            fakeOnline = false;
            if (!this.mIsOnline) {
                fakeOnline = true;
                this.mIsOnline = true;
                this.connectToIMServer();
            }
            for (RosterItem item : rosterItemsBeforeDelete) {
                if (item.getSubStatus() == RosterItem.SUB_BOTH || item.getSubStatus() == RosterItem.SUB_FROM) {
                    try {
                        this.authorizeSubscribe(null, new IMAddr(item.getJid()), true, false, item.getNickname(), item.getGroups());
                    }
                    catch (ServiceException e) {
                        ZimbraLog.im.debug((Object)"in authSubscribe after changing name", e);
                    }
                }
                if (item.getSubStatus() != RosterItem.SUB_BOTH && item.getSubStatus() != RosterItem.SUB_TO) continue;
                try {
                    this.addOutgoingSubscription(null, new IMAddr(item.getJid()), item.getNickname(), item.getGroups());
                }
                catch (ServiceException e) {
                    ZimbraLog.im.debug((Object)"in authSubscribe after changing name", e);
                }
                if (fakeOnline) continue;
                this.postIMNotification(IMSubscribedNotification.create(new IMAddr(item.getJid()), "", item.getGroups(), false, false, Roster.Ask.subscribe));
            }
            if (fakeOnline) {
                this.mIsOnline = false;
                this.disconnectFromIMServer();
            }
            if (this.mListeners.size() > 0) {
                this.mIsOnline = true;
                this.connectToIMServer();
                try {
                    this.pushMyPresence();
                }
                catch (ServiceException e) {
                    ZimbraLog.im.debug("Couldn't push initial presence after reconnect during rename to " + newName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Session session) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.mListeners.size() == 0) {
                this.mIsOnline = true;
                this.connectToIMServer();
                try {
                    this.pushMyPresence();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
            if (!this.mListeners.containsKey(session)) {
                this.mListeners.put(session, new IdleInfo());
                this.updateSynthesizedIdle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Session session) {
        Object object = this.getLock();
        synchronized (object) {
            this.mListeners.remove(session);
            if (this.mListeners.size() == 0) {
                this.mIsOnline = false;
                try {
                    this.pushMyPresence();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                this.disconnectFromIMServer();
            }
            this.updateSynthesizedIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleState(Session session, boolean isIdle, long idleStartTime) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            IdleInfo info = this.mListeners.get(session);
            if (info == null) {
                ZimbraLog.im.debug("Skipping IMSetIdleRequest - couldn't find referenced session " + session);
            } else {
                info.isIdle = isIdle;
                info.idleStartTime = idleStartTime;
                this.updateSynthesizedIdle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSynthesizedIdle() {
        Object object = this.getLock();
        synchronized (object) {
            boolean isIdle = true;
            long idleStartTime = 0L;
            for (IdleInfo info : this.mListeners.values()) {
                if (!info.isIdle) {
                    isIdle = false;
                }
                idleStartTime = Math.max(idleStartTime, info.idleStartTime);
            }
            if (this.mIsIdle != isIdle) {
                this.mIsIdle = isIdle;
                this.mIdleStartTime = idleStartTime;
                try {
                    this.pushMyPresence();
                }
                catch (ServiceException e) {
                    this.mLog.debug((Object)"Ignoring exception in updateSynthesizedIdle", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeListeners() {
        Object object = this.getLock();
        synchronized (object) {
            ArrayList<Session> toRemove = new ArrayList<Session>();
            toRemove.addAll(this.mListeners.keySet());
            for (Session s : toRemove) {
                this.removeListener(s);
            }
        }
    }

    public void addOutgoingSubscription(OperationContext octxt, IMAddr address, String name, List<String> groupArray) throws ServiceException {
        String[] groups = new String[groupArray.size()];
        groupArray.toArray(groups);
        this.addOutgoingSubscription(octxt, address, name, groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutgoingSubscription(OperationContext octxt, IMAddr address, String name, String[] groups) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            org.xmpp.packet.Roster rosterPacket = new org.xmpp.packet.Roster(IQ.Type.set);
            rosterPacket.addItem(address.makeJID(), name, Roster.Ask.subscribe, Roster.Subscription.to, Arrays.asList(groups));
            this.xmppRoute((Packet)rosterPacket);
            Presence subscribePacket = new Presence(Presence.Type.subscribe);
            subscribePacket.setTo(address.makeJID());
            this.xmppRoute((Packet)subscribePacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToChat(OperationContext octxt, IMChat chat, IMAddr addr, String invitationMessage) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            chat.addUserToChat(addr, invitationMessage);
        }
    }

    public void authorizeSubscribe(OperationContext octxt, IMAddr toAddress, boolean authorized, boolean add, String name, List<String> groupArray) throws ServiceException {
        String[] groups = new String[groupArray.size()];
        groupArray.toArray(groups);
        this.authorizeSubscribe(octxt, toAddress, authorized, add, name, groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authorizeSubscribe(OperationContext octxt, IMAddr toAddress, boolean authorized, boolean add, String name, String[] groups) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            this.mPendingSubscribes.remove(toAddress);
            Presence pres = authorized ? new Presence(Presence.Type.subscribed) : new Presence(Presence.Type.unsubscribed);
            pres.setTo(toAddress.makeJID());
            this.xmppRoute((Packet)pres);
            if (add) {
                this.addOutgoingSubscription(octxt, toAddress, name, groups);
            }
        }
    }

    public Iterable<IMChat> chats() {
        return new Iterable<IMChat>(){

            @Override
            public Iterator<IMChat> iterator() {
                return Collections.unmodifiableCollection(IMPersona.this.mChats.values()).iterator();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChat(OperationContext octxt, IMChat chat) {
        Object object = this.getLock();
        synchronized (object) {
            chat.closeChat();
            this.mChats.remove(chat.getThreadId());
            this.postIMNotification(new IMChatCloseNotification(chat.getThreadId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshChats(Session s) {
        Object object = this.getLock();
        synchronized (object) {
            for (IMChat chat : this.mChats.values()) {
                int seqNo = chat.getFirstSeqNo();
                for (IMMessage msg : chat.messages()) {
                    IMMessageNotification not = new IMMessageNotification(msg.getFrom(), chat.getThreadId(), msg, seqNo);
                    this.postIMNotification(not, s);
                    ++seqNo;
                }
            }
        }
    }

    private IMChat findTargetMUC(Packet packet) {
        IMChat chat;
        String threadId;
        if (packet.getFrom() != null && (threadId = packet.getFrom().getNode()) != null && threadId.length() > 0 && (chat = this.getChat(threadId)) != null && chat.isMUC()) {
            return chat;
        }
        return null;
    }

    private void flush(OperationContext octxt) throws ServiceException {
        Mailbox mbox = this.getMailbox();
        assert (this.getAddr().getAddr().equals(mbox.getAccount().getName()));
        Metadata meta = new Metadata();
        meta.put(FN_ADDRESS, this.mAddr);
        for (Map.Entry<String, Map<String, String>> svc : this.mInteropRegistrationData.entrySet()) {
            Metadata interopData = new Metadata();
            for (Map.Entry<String, String> entry : svc.getValue().entrySet()) {
                interopData.put(entry.getKey(), entry.getValue());
            }
            meta.put(FN_INTEROP_SERVICE_PREFIX + svc.getKey(), interopData);
        }
        mbox.setConfig(octxt, "im", meta);
    }

    @Override
    protected Object formatObject(Object o) {
        if (o instanceof Packet) {
            return ((Packet)o).toXML();
        }
        return super.formatObject(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gatewayReconnect(String serviceName) throws ServiceException {
        if (!this.interopAvailable()) {
            throw ServiceException.FAILURE("Interop not available", null);
        }
        Object object = this.getLock();
        synchronized (object) {
            try {
                this.reconnectInteropUser(serviceName, this.mAddr.makeFullJID(this.getResource()));
            }
            catch (Exception e) {
                throw ServiceException.FAILURE("Exception calling gatewayReconnect(" + serviceName, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gatewayRegister(String serviceName, String username, String password) throws ServiceException {
        if (!this.interopAvailable()) {
            throw ServiceException.FAILURE("Interop not available", null);
        }
        Object object = this.getLock();
        synchronized (object) {
            try {
                this.registerInteropUser(serviceName, this.mAddr.makeFullJID(this.getResource()), username, password);
            }
            catch (ServiceException ace) {
                try {
                    this.unregisterInteropUser(serviceName, this.mAddr.makeFullJID(this.getResource()));
                    this.registerInteropUser(serviceName, this.mAddr.makeFullJID(this.getResource()), username, password);
                }
                catch (Exception e) {
                    throw ServiceException.FAILURE("Exception calling Interop.connectUser(" + username + "," + password, e);
                }
            }
            catch (Exception e) {
                throw ServiceException.FAILURE("Exception calling Interop.connectUser(" + username + "," + password, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gatewayUnRegister(String serviceName) throws ServiceException {
        if (!this.interopAvailable()) {
            throw ServiceException.FAILURE("Interop not available", null);
        }
        Object object = this.getLock();
        synchronized (object) {
            try {
                this.unregisterInteropUser(serviceName, this.mAddr.makeFullJID(this.getResource()));
            }
            catch (Exception e) {
                throw ServiceException.FAILURE("Exception calling Interop.disconnectUser()", e);
            }
        }
    }

    public IMAddr getAddr() {
        return this.mAddr;
    }

    public String getDomain() {
        return this.mAddr.getDomain();
    }

    private boolean interopAvailable() {
        return Interop.getInstance() != null;
    }

    private List<String> getAvailableInteropServices() {
        return Interop.getInstance().getAvailableServices();
    }

    private void unregisterInteropUser(String serviceName, JID jid) throws ServiceException {
        try {
            Interop.getInstance().unregisterUser(serviceName, jid);
        }
        catch (Exception e) {
            throw ServiceException.FAILURE("Caught exception from component", e);
        }
    }

    private void registerInteropUser(String serviceName, JID jid, String username, String password) throws ServiceException {
        try {
            Interop.getInstance().registerUser(serviceName, jid, username, password);
        }
        catch (Exception e) {
            throw ServiceException.FAILURE("Caught exception from component", e);
        }
    }

    private void reconnectInteropUser(String serviceName, JID jid) throws ServiceException {
        try {
            Interop.getInstance().reconnectUser(serviceName, jid);
        }
        catch (Exception e) {
            throw ServiceException.FAILURE("Caught exception from component", e);
        }
    }

    public GatewayRegistrationStatus getRegistrationStatus(String serviceName, JID jid) throws ServiceException {
        try {
            UserStatus us = Interop.getInstance().getRegistrationStatus(serviceName, jid);
            if (us != null) {
                GatewayRegistrationStatus toRet = new GatewayRegistrationStatus();
                toRet.username = us.username;
                toRet.password = us.password;
                toRet.state = us.state.name().toLowerCase();
                toRet.nextConnectAttemptTime = us.nextConnectAttemptTime;
                return toRet;
            }
            return null;
        }
        catch (Exception e) {
            throw ServiceException.FAILURE("Caught exception fetching status", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, GatewayRegistrationStatus>> getAvailableGateways() {
        Object object = this.getLock();
        synchronized (object) {
            LinkedList<Pair<String, GatewayRegistrationStatus>> ret = new LinkedList<Pair<String, GatewayRegistrationStatus>>();
            if (this.interopAvailable()) {
                for (String service : this.getAvailableInteropServices()) {
                    try {
                        ret.add(new Pair<String, GatewayRegistrationStatus>(service, this.getRegistrationStatus(service, this.mAddr.makeFullJID(this.getResource()))));
                    }
                    catch (ServiceException ex) {
                        this.debug("Caught component exception trying to get registration status for " + service + " jid=" + this.mAddr.makeFullJID(this.getResource()) + ": ", ex);
                    }
                }
            }
            return ret;
        }
    }

    private IMChat getChat(boolean create, String thread, IMAddr fromAddress) {
        IMChat toRet = this.mChats.get(thread);
        if (toRet == null && create) {
            IMChat.Participant part = new IMChat.Participant(fromAddress, false);
            if (thread == null) {
                throw new IllegalArgumentException("Cannot create a chat with a NULL threadId");
            }
            toRet = new IMChat(this, thread, part);
            this.mChats.put(thread, toRet);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMChat getChat(String threadId) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getChat(false, threadId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMPresence getEffectivePresence() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.mIsOnline) {
                if (this.mIsIdle) {
                    return new IMPresence(IMPresence.Show.AWAY, 0, null);
                }
                return this.mMyPresence;
            }
            return new IMPresence(IMPresence.Show.OFFLINE, this.mMyPresence.getPriority(), this.mMyPresence.getStatus());
        }
    }

    public String getFullJidAsString() {
        return this.mAddr + "/" + this.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getIMGatewayRegistration(String serviceName) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            return this.mInteropRegistrationData.get(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIMGatewayRegistration(String serviceName, Map<String, String> data) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            this.mInteropRegistrationData.put(serviceName, data);
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIMGatewayRegistration(String serviceName) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            this.mInteropRegistrationData.remove(serviceName);
            this.flush(null);
        }
    }

    @Override
    protected String getInstanceInfo() {
        return this.toString();
    }

    public Object getLock() {
        return this.mMailbox;
    }

    Mailbox getMailbox() throws ServiceException {
        return this.mMailbox;
    }

    String getMucDomain() throws ServiceException {
        return "conf." + this.getMailbox().getAccount().getDomainName();
    }

    public String getResource() {
        return "zcs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRoster(Session s) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.mHaveInitialRoster) {
                IMRosterNotification rosterNot = new IMRosterNotification();
                for (IMSubscribedNotification iMSubscribedNotification : this.mRoster.values()) {
                    rosterNot.addEntry(iMSubscribedNotification);
                }
                this.postIMNotification(rosterNot, s);
                for (Map.Entry entry : this.mBufferedPresence.entrySet()) {
                    IMPresenceUpdateNotification not = new IMPresenceUpdateNotification((IMAddr)entry.getKey(), ((PresencePriorityMap)entry.getValue()).getEffectivePresence());
                    this.postIMNotification(not, s);
                }
                for (IMSubscribeNotification iMSubscribeNotification : this.mPendingSubscribes.values()) {
                    this.postIMNotification(iMSubscribeNotification, s);
                }
            }
        }
    }

    public Iterable<IMGroup> groups() {
        return new Iterable<IMGroup>(){

            @Override
            public Iterator<IMGroup> iterator() {
                return Collections.unmodifiableCollection(IMPersona.this.mGroups.values()).iterator();
            }
        };
    }

    void handleIQPacket(boolean intercepted, boolean toMe, IQ iq) {
        IMChat chat;
        boolean handled = false;
        ZimbraLog.im.info("INCOMING: " + iq);
        switch (iq.getType()) {
            case error: {
                if (!intercepted && this.mPendingRequests.containsKey(iq.getID())) {
                    RequestCompletionHandler handler = this.mPendingRequests.remove(iq.getID());
                    if (handler != null) {
                        handler.onResultReceived(iq);
                    }
                } else {
                    ZimbraLog.im.debug("Ignoring IQ error packet: " + iq);
                }
                return;
            }
            case result: {
                if (!intercepted && this.mPendingRequests.containsKey(iq.getID())) {
                    RequestCompletionHandler handler = this.mPendingRequests.remove(iq.getID());
                    if (handler != null) {
                        handler.onResultReceived(iq);
                    }
                } else {
                    Element child = iq.getChildElement();
                    if (child != null && "query".equals(child.getName()) && "jabber:iq:privacy".equals(child.getNamespaceURI())) {
                        this.handlePrivacyResult(iq);
                        handled = true;
                    }
                    if (!handled) {
                        ZimbraLog.im.debug("Ignoring IQ result packet: " + iq);
                    }
                }
                return;
            }
            case set: {
                Element child = iq.getChildElement();
                if (child != null && "query".equals(child.getName())) {
                    if ("jabber:iq:privacy".equals(child.getNamespaceURI())) {
                        this.handlePrivacySet(iq);
                        handled = true;
                    } else {
                        this.info("Ignorig unknown IQ set: " + iq.toString(), new Object[0]);
                    }
                }
                IQ result = new IQ();
                result.setType(IQ.Type.result);
                result.setID(iq.getID());
                this.xmppRoute((Packet)result);
                break;
            }
        }
        if (!handled && (chat = this.findTargetMUC((Packet)iq)) != null) {
            chat.handleIQPacket(iq);
        }
    }

    private void handlePrivacySet(IQ iq) {
        this.getDefaultPrivacyList();
    }

    private void handlePrivacyResult(IQ iq) {
        Element child = iq.getChildElement();
        ZimbraLog.im.debug("Received Privacy List Packet: " + iq);
        String[] idParts = iq.getID().split("-");
        boolean handled = false;
        if (idParts.length > 0) {
            if ("getPrivLists".equals(idParts[0])) {
                String defaultListName;
                ZimbraLog.im.debug("It's a list of our privacy lists!");
                this.mDefaultPrivacyListName = null;
                Element defaultList = child.element("default");
                if (defaultList != null && (defaultListName = defaultList.attributeValue("name", null)) != null) {
                    handled = true;
                    this.mDefaultPrivacyListName = defaultListName;
                    this.requestPrivacyList(defaultListName);
                }
                if (!handled) {
                    handled = true;
                    IMPrivacyListNotification not = new IMPrivacyListNotification(new PrivacyList("default"));
                    this.postIMNotification(not);
                }
            } else if ("getDefaultPrivList".equals(idParts[0])) {
                String name;
                ZimbraLog.im.debug("Received default privacy list: " + iq);
                handled = true;
                Element list = child.element("list");
                if (list != null && (name = list.attributeValue("name", null)) != null) {
                    PrivacyList pl = new PrivacyList(name);
                    Iterator iter = list.elementIterator("item");
                    while (iter.hasNext()) {
                        Element item = (Element)iter.next();
                        String type = item.attributeValue("type", "jid");
                        String value = item.attributeValue("value", null);
                        String actionStr = item.attributeValue("action", "deny");
                        String order = item.attributeValue("order", null);
                        if (value == null || order == null || !"jid".equals(type)) continue;
                        int orderInt = Integer.parseInt(order);
                        PrivacyListEntry.Action action = PrivacyListEntry.Action.valueOf(actionStr);
                        byte blockType = 0;
                        if (item.element("message") != null) {
                            blockType = (byte)(blockType | 1);
                        }
                        if (item.element("presence-in") != null) {
                            blockType = (byte)(blockType | 4);
                        }
                        if (item.element("presence-out") != null) {
                            blockType = (byte)(blockType | 2);
                        }
                        if (item.element("iq") != null) {
                            blockType = (byte)(blockType | 8);
                        }
                        if (blockType == 0) {
                            blockType = (byte)15;
                        }
                        PrivacyListEntry entry = new PrivacyListEntry(new IMAddr(value), orderInt, action, blockType);
                        try {
                            pl.addEntry(entry);
                        }
                        catch (PrivacyList.DuplicateOrderException e) {
                            ZimbraLog.im.warn("Received an invalid PrivacyList from server: order was non-unique.  Ignoring: %s", item);
                        }
                    }
                    IMPrivacyListNotification not = new IMPrivacyListNotification(pl);
                    this.postIMNotification(not);
                }
            } else {
                handled = true;
            }
        }
        if (!handled) {
            ZimbraLog.im.debug("Ignoring unknown privacy IQ response: " + iq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQ syncIQQuery(IQ iq) throws ServiceException {
        if (Thread.holdsLock(this.getLock())) {
            throw new IllegalStateException("May not make callback requests while holding Persona lock!");
        }
        IQQueryCompletion iqc = new IQQueryCompletion(iq);
        this.sendRequest(iq, iqc);
        IQQueryCompletion iQQueryCompletion = iqc;
        synchronized (iQQueryCompletion) {
            try {
                iqc.wait(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (iqc.isError()) {
            if (iqc.getResult().getError().getType() == PacketError.Type.auth) {
                throw IMServiceException.NOT_ALLOWED(iqc.getResult().getFrom().toString());
            }
            throw IMServiceException.XMPP_ERROR("during iq:query", (Packet)iqc.getResult());
        }
        return iqc.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoInfoResult syncGetDiscoInfo(String target) throws ServiceException {
        if (Thread.holdsLock(this.getLock())) {
            throw new IllegalStateException("May not make callback requests while holding Persona lock!");
        }
        IQ iq = new IQ();
        Object object = this.getLock();
        synchronized (object) {
            iq.setType(IQ.Type.get);
            iq.setID("DiscoInfo-" + this.mCurRequestId++);
            iq.setChildElement("query", "http://jabber.org/protocol/disco#info");
            iq.setTo(target);
        }
        DiscoInfoCompletion dic = new DiscoInfoCompletion(iq);
        this.sendRequest(iq, dic);
        DiscoInfoCompletion discoInfoCompletion = dic;
        synchronized (discoInfoCompletion) {
            try {
                dic.wait(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (dic.isError()) {
            throw IMServiceException.XMPP_ERROR("Error fetching disco#info for server", (Packet)dic.getRespnse());
        }
        return dic.getDiscoInfoResult();
    }

    private static DiscoItemsResult handleDiscoItemsResult(IQ iq) {
        DiscoItemsResult di = new DiscoItemsResult();
        Element child = iq.getChildElement();
        Iterator iter = child.elementIterator("item");
        while (iter.hasNext()) {
            Element item = (Element)iter.next();
            ZimbraLog.im.debug("Found item: " + item.asXML());
            if (item.attributeValue("name", null) == null || item.attributeValue("jid", null) == null) continue;
            DiscoItemResult dir = new DiscoItemResult();
            dir.name = item.attributeValue("name");
            dir.jid = item.attributeValue("jid");
            di.items.add(dir);
        }
        return di;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoItemsResult syncGetDiscoItems(String target) throws ServiceException {
        if (Thread.holdsLock(this.getLock())) {
            throw new IllegalStateException("May not make callback requests while holding Persona lock!");
        }
        IQ iq = new IQ();
        Object object = this.getLock();
        synchronized (object) {
            iq.setType(IQ.Type.get);
            iq.setID("DiscoItems-" + this.mCurRequestId++);
            iq.setChildElement("query", "http://jabber.org/protocol/disco#items");
            iq.setTo(target);
        }
        DiscoItemsCompletion dic = new DiscoItemsCompletion(iq);
        this.sendRequest(iq, dic);
        DiscoItemsCompletion discoItemsCompletion = dic;
        synchronized (discoItemsCompletion) {
            try {
                dic.wait(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (dic.isError()) {
            throw IMServiceException.XMPP_ERROR("Error fetching disco#info for server", (Packet)dic.getRespnse());
        }
        return dic.getDiscoItemsResult();
    }

    public List<Pair<String, String>> listConferenceServices() throws ServiceException {
        if (Thread.holdsLock(this.getLock())) {
            throw new IllegalStateException("May not make this request while holding Persona lock!");
        }
        ArrayList<Pair<String, String>> toRet = new ArrayList<Pair<String, String>>();
        DiscoItemsResult serverItems = this.syncGetDiscoItems(this.mAddr.getDomain());
        if (serverItems == null) {
            throw ServiceException.FAILURE("Unable to fetch disco#items result from local XMPP cloud", null);
        }
        for (DiscoItemResult item : serverItems.items) {
            DiscoInfoResult di = this.syncGetDiscoInfo(item.jid);
            if (di == null || !"conference".equals(di.category) || !"text".equals(di.type)) continue;
            toRet.add(new Pair<String, String>(di.name, di.jid));
        }
        return toRet;
    }

    public List<Pair<String, String>> listRooms(String svc) throws ServiceException {
        if (Thread.holdsLock(this.getLock())) {
            throw new IllegalStateException("May not make this request while holding Persona lock!");
        }
        DiscoInfoResult svcDI = this.syncGetDiscoInfo(svc);
        if (svcDI == null) {
            throw IMServiceException.NO_RESPONSE_FROM_REMOTE("Could not contact service at: " + svc, svc);
        }
        if (!"conference".equals(svcDI.category) || !"text".equals(svcDI.type)) {
            throw IMServiceException.NOT_A_CONFERENCE_SERVICE(svc);
        }
        DiscoItemsResult svcItems = this.syncGetDiscoItems(svc);
        if (svcItems == null) {
            throw IMServiceException.NO_RESPONSE_FROM_REMOTE("Could not fetch rooms from conference service at: " + svc, svc);
        }
        ArrayList<Pair<String, String>> toRet = new ArrayList<Pair<String, String>>();
        for (DiscoItemResult item : svcItems.items) {
            toRet.add(new Pair<String, String>(item.name, item.jid));
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMConferenceRoom getConferenceRoom(String threadId, String addr, boolean requestOwnerConfig) throws ServiceException {
        DiscoInfoResult roomDi;
        if (Thread.holdsLock(this.getLock())) {
            throw new IllegalStateException("May not make this request while holding Persona lock!");
        }
        assert (threadId == null || addr == null);
        IMChat chat = null;
        if (threadId != null) {
            chat = this.getChat(threadId);
            if (chat == null) {
                throw MailServiceException.NO_SUCH_CHAT(threadId);
            }
            if (!chat.isMUC()) {
                return null;
            }
            addr = chat.getDestAddr();
        }
        if ((roomDi = this.syncGetDiscoInfo(addr)) == null) {
            throw IMServiceException.NO_RESPONSE_FROM_REMOTE(" attempting to fetch disco#info", addr);
        }
        IMConferenceRoom room = null;
        if (!"conference".equals(roomDi.category) || !"text".equals(roomDi.type)) {
            if (!requestOwnerConfig) {
                throw IMServiceException.NOT_A_CONFERENCE_ROOM(addr);
            }
            room = chat != null ? IMConferenceRoom.emptyRoom(chat) : IMConferenceRoom.emptyRoom(addr);
        } else {
            room = IMConferenceRoom.parseRoomInfo(chat, addr, roomDi.resultIQ);
        }
        if (requestOwnerConfig) {
            IQ iq = new IQ();
            Object object = this.getLock();
            synchronized (object) {
                iq.setType(IQ.Type.get);
                iq.setID("IQQuery-" + this.mCurRequestId++);
                iq.setChildElement("query", "http://jabber.org/protocol/muc#owner");
                iq.setTo(addr);
            }
            IQ configForm = this.syncIQQuery(iq);
            if (configForm == null) {
                throw IMServiceException.NO_RESPONSE_FROM_REMOTE("attempting to fetch room configuration form from conference service - " + iq.toXML(), addr);
            }
            if (configForm.getType() == IQ.Type.error) {
                if (configForm.getError().getType() == PacketError.Type.auth) {
                    throw IMServiceException.NOT_ALLOWED(addr);
                }
                throw IMServiceException.XMPP_ERROR("attempting to fetch config form", (Packet)configForm);
            }
            Element child = configForm.getChildElement();
            Element x = child.element("x");
            if (x != null) {
                room.parseConfigurationForm(x);
            }
        }
        return room;
    }

    public void createConferenceRoom(String addr, List<Pair<String, List<String>>> config) {
        if (Thread.holdsLock(this.getLock())) {
            throw new IllegalStateException("May not make this request while holding Persona lock!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQ configureChat(IMChat chat, Map<String, Object> data) throws ServiceException {
        if (Thread.holdsLock(this.getLock())) {
            throw new IllegalStateException("May not make this request while holding Persona lock!");
        }
        IQ iq = new IQ();
        Object object = this.getLock();
        synchronized (object) {
            iq.setType(IQ.Type.get);
            iq.setID("IQQuery-" + this.mCurRequestId++);
            iq.setTo(chat.getDestAddr());
        }
        IMConferenceRoom.generateConfigIQ(iq, data);
        IQ configFormResult = this.syncIQQuery(iq);
        return configFormResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQ configureConferenceRoom(String addr, Element d4Elt) throws ServiceException {
        if (Thread.holdsLock(this.getLock())) {
            throw new IllegalStateException("May not make this request while holding Persona lock!");
        }
        if (d4Elt != null) {
            IQ iq = new IQ();
            Object object = this.getLock();
            synchronized (object) {
                iq.setType(IQ.Type.get);
                iq.setID("IQQuery-" + this.mCurRequestId++);
                Element child = iq.setChildElement("query", "http://jabber.org/protocol/muc#owner");
                child.add(d4Elt);
                iq.setTo(addr);
            }
            IQ configFormResult = this.syncIQQuery(iq);
            return configFormResult;
        }
        return null;
    }

    private static DiscoInfoResult handleDiscoInfoResult(IQ iq) {
        DiscoInfoResult toRet = new DiscoInfoResult();
        String fromAddr = iq.getFrom().toBareJID();
        Element child = iq.getChildElement();
        Element identity = child.element("identity");
        if (identity != null) {
            toRet.category = identity.attributeValue("category", "");
            toRet.type = identity.attributeValue("type", "");
            toRet.jid = iq.getFrom().toBareJID();
            toRet.name = identity.attributeValue("name", "");
            toRet.resultIQ = iq;
            Iterator iter = child.elementIterator("feature");
            while (iter.hasNext()) {
                Element item = (Element)iter.next();
                ZimbraLog.im.info("Found feature: " + item.asXML());
                String var = item.attributeValue("var", null);
                if (var == null) continue;
                toRet.features.add(var);
            }
        }
        return toRet;
    }

    private void handleMessagePacket(boolean toMe, Message msg) {
        Element xe = msg.getChildElement("x", "zimbra:interop");
        if (xe != null) {
            Element selt;
            String serviceName;
            String[] splits;
            String username = null;
            Element usernameElt = xe.element("username");
            if (usernameElt != null) {
                username = usernameElt.getText();
            }
            if ((splits = (serviceName = msg.getFrom().toBareJID()).split("\\.")).length > 0) {
                serviceName = splits[0];
            }
            if ((selt = xe.element("state")) != null) {
                String state = selt.attributeValue("value");
                String delay = selt.attributeValue("delay", null);
                IMGatewayStateNotification not = new IMGatewayStateNotification(serviceName, state, delay);
                this.postIMNotification(not);
                return;
            }
            Element otherLocation = xe.element("otherLocation");
            if (otherLocation != null) {
                IMOtherLocationNotification not = new IMOtherLocationNotification(serviceName, username);
                this.postIMNotification(not);
                return;
            }
        }
        JID remoteJID = toMe ? msg.getFrom() : msg.getTo();
        IMChat chat = this.findTargetMUC((Packet)msg);
        if (chat == null) {
            String threadId = msg.getThread();
            if (threadId == null || threadId.length() == 0) {
                for (IMChat cur : this.mChats.values()) {
                    if (cur.participants().size() > 2 || !cur.hasParticipant(new IMAddr(remoteJID))) continue;
                    threadId = cur.getThreadId();
                    break;
                }
                if (!(threadId != null && threadId.length() != 0 || (threadId = (toMe ? msg.getFrom() : msg.getTo()).getNode()) != null && threadId.length() != 0)) {
                    threadId = (toMe ? msg.getFrom() : msg.getTo()).toBareJID();
                }
            }
            chat = this.getChat(true, threadId, new IMAddr(remoteJID));
        }
        chat.handleMessagePacket(toMe, msg);
    }

    private void handlePresencePacket(boolean toMe, Presence pres) {
        IMChat chat = this.findTargetMUC((Packet)pres);
        if (chat != null) {
            chat.handlePresencePacket(toMe, pres);
        } else {
            if (pres.getChildElement("x", "http://jabber.org/protocol/muc#user") != null || pres.getChildElement("x", "http://jabber.org/protocol/muc") != null) {
                this.info("Got MUC presence update but couldn't find Chat", new Object[0]);
                return;
            }
            Presence.Type ptype = pres.getType();
            if (ptype == null) {
                IMAddr fromAddr = IMAddr.fromJID(pres.getFrom());
                IMPresence newPresence = new IMPresence(pres);
                PresencePriorityMap map = this.mBufferedPresence.get(fromAddr);
                if (map == null) {
                    map = new PresencePriorityMap();
                    this.mBufferedPresence.put(fromAddr, map);
                }
                map.addPresenceUpdate(pres.getFrom().getResource(), newPresence);
                if (!fromAddr.equals(this.mAddr)) {
                    IMPresenceUpdateNotification event = new IMPresenceUpdateNotification(fromAddr, map.getEffectivePresence());
                    this.postIMNotification(event);
                }
            } else {
                Presence reply = null;
                switch (ptype) {
                    case unavailable: {
                        IMAddr fromAddr = IMAddr.fromJID(pres.getFrom());
                        PresencePriorityMap map = this.mBufferedPresence.get(fromAddr);
                        if (map != null) {
                            map.removePresence(pres.getFrom().getResource());
                            if (map.isEmpty()) {
                                this.mBufferedPresence.remove(fromAddr);
                                map = null;
                            }
                        }
                        if (fromAddr.equals(this.mAddr)) break;
                        IMPresenceUpdateNotification event = map != null ? new IMPresenceUpdateNotification(fromAddr, map.getEffectivePresence()) : new IMPresenceUpdateNotification(fromAddr, IMPresence.UNAVAILABLE);
                        this.postIMNotification(event);
                        break;
                    }
                    case subscribe: {
                        IMAddr fromAddr = IMAddr.fromJID(pres.getFrom());
                        IMSubscribeNotification notify = new IMSubscribeNotification(fromAddr);
                        this.mPendingSubscribes.put(fromAddr, notify);
                        this.postIMNotification(notify);
                        break;
                    }
                    case subscribed: {
                        this.debug("Presence.subscribed: " + pres.toString(), new Object[0]);
                        break;
                    }
                    case unsubscribe: {
                        this.debug("Presence.unsubscribe: %s", pres);
                        reply = new Presence();
                        reply.setTo(pres.getFrom());
                        reply.setFrom(pres.getTo());
                        reply.setType(Presence.Type.unsubscribed);
                        this.xmppRoute((Packet)reply);
                        break;
                    }
                    case unsubscribed: {
                        this.debug("Presence.unsubscribed: %s", pres);
                        IMAddr address = IMAddr.fromJID(pres.getFrom());
                        this.postIMNotification(IMSubscribedNotification.create(address, address.toString(), false, false, null));
                        break;
                    }
                    case probe: {
                        this.debug("Presence.probe: %s", pres);
                        try {
                            this.pushMyPresence(pres.getFrom());
                        }
                        catch (ServiceException ex) {}
                        break;
                    }
                    case error: {
                        this.info("Presence.error: %s", pres);
                    }
                }
            }
        }
    }

    private void handleRosterPacket(boolean toMe, org.xmpp.packet.Roster roster) {
        boolean isResult = false;
        switch (roster.getType()) {
            case result: {
                isResult = true;
                this.mHaveInitialRoster = true;
            }
            case set: {
                for (Roster.Item item : roster.getItems()) {
                    IMAddr buddyAddr = IMAddr.fromJID(item.getJID());
                    Roster.Subscription subscript = item.getSubscription();
                    boolean isTo = subscript == Roster.Subscription.both || subscript == Roster.Subscription.to;
                    boolean isFrom = subscript == Roster.Subscription.both || subscript == Roster.Subscription.from;
                    IMSubscribedNotification not = IMSubscribedNotification.create(buddyAddr, item.getName(), item.getGroups(), isTo, isFrom, item.getAsk());
                    if (subscript == Roster.Subscription.remove) {
                        this.mRoster.remove(buddyAddr);
                    } else {
                        this.mRoster.put(buddyAddr, not);
                    }
                    if (isResult) continue;
                    this.postIMNotification(not);
                }
                if (!isResult) break;
                this.refreshRoster(null);
                break;
            }
            default: {
                this.debug("Ignoring Roster packet of type %s", roster.getType());
            }
        }
    }

    private void connectToIMServer() {
        block4: {
            try {
                if (this.mXMPPSession != null || !Provisioning.getInstance().getLocalServer().getBooleanAttr("zimbraXMPPEnabled", false)) break block4;
                this.mXMPPSession = new ClientSession(Provisioning.getInstance().getLocalServer().getName(), (Connection)new FakeClientConnection(this), XMPPServer.getInstance().getSessionManager().nextStreamID());
                AuthToken at = new AuthToken(this.mAddr.getAddr());
                this.mXMPPSession.setAuthToken(at);
                try {
                    this.mXMPPSession.setAuthToken(at, XMPPServer.getInstance().getUserManager(), this.getResource());
                }
                catch (UserNotFoundException ex) {
                    System.out.println(ex.toString());
                    ex.printStackTrace();
                }
                org.xmpp.packet.Roster rosterRequest = new org.xmpp.packet.Roster();
                this.xmppRoute((Packet)rosterRequest);
                this.getDefaultPrivacyList();
            }
            catch (ServiceException ex) {
                ZimbraLog.im.warn((Object)("Caught Exception checking if XMPP enabled " + ex.toString()), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrivacyList(PrivacyList pl) {
        Object object = this.getLock();
        synchronized (object) {
            String plName = pl.getName();
            if (plName == null && (plName = this.mDefaultPrivacyListName) == null) {
                plName = "default";
            }
            IQ set = new IQ();
            set.setType(IQ.Type.set);
            Element query = set.setChildElement("query", "jabber:iq:privacy");
            Element list = query.addElement("list");
            list.addAttribute("name", plName);
            for (PrivacyListEntry e : pl) {
                Element item = list.addElement("item");
                item.addAttribute("type", "jid");
                item.addAttribute("value", e.getAddr().toString());
                item.addAttribute("action", e.getAction().name());
                item.addAttribute("order", Integer.toString(e.getOrder()));
                if (e.getTypes() == 15) continue;
                if (e.isBlockMessages()) {
                    item.addElement("message");
                }
                if (e.isBlockPresenceOut()) {
                    item.addElement("presence-out");
                }
                if (e.isBlockPresenceIn()) {
                    item.addElement("presence-in");
                }
                if (!e.isBlockIQ()) continue;
                item.addElement("iq");
            }
            this.xmppRoute((Packet)set);
            if (this.mDefaultPrivacyListName == null) {
                set = new IQ();
                set.setType(IQ.Type.set);
                query = set.setChildElement("query", "jabber:iq:privacy");
                Element defaultElt = query.addElement("default");
                defaultElt.addAttribute("name", plName);
                this.xmppRoute((Packet)set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPrivacyList(String name) {
        Object object = this.getLock();
        synchronized (object) {
            IQ request = new IQ();
            request.setType(IQ.Type.get);
            request.setID("getDefaultPrivList-" + this.mCurRequestId++);
            Element query = request.setChildElement("query", "jabber:iq:privacy");
            Element list = query.addElement("list");
            list.addAttribute("name", name);
            this.xmppRoute((Packet)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDefaultPrivacyList() {
        Object object = this.getLock();
        synchronized (object) {
            IQ iq = new IQ();
            iq.setType(IQ.Type.get);
            iq.setID("getPrivLists-" + this.mCurRequestId++);
            iq.setChildElement("query", "jabber:iq:privacy");
            this.xmppRoute((Packet)iq);
        }
    }

    private void disconnectFromIMServer() {
        assert (!this.mIsOnline);
        if (this.mXMPPSession != null) {
            this.mXMPPSession.getConnection().close();
            this.mXMPPSession = null;
            this.mHaveInitialRoster = false;
            this.mRoster = new HashMap<IMAddr, IMSubscribedNotification>();
            this.mPendingSubscribes = new HashMap<IMAddr, IMSubscribeNotification>();
            this.mBufferedPresence = new HashMap<IMAddr, PresencePriorityMap>();
        }
    }

    private synchronized void throwIfNotOnline() throws ServiceException {
        if (!this.mIsOnline) {
            throw ServiceException.FAILURE("This account is not currently logged in to IM services", null);
        }
    }

    private void sendRequest(IQ request, RequestCompletionHandler handler) throws ServiceException {
        this.throwIfNotOnline();
        if (this.mPendingRequests.containsKey(request.getID())) {
            throw new IllegalArgumentException("Request with ID " + request.getID() + " already pending");
        }
        if (handler != null) {
            this.mPendingRequests.put(request.getID(), handler);
        }
        this.xmppRoute((Packet)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDiscoInfo(String target) {
        Object object = this.getLock();
        synchronized (object) {
            IQ iq = new IQ();
            iq.setType(IQ.Type.get);
            iq.setID("DiscoInfo-" + this.mCurRequestId++);
            iq.setChildElement("query", "http://jabber.org/protocol/disco#info");
            iq.setTo(target);
            this.xmppRoute((Packet)iq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDiscoItems(String target) {
        Object object = this.getLock();
        synchronized (object) {
            IQ iq = new IQ();
            iq.setType(IQ.Type.get);
            iq.setID("DiscoItems-" + this.mCurRequestId++);
            iq.setChildElement("query", "http://jabber.org/protocol/disco#items");
            iq.setTo(target);
            this.xmppRoute((Packet)iq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, List<IMChat.MucStatusCode>> joinConferenceRoom(String addr, String threadId, String nickname, String password) throws ServiceException {
        IMChat chat;
        Object object = this.getLock();
        synchronized (object) {
            if ((threadId == null || threadId.length() == 0) && (threadId = addr).indexOf(64) >= 0) {
                threadId = addr.substring(0, addr.indexOf(64));
            }
            if ((chat = this.mChats.get(threadId)) == null) {
                chat = new IMChat(this, threadId, null);
                this.mChats.put(threadId, chat);
            }
        }
        List<IMChat.MucStatusCode> status = chat.syncJoinMUCChat(addr, nickname, password);
        return new Pair<String, List<IMChat.MucStatusCode>>(chat.getThreadId(), status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinSharedGroup(String name) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            try {
                Group group = GroupManager.getInstance().getGroup(name);
                group.getAdmins().add(this.mAddr.makeJID());
            }
            catch (GroupNotFoundException groupNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveSharedGroup(String name) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            try {
                Group group = GroupManager.getInstance().getGroup(name);
                group.getAdmins().remove(this.mAddr.makeJID());
            }
            catch (GroupNotFoundException groupNotFoundException) {
                // empty catch block
            }
        }
    }

    void postIMNotification(IMNotification not) {
        this.postIMNotification(not, null);
    }

    private void postIMNotification(IMNotification not, Session s) {
        if (s == null) {
            for (Session session : this.mListeners.keySet()) {
                session.notifyIM(not);
            }
        } else {
            s.notifyIM(not);
        }
    }

    void processIntercepted(Packet packet) {
        this.debug("Skipping intercepted packet: %s", packet);
    }

    void process(Packet packet) {
        this.debug("Incoming packet %s: ", packet);
        this.processInternal(packet, false);
    }

    private void processInternal(Packet packet, boolean intercepted) {
        boolean toMe = true;
        if (packet.getTo() != null && !packet.getTo().toBareJID().equals(this.getAddr().getAddr())) {
            toMe = false;
        }
        if (packet instanceof Message) {
            this.handleMessagePacket(toMe, (Message)packet);
        } else if (packet instanceof Presence) {
            this.handlePresencePacket(toMe, (Presence)packet);
        } else if (packet instanceof org.xmpp.packet.Roster) {
            this.handleRosterPacket(toMe, (org.xmpp.packet.Roster)packet);
        } else if (packet instanceof IQ) {
            this.handleIQPacket(intercepted, toMe, (IQ)packet);
        }
    }

    private void pushMyPresence() throws ServiceException {
        this.pushMyPresence(null);
    }

    private void pushMyPresence(JID sendTo) throws ServiceException {
        IMPresence presence = this.getEffectivePresence();
        if (sendTo == null) {
            IMPresenceUpdateNotification event = new IMPresenceUpdateNotification(this.mAddr, presence);
            this.postIMNotification(event);
        }
        this.updateXMPPPresence(sendTo, presence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutgoingSubscription(OperationContext octxt, IMAddr address, String name, String[] groups) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            Presence unsubscribePacket = new Presence(Presence.Type.unsubscribe);
            unsubscribePacket.setTo(address.makeJID());
            this.xmppRoute((Packet)unsubscribePacket);
            this.postIMNotification(IMSubscribedNotification.create(address, name, groups, false, false, Roster.Ask.unsubscribe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(OperationContext octxt, IMAddr toAddr, String threadId, IMMessage message) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            String msg;
            IMChat chat = this.mChats.get(threadId);
            if (chat == null) {
                for (IMChat cur : this.mChats.values()) {
                    if (cur.participants().size() > 2 || !cur.hasParticipant(toAddr)) continue;
                    chat = cur;
                    break;
                }
                if (chat == null) {
                    threadId = "chat-" + this.mAddr.getNode() + "%" + this.mAddr.getDomain() + "-" + this.mCurChatId;
                    ++this.mCurChatId;
                    IMChat.Participant part = new IMChat.Participant(toAddr, false);
                    chat = new IMChat(this, threadId, part);
                    assert (threadId != null);
                    this.mChats.put(threadId, chat);
                }
            }
            String string = msg = message.getBody(IMMessage.Lang.DEFAULT) != null ? message.getBody(IMMessage.Lang.DEFAULT).getPlainText() : null;
            if (msg != null && msg.startsWith("/")) {
                String[] words;
                if (msg.startsWith("/add ")) {
                    String username = msg.substring("/add ".length()).trim();
                    IMAddr newUser = new IMAddr(username);
                    ZimbraLog.im.info("Adding user: \"" + username + "\" to chat " + threadId);
                    this.addUserToChat(null, chat, newUser, "Please join my chat");
                    return;
                }
                if (msg.startsWith("/join")) {
                    words = msg.split("\\s+");
                    this.debug("Trying to join groupchat: %s", words[1]);
                    chat.joinMUCChat(words[1]);
                    return;
                }
                if (msg.startsWith("/info")) {
                    String info = chat.toString();
                    message.addBody(new IMMessage.TextPart(info));
                    IMMessageNotification notification = new IMMessageNotification(new IMAddr("SYSTEM"), chat.getThreadId(), message, 0);
                    this.postIMNotification(notification);
                    return;
                }
                if (msg.startsWith("/join_group")) {
                    words = msg.split("\\s+");
                    this.debug("Trying to join shared group: %s", words[1]);
                    this.joinSharedGroup(words[1]);
                    return;
                }
                if (msg.startsWith("/leave_group")) {
                    words = msg.split("\\s+");
                    this.debug("Trying to leave shared group: %s", words[1]);
                    this.leaveSharedGroup(words[1]);
                    return;
                }
                if (msg.startsWith("/block")) {
                    if (msg.equals("/block")) {
                        msg = "/block ";
                    }
                    msg = msg.substring("/block ".length());
                    String[] addrs = msg.split(",");
                    String listName = this.mDefaultPrivacyListName;
                    if (listName == null) {
                        listName = "default";
                    }
                    PrivacyList pl = new PrivacyList(listName);
                    int order = 1;
                    for (String s : addrs) {
                        if (s.length() <= 0) continue;
                        PrivacyListEntry entry = new PrivacyListEntry(new IMAddr(s), order, PrivacyListEntry.Action.deny, 15);
                        try {
                            pl.addEntry(entry);
                        }
                        catch (PrivacyList.DuplicateOrderException e) {
                            e.printStackTrace();
                        }
                        ++order;
                    }
                    this.setPrivacyList(pl);
                }
            }
            chat.sendMessage(octxt, toAddr, threadId, message, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMyPresence(OperationContext octxt, IMPresence presence) throws ServiceException {
        Object object = this.getLock();
        synchronized (object) {
            this.mMyPresence = presence;
            PresencePriorityMap map = this.mBufferedPresence.get(this.mAddr);
            if (map == null) {
                map = new PresencePriorityMap();
                this.mBufferedPresence.put(this.mAddr, map);
            }
            map.addPresenceUpdate(this.getResource(), presence);
            this.pushMyPresence();
        }
    }

    public String toString() {
        return new Formatter().format("IMPersona(%s  %s)", this.mAddr, this.mMyPresence).toString();
    }

    private void updateXMPPPresence(JID sendTo, IMPresence pres) {
        if (this.mXMPPSession != null) {
            Presence xmppPresence = pres.getXMPPPresence();
            if (sendTo == null) {
                for (IMChat chat : this.mChats.values()) {
                    chat.sendPresenceUpdate(xmppPresence);
                }
            } else {
                xmppPresence.setTo(sendTo);
            }
            this.xmppRoute((Packet)xmppPresence);
        }
    }

    void xmppRoute(Packet packet) {
        if (this.mXMPPSession != null) {
            ZimbraLog.im.debug("SENDING XMPP PACKET: " + packet.toXML());
            packet.setFrom(this.mXMPPSession.getAddress());
            IMRouter.getInstance().postEvent(packet);
        }
    }

    public static abstract class RequestCompletionHandler {
        private IQ request = null;
        private IQ response = null;

        RequestCompletionHandler(IQ iq) {
            this.request = iq;
        }

        public synchronized IQ getRequest() {
            return this.request;
        }

        public synchronized IQ getRespnse() {
            return this.response;
        }

        public final synchronized void onResultReceived(IQ response) {
            this.response = response;
            this.resultReceived(response);
            this.notifyAll();
        }

        public synchronized boolean isResponseReceived() {
            return this.response != null;
        }

        public synchronized boolean isError() {
            if (this.isResponseReceived()) {
                return this.response.getType() == IQ.Type.error;
            }
            return false;
        }

        protected abstract void resultReceived(IQ var1);
    }

    static class DiscoItemResult {
        public String name;
        public String jid;

        DiscoItemResult() {
        }
    }

    private static class DiscoItemsCompletion
    extends RequestCompletionHandler {
        private DiscoItemsResult di;

        public DiscoItemsResult getDiscoItemsResult() {
            return this.di;
        }

        DiscoItemsCompletion(IQ iq) {
            super(iq);
        }

        protected void resultReceived(IQ response) {
            switch (response.getType()) {
                case result: {
                    this.di = IMPersona.handleDiscoItemsResult(response);
                }
            }
        }
    }

    private static class DiscoInfoCompletion
    extends RequestCompletionHandler {
        private DiscoInfoResult di;

        public DiscoInfoResult getDiscoInfoResult() {
            return this.di;
        }

        DiscoInfoCompletion(IQ iq) {
            super(iq);
        }

        protected void resultReceived(IQ response) {
            switch (response.getType()) {
                case result: {
                    this.di = IMPersona.handleDiscoInfoResult(response);
                }
            }
        }
    }

    static class DiscoItemsResult {
        public List<DiscoItemResult> items = new ArrayList<DiscoItemResult>();

        DiscoItemsResult() {
        }
    }

    private static class IQQueryCompletion
    extends RequestCompletionHandler {
        private IQ result;

        public IQ getResult() {
            return this.result;
        }

        IQQueryCompletion(IQ iq) {
            super(iq);
        }

        protected void resultReceived(IQ response) {
            this.result = response;
        }
    }

    private static class DiscoInfoResult {
        public String jid;
        public String category;
        public String name;
        public String type;
        public IQ resultIQ;
        public List<String> features = new ArrayList<String>();

        private DiscoInfoResult() {
        }

        public String toString() {
            return this.jid + " - " + this.name + " - " + this.category + " - " + this.type;
        }
    }

    private static final class IdleInfo {
        public boolean isIdle = false;
        public long idleStartTime = 0L;

        IdleInfo() {
        }

        IdleInfo(boolean isIdle, long idleStartTime) {
            this.isIdle = isIdle;
            this.idleStartTime = idleStartTime;
        }
    }
}

