/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMBaseMessageNotification;
import com.zimbra.cs.im.IMMessage;
import java.util.Formatter;

public class IMMessageNotification
extends IMBaseMessageNotification {
    private IMMessage mMessage;
    private int mSeqNo;
    private String mToAddr;

    public IMMessageNotification(IMAddr fromAddr, String threadId, IMMessage message, int seqNo) {
        super(fromAddr.toString(), threadId, message.isTyping(), message.getTimestamp());
        this.mMessage = message;
        this.mSeqNo = seqNo;
        try {
            this.mToAddr = message.getTo().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Element toXml(Element parent) throws ServiceException {
        Element e = super.toXml(parent);
        if (this.mToAddr != null) {
            e.addAttribute("to", this.mToAddr);
        }
        e.addAttribute("seq", this.mSeqNo);
        this.mMessage.toXml(e);
        return e;
    }

    public String toString() {
        return new Formatter().format("IMSendMessageEvent: %s --> thread %s Message=%s", this.getFromAddr(), this.getThreadId(), this.mMessage.toString()).toString();
    }

    public final String getToAddr() {
        return this.mToAddr;
    }
}

