/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.html.HtmlDefang;
import com.zimbra.cs.im.IMAddr;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class IMMessage {
    private TextPart mSubject;
    private TextPart mBody;
    private Map<Lang, TextPart> mLangSubjects;
    private Map<Lang, TextPart> mLangBodies;
    private Date mDate;
    private IMAddr mFrom;
    private IMAddr mTo;
    private boolean mIsTyping;

    public String toString() {
        return "MESSAGE(" + this.mDate + "): " + this.mSubject + " " + this.mBody;
    }

    public void setFrom(IMAddr from) {
        this.mFrom = from;
    }

    public void setTo(IMAddr to) {
        this.mTo = to;
    }

    public IMMessage(TextPart subject, TextPart body, boolean isTyping) {
        this.mSubject = subject;
        this.mBody = body;
        this.mDate = new Date();
        this.mIsTyping = isTyping;
    }

    void addSubject(TextPart subj) {
        if (subj.mLang == Lang.DEFAULT) {
            this.mSubject = subj;
            return;
        }
        if (this.mSubject == null) {
            this.mSubject = subj;
        }
        if (this.mLangSubjects == null) {
            this.mLangSubjects = new HashMap<Lang, TextPart>();
        }
        this.mLangSubjects.put(subj.mLang, subj);
    }

    void addBody(TextPart body) {
        if (body.mLang == Lang.DEFAULT) {
            this.mBody = body;
            return;
        }
        if (this.mBody == null) {
            this.mBody = body;
        }
        if (this.mLangBodies == null) {
            this.mLangBodies = new HashMap<Lang, TextPart>();
        }
        this.mLangBodies.put(body.mLang, body);
    }

    public boolean isTyping() {
        return this.mIsTyping;
    }

    public Element toXml(Element parent) {
        Element e;
        if (this.mSubject != null) {
            e = parent.addElement("subject");
            e.addElement(this.mSubject.getPlainText());
        }
        if (this.mBody != null) {
            e = parent.addElement("body");
            try {
                if (this.mBody.hasXHTML()) {
                    e.addAttribute("html", true);
                    e.setText(HtmlDefang.defang(this.mBody.getXHTMLAsString(), true));
                } else {
                    e.addAttribute("html", false);
                    e.setText(this.mBody.getPlainText());
                }
            }
            catch (IOException ex) {
                e.addAttribute("html", true);
                e.setText("Unable to encode text: " + ex);
                ZimbraLog.im.warn((Object)("Caught exception while HtmlDefang-ing IM message: \"" + this.mBody.toString() + "\""), ex);
            }
        }
        return parent;
    }

    public IMAddr getFrom() {
        return this.mFrom;
    }

    public IMAddr getTo() {
        return this.mTo;
    }

    public long getTimestamp() {
        return this.mDate.getTime();
    }

    public Date getDate() {
        return this.mDate;
    }

    public TextPart getSubject(Lang lang) {
        if (lang == Lang.DEFAULT || this.mSubject != null && this.mSubject.mLang == lang || this.mLangSubjects == null || !this.mLangSubjects.containsKey((Object)lang)) {
            return this.mSubject;
        }
        return this.mLangSubjects.get((Object)lang);
    }

    public TextPart getBody() {
        return this.getBody(Lang.DEFAULT);
    }

    public TextPart getBody(Lang lang) {
        if (lang == Lang.DEFAULT || this.mBody != null && this.mBody.mLang == lang || this.mLangBodies == null || !this.mLangBodies.containsKey((Object)lang)) {
            return this.mBody;
        }
        return this.mLangBodies.get((Object)lang);
    }

    public static class TextPart {
        private Lang mLang;
        private String mPlaintext = null;
        private String mXHTMLAsText = null;
        private org.dom4j.Element mXHTML;

        public TextPart(Lang lang, String plaintext) {
            this.mLang = lang;
            this.mPlaintext = plaintext;
        }

        public TextPart(org.dom4j.Element body) {
            this.mXHTML = body;
        }

        public TextPart(String plaintext) {
            this(Lang.DEFAULT, plaintext);
        }

        public TextPart(String plaintext, org.dom4j.Element body) {
            this.mXHTML = body;
            this.mPlaintext = plaintext;
        }

        public Lang getLang() {
            return this.mLang;
        }

        public String getXHTMLAsString() {
            if (this.mXHTMLAsText != null) {
                return this.mXHTMLAsText;
            }
            if (this.mXHTML == null) {
                return null;
            }
            String s = this.mXHTML.asXML();
            int start = s.indexOf(62);
            int end = s.lastIndexOf(60);
            this.mXHTMLAsText = start > 0 && end > 0 ? s.substring(start + 1, end) : s;
            return this.mXHTMLAsText;
        }

        public String getPlainText() {
            if (this.mPlaintext != null) {
                return this.mPlaintext;
            }
            if (this.mXHTML == null) {
                return this.mPlaintext;
            }
            this.mPlaintext = this.depthFirstTextExtract(this.mXHTML);
            return this.mPlaintext;
        }

        public org.dom4j.Element getXHTML() {
            return this.mXHTML;
        }

        public boolean hasXHTML() {
            return this.getXHTMLAsString() != null;
        }

        private String depthFirstTextExtract(org.dom4j.Element cur) {
            StringBuilder toRet = new StringBuilder();
            Iterator nodeIter = cur.nodeIterator();
            while (nodeIter.hasNext()) {
                Node node = (Node)nodeIter.next();
                if (node instanceof org.dom4j.Element) {
                    toRet.append(this.depthFirstTextExtract((org.dom4j.Element)node));
                    continue;
                }
                if (node instanceof Namespace) continue;
                toRet.append(node.asXML());
            }
            return toRet.toString();
        }

        public String toString() {
            if (this.hasXHTML()) {
                return this.getXHTMLAsString();
            }
            return this.getPlainText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Lang {
        EN,
        DEFAULT;

    }
}

