/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.soap.Element;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMChat;
import com.zimbra.cs.im.IMChatNotification;
import java.util.Formatter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMLeftChatNotification
extends IMChatNotification {
    List<IMChat.MucStatusCode> statusCodes;
    boolean isMe;

    IMLeftChatNotification(IMAddr from, boolean isMe, String threadId, List<IMChat.MucStatusCode> statusCodes) {
        super(from, threadId);
        this.statusCodes = statusCodes;
        this.isMe = isMe;
    }

    @Override
    public String toString() {
        return new Formatter().format("IMLeftChatNotification: %s", super.toString()).toString();
    }

    @Override
    public Element toXml(Element parent) {
        Element toRet = IMLeftChatNotification.create(parent, "leftchat");
        super.toXml(toRet);
        if (this.isMe) {
            toRet.addAttribute("me", true);
        }
        StringBuilder errors = new StringBuilder();
        StringBuilder status = new StringBuilder();
        for (IMChat.MucStatusCode code : this.statusCodes) {
            if (code.isError()) {
                if (errors.length() > 0) {
                    errors.append(",");
                }
                errors.append(code.name());
                continue;
            }
            if (status.length() > 0) {
                status.append(",");
            }
            status.append(code.name());
        }
        if (status.length() > 0) {
            toRet.addAttribute("status", status.toString());
        }
        if (errors.length() > 0) {
            toRet.addAttribute("error", errors.toString());
        }
        return toRet;
    }
}

