/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.im.IMNotification;
import java.util.Formatter;

public class IMGatewayStateNotification
extends IMNotification {
    String mServiceName;
    String mState;
    String mDelay;

    IMGatewayStateNotification(String serviceName, String state, String delay) {
        this.mServiceName = serviceName;
        this.mState = state;
        this.mDelay = delay;
    }

    public String toString() {
        return new Formatter().format("IMGatewayStateNotification(%s, State=%s)", this.mServiceName, this.mState).toString();
    }

    public Element toXml(Element parent) throws ServiceException {
        ZimbraLog.im.debug(this.toString());
        Element toRet = IMGatewayStateNotification.create(parent, "gwStatus");
        toRet.addAttribute("service", this.mServiceName);
        toRet.addAttribute("state", this.mState);
        if (this.mDelay != null) {
            toRet.addAttribute("timeUntilNextConnect", this.mDelay);
        }
        return toRet;
    }
}

