/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.im.IMRouter;
import java.util.ArrayList;
import java.util.List;

public abstract class IMEvent
implements Runnable {
    protected List<IMAddr> mTargets = new ArrayList<IMAddr>(1);

    protected IMEvent(IMAddr target) {
        this.mTargets.add(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        for (IMAddr addr : this.mTargets) {
            try {
                if (addr.getAddr().indexOf(64) > 0) {
                    IMPersona persona = IMRouter.getInstance().findPersona(null, addr);
                    if (persona != null) {
                        Object object = persona.getLock();
                        synchronized (object) {
                            this.handleTarget(persona);
                            continue;
                        }
                    }
                    ZimbraLog.im.debug("Ignoring IMEvent for " + addr.toString() + " (could not find Mailbox): " + this.toString());
                    continue;
                }
                ZimbraLog.im.debug("Ignoring IMEvent for " + addr.toString() + " (addr has no domain): " + this.toString());
            }
            catch (Exception e) {
                ZimbraLog.im.debug("Caught exception running event: " + this + " except=" + e);
                e.printStackTrace();
            }
        }
    }

    protected void handleTarget(IMPersona persona) throws ServiceException {
    }
}

