/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMBaseMessageNotification;
import com.zimbra.cs.im.IMMessage;
import org.xmpp.packet.PacketError;

public class IMErrorMessageNotification
extends IMBaseMessageNotification {
    private PacketError.Condition mErrorCondition = null;
    private IMMessage mErrorText;

    public IMErrorMessageNotification(String fromAddr, String threadId, boolean typing, long timestamp, String errorText, PacketError.Condition errorCondition) {
        super(fromAddr, threadId, typing, timestamp);
        this.mErrorCondition = errorCondition;
        this.mErrorText = new IMMessage(null, new IMMessage.TextPart("ERROR: " + errorText), false);
        this.mErrorText.setFrom(new IMAddr(fromAddr));
    }

    public Element toXml(Element parent) throws ServiceException {
        Element e = super.toXml(parent);
        if (this.mErrorCondition != null) {
            e.addAttribute("error", this.mErrorCondition.name());
        }
        this.mErrorText.toXml(e);
        return e;
    }
}

