/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.soap.Element;
import com.zimbra.cs.im.IMChat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.wildfire.forms.FormField;
import org.jivesoftware.wildfire.forms.spi.XDataFormImpl;
import org.xmpp.packet.IQ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMConferenceRoom {
    private String threadId;
    private IMChat chat;
    private String addr;
    private Map<RoomConfig, Object> data = new HashMap<RoomConfig, Object>();
    private boolean haveOwnerConfig = false;

    public Element toXML(Element parent) {
        Element toRet = parent.addElement("room");
        if (this.chat != null) {
            toRet.addAttribute("threadId", this.chat.getThreadId());
            toRet.addAttribute("addr", this.chat.getDestAddr());
        } else {
            toRet.addAttribute("addr", this.addr);
        }
        if (this.haveOwnerConfig) {
            toRet.addAttribute("owner", true);
        }
        for (Map.Entry<RoomConfig, Object> entry : this.data.entrySet()) {
            Element var = toRet.addElement("var");
            RoomConfig config = entry.getKey();
            var.addAttribute("name", config.name());
            if (!config.isMulti()) {
                String value = (String)entry.getValue();
                var.setText(value);
                continue;
            }
            var.addAttribute("multi", true);
            List values = (List)entry.getValue();
            for (String value : values) {
                Element valueElt = var.addElement("value");
                valueElt.setText(value);
            }
        }
        return parent;
    }

    public String toString() {
        return "Room(" + this.threadId + " " + (this.chat != null ? this.chat.getDestAddr() : this.addr) + ")";
    }

    IMConferenceRoom(IMChat chat) {
        this.chat = chat;
        this.addr = null;
    }

    IMConferenceRoom(String addr) {
        this.addr = addr;
        this.chat = null;
    }

    private void parseNonExtended(org.dom4j.Element item) {
        String var = item.attributeValue("var");
        RoomConfig config = RoomConfig.lookupFromInfoName(var);
        if (config == null) {
            if ("muc_hidden".equals(var)) {
                this.data.put(RoomConfig.publicroom, "0");
            } else if ("muc_unmoderated".equals(var)) {
                this.data.put(RoomConfig.moderated, "0");
            } else if ("muc_temporary".equals(var)) {
                this.data.put(RoomConfig.persistent, "0");
            }
        } else {
            this.data.put(config, "1");
        }
    }

    private void parseExtended(String name, List<String> values) {
        RoomConfig config = RoomConfig.lookupFromInfoName(name);
        if (config != null && values.size() > 0) {
            if (config.isMulti()) {
                this.data.put(config, values);
            } else {
                this.data.put(config, values.get(0));
            }
        }
    }

    private void parseExtendedConfig(String name, List<String> values) {
        RoomConfig config = RoomConfig.lookupFromConfigName(name);
        if (config != null && values.size() > 0) {
            if (config.isMulti()) {
                this.data.put(config, values);
            } else {
                this.data.put(config, values.get(0));
            }
        }
    }

    void parseConfigurationForm(org.dom4j.Element x) {
        if ("jabber:x:data".equals(x.getNamespaceURI())) {
            XDataFormImpl form = new XDataFormImpl();
            form.parse(x);
            Iterator fieldIter = form.getFields();
            while (fieldIter.hasNext()) {
                FormField field = (FormField)fieldIter.next();
                ArrayList<String> values = new ArrayList<String>();
                Iterator valueIter = field.getValues();
                while (valueIter.hasNext()) {
                    values.add((String)valueIter.next());
                }
                this.parseExtendedConfig(field.getVariable(), values);
            }
        }
        this.haveOwnerConfig = true;
    }

    public static IMConferenceRoom emptyRoom(IMChat chat) {
        return new IMConferenceRoom(chat);
    }

    public static IMConferenceRoom emptyRoom(String destAddr) {
        return new IMConferenceRoom(destAddr);
    }

    public static IMConferenceRoom parseRoomInfo(IMChat chat, String addr, IQ iq) {
        assert (chat == null || addr == null);
        org.dom4j.Element child = iq.getChildElement();
        if (!"http://jabber.org/protocol/disco#info".equals(child.getNamespaceURI())) {
            throw new IllegalArgumentException("Expecting a disco#info, got: " + iq.toXML());
        }
        IMConferenceRoom room = chat != null ? new IMConferenceRoom(chat) : new IMConferenceRoom(addr);
        Iterator iter = child.elementIterator("feature");
        while (iter.hasNext()) {
            org.dom4j.Element item = (org.dom4j.Element)iter.next();
            room.parseNonExtended(item);
        }
        iter = child.elementIterator("x");
        while (iter.hasNext()) {
            org.dom4j.Element x = (org.dom4j.Element)iter.next();
            if (!"jabber:x:data".equals(x.getNamespaceURI())) continue;
            XDataFormImpl form = new XDataFormImpl();
            form.parse(x);
            Iterator fieldIter = form.getFields();
            while (fieldIter.hasNext()) {
                FormField field = (FormField)fieldIter.next();
                ArrayList<String> values = new ArrayList<String>();
                Iterator valueIter = field.getValues();
                while (valueIter.hasNext()) {
                    values.add((String)valueIter.next());
                }
                room.parseExtended(field.getVariable(), values);
            }
        }
        return room;
    }

    static IQ generateConfigIQ(IQ iq, Map<String, Object> data) {
        org.dom4j.Element query = iq.setChildElement("query", "http://jabber.org/protocol/muc#owner");
        org.dom4j.Element x = query.addElement("x", "jabber:x:data");
        x.addAttribute("type", "submit");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String var = entry.getKey();
            RoomConfig config = RoomConfig.valueOf(var);
            org.dom4j.Element fieldElt = x.addElement("field");
            fieldElt.addAttribute("var", config.getRoomconfigName());
            if (entry.getValue() instanceof String) {
                org.dom4j.Element valueElt = fieldElt.addElement("value");
                String value = (String)entry.getValue();
                if (config.getConfigType() == ConfigType.bool) {
                    if ("true".equalsIgnoreCase(value)) {
                        value = "1";
                    } else if ("false".equalsIgnoreCase(value)) {
                        value = "0";
                    }
                }
                valueElt.setText(value);
                continue;
            }
            List values = (List)entry.getValue();
            for (String value : values) {
                org.dom4j.Element valueElt = fieldElt.addElement("value");
                valueElt.setText(value);
            }
        }
        return iq;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RoomConfig {
        open("muc_open", null, ConfigType.bool),
        creationdate("x-muc#roominfo_creationdate", null, ConfigType.string),
        publicroom("muc_public", "muc#roomconfig_publicroom", ConfigType.bool),
        moderated("muc_moderated", "muc#roomconfig_moderatedroom", ConfigType.bool),
        persistent("muc_persistent", "muc#roomconfig_persistentroom", ConfigType.bool),
        membersonly("muc_membersonly", "muc#roomconfig_membersonly", ConfigType.bool),
        noanonymous("muc_nonanonymous", null, ConfigType.bool),
        semianonymous("muc_semianonymous", null, ConfigType.bool),
        passwordprotect("muc_passwordprotected", "muc#roomconfig_passwordprotectedroom", ConfigType.bool),
        password(null, "muc#roomconfig_roomsecret", ConfigType.string),
        numoccupants("muc#roominfo_occupants", null, ConfigType.string),
        maxusers("muc#roominfo_maxusers", "muc#roomconfig_maxusers", ConfigType.string),
        longname(null, "muc#roomconfig_roomname", ConfigType.string),
        description("muc#roominfo_description", "muc#roomconfig_roomdesc", ConfigType.string),
        subject("muc#roominfo_subject", null, ConfigType.string),
        subjectmodifyable("muc#roominfo_changesubject", "muc#roomconfig_changesubject", ConfigType.string),
        allowinvites(null, "muc#roomconfig_allowinvites", ConfigType.bool),
        presencebroadcast(null, "muc#roomconfig_presencebroadcast", ConfigType.string, Cardinality.multi),
        logsurl("muc#roominfo_logs", null, ConfigType.string),
        owners(null, "muc#roomconfig_roomowners", ConfigType.string, Cardinality.multi),
        admins(null, "muc#roomconfig_roomadmins", ConfigType.string, Cardinality.multi),
        whois(null, "muc#roomconfig_whois", ConfigType.string, Cardinality.multi),
        enablelogging(null, "muc#roomconfig_enablelogging", ConfigType.string),
        reservednick(null, "x-muc#roomconfig_reservednick", ConfigType.bool),
        canchangenick(null, "x-muc#roomconfig_canchangenick", ConfigType.bool),
        allowregister(null, "x-muc#roomconfig_registration", ConfigType.bool),
        getmemberlist(null, "muc#roomconfig_getmemberlist", ConfigType.string, Cardinality.multi),
        contactid("muc#roominfo_contactjid", null, ConfigType.string);

        private static Map<String, RoomConfig> infoToConfigMap;
        private static Map<String, RoomConfig> configToConfigMap;
        private String infoName;
        private String configName;
        private ConfigType configType;
        private Cardinality cardinality;

        private RoomConfig(String infoName, String configName, ConfigType configType) {
            this(infoName, configName, configType, Cardinality.single);
        }

        private RoomConfig(String infoName, String configName, ConfigType configType, Cardinality cardinality) {
            this.infoName = infoName;
            this.configName = configName;
            this.configType = configType;
            this.cardinality = cardinality;
        }

        public static RoomConfig lookupFromInfoName(String xmppName) {
            return infoToConfigMap.get(xmppName);
        }

        public static RoomConfig lookupFromConfigName(String xmppName) {
            return configToConfigMap.get(xmppName);
        }

        public String getRoominfoName() {
            return this.infoName;
        }

        public String getRoomconfigName() {
            return this.configName;
        }

        public boolean isMulti() {
            return this.cardinality == Cardinality.multi;
        }

        public ConfigType getConfigType() {
            return this.configType;
        }

        static {
            infoToConfigMap = new HashMap<String, RoomConfig>();
            for (RoomConfig config : RoomConfig.values()) {
                if (config.getRoominfoName() == null) continue;
                infoToConfigMap.put(config.getRoominfoName(), config);
            }
            configToConfigMap = new HashMap<String, RoomConfig>();
            for (RoomConfig config : RoomConfig.values()) {
                if (config.getRoomconfigName() == null) continue;
                configToConfigMap.put(config.getRoomconfigName(), config);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Cardinality {
        single,
        multi;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConfigType {
        bool,
        string;

    }
}

