/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.soap.Element;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMChat;
import com.zimbra.cs.im.IMChatNotification;
import java.util.Formatter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMChatPresenceNotification
extends IMChatNotification {
    private IMChat.Participant part;
    private boolean entered;
    List<IMChat.MucStatusCode> statusCodes;

    IMChatPresenceNotification(IMAddr addr, String threadId, boolean entered, IMChat.Participant part, List<IMChat.MucStatusCode> statusCodes) {
        super(addr, threadId);
        this.part = part;
        this.entered = entered;
        this.statusCodes = statusCodes;
    }

    @Override
    public String toString() {
        return new Formatter().format("IMChatPresenceNotification: %s, %s", super.toString(), this.part.toString()).toString();
    }

    @Override
    public Element toXml(Element parent) {
        Element toRet = this.entered ? IMChatPresenceNotification.create(parent, "enteredchat") : IMChatPresenceNotification.create(parent, "chatpresence");
        super.toXml(toRet);
        this.part.toXML(toRet);
        StringBuilder errors = new StringBuilder();
        StringBuilder status = new StringBuilder();
        for (IMChat.MucStatusCode code : this.statusCodes) {
            if (code.isError()) {
                if (errors.length() > 0) {
                    errors.append(",");
                }
                errors.append(code.name());
                continue;
            }
            if (status.length() > 0) {
                status.append(",");
            }
            status.append(code.name());
        }
        if (status.length() > 0) {
            toRet.addAttribute("status", status.toString());
        }
        if (errors.length() > 0) {
            toRet.addAttribute("error", errors.toString());
        }
        return toRet;
    }
}

