/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ClassLogger;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.im.ChatWriter;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMBaseMessageNotification;
import com.zimbra.cs.im.IMChatInviteNotification;
import com.zimbra.cs.im.IMChatPresenceNotification;
import com.zimbra.cs.im.IMErrorMessageNotification;
import com.zimbra.cs.im.IMLeftChatNotification;
import com.zimbra.cs.im.IMMessage;
import com.zimbra.cs.im.IMMessageNotification;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.mail.MessagingException;
import org.dom4j.Element;
import org.jivesoftware.wildfire.muc.MUCRole;
import org.xmpp.muc.Invitation;
import org.xmpp.muc.JoinRoom;
import org.xmpp.muc.LeaveRoom;
import org.xmpp.muc.RoomConfiguration;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMChat
extends ClassLogger {
    private boolean mIsMUC = false;
    private int mFirstSeqNo = 0;
    private int mLastFlushSeqNo = -1;
    private List<IMMessage> mMessages = Collections.synchronizedList(new ArrayList());
    private String mThreadId;
    private boolean mIsClosed = false;
    private Map<IMAddr, Participant> mParticipants = Collections.synchronizedMap(new HashMap());
    private IMPersona mPersona;
    private int mSavedChatId = -1;
    private JID mDestJid = null;
    private TIMER_STATE mTimerState = TIMER_STATE.NONE;
    private FlushTask mTimer = null;
    private String mNickname = null;
    JoinRoom mPendingJoin = null;
    Presence mJoinResponse = null;

    public int getFirstSeqNo() {
        return this.mFirstSeqNo;
    }

    public int getHighestSeqNo() {
        return this.mFirstSeqNo + this.mMessages.size();
    }

    private final long getCloseTimeout() {
        long tmp = LC.zimbra_im_chat_close_time.longValue() * 1000L;
        if (tmp <= 60000L) {
            tmp = 60000L;
        }
        return tmp;
    }

    private final long getSaveTimeout() {
        long tmp = LC.zimbra_im_chat_flush_time.longValue() * 1000L;
        if (tmp <= 1000L) {
            tmp = 1000L;
        }
        return tmp;
    }

    public boolean isMUC() {
        return this.mIsMUC;
    }

    String getDestAddr() {
        return this.mDestJid.toBareJID();
    }

    @Override
    protected Object formatObject(Object o) {
        if (o instanceof Packet) {
            return ((Packet)o).toXML();
        }
        return super.formatObject(o);
    }

    @Override
    protected String getInstanceInfo() {
        return this.toString();
    }

    IMChat(IMPersona persona, String threadId, Participant initialPart) {
        super(ZimbraLog.im);
        this.mPersona = persona;
        this.mThreadId = threadId;
        if (initialPart != null) {
            this.mParticipants.put(initialPart.getAddress(), initialPart);
            this.mDestJid = initialPart.getAddress().makeJID();
        }
        this.mIsMUC = false;
    }

    void closeChat() {
        if (this.isMUC()) {
            LeaveRoom l = new LeaveRoom(this.mPersona.getFullJidAsString(), this.getMUCJidWithNickname());
            this.mPersona.xmppRoute((Packet)l);
        }
        this.enableTimer(TIMER_STATE.NONE);
        if (!this.mIsClosed) {
            this.flush();
            this.mIsClosed = true;
        }
    }

    void handleIQPacket(IQ iq) {
        this.info("Got an IQ packet for chat: ", iq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePresencePacket(boolean toMe, Presence pres) {
        this.info("Got a presence update packet for chat: %s", pres);
        if (this.isMUC()) {
            String fromNick = pres.getFrom().getResource();
            boolean isMe = false;
            if (fromNick.equals(this.mNickname)) {
                isMe = true;
            }
            if (pres.getType() == Presence.Type.error) {
                if (this.mPendingJoin != null && this.getMyNickname().equals(fromNick)) {
                    JoinRoom joinRoom = this.mPendingJoin;
                    synchronized (joinRoom) {
                        this.mJoinResponse = pres;
                        JoinRoom pj = this.mPendingJoin;
                        this.mPendingJoin = null;
                        pj.notifyAll();
                    }
                } else {
                    IMErrorMessageNotification not = new IMErrorMessageNotification(pres.getFrom().toBareJID(), this.getThreadId(), false, System.currentTimeMillis(), pres.toXML(), pres.getError().getCondition());
                    this.mPersona.postIMNotification(not);
                }
            } else {
                Participant p;
                if (this.mPendingJoin != null && this.getMyNickname().equals(fromNick)) {
                    JoinRoom not = this.mPendingJoin;
                    synchronized (not) {
                        this.mJoinResponse = pres;
                        JoinRoom pj = this.mPendingJoin;
                        this.mPendingJoin = null;
                        pj.notifyAll();
                    }
                }
                String fromFullJID = null;
                MUCRole.Affiliation affiliation = MUCRole.Affiliation.none;
                MUCRole.Role role = MUCRole.Role.none;
                ArrayList<MucStatusCode> statusCodes = new ArrayList<MucStatusCode>();
                Element x = pres.getChildElement("x", "http://jabber.org/protocol/muc#user");
                if (x != null) {
                    Element item = x.element("item");
                    if (item != null) {
                        String roleStr;
                        fromFullJID = item.attributeValue("jid");
                        String affiliationStr = item.attributeValue("affiliation");
                        if (affiliationStr != null) {
                            affiliation = MUCRole.Affiliation.valueOf((String)affiliationStr);
                        }
                        if ((roleStr = item.attributeValue("role")) != null) {
                            role = MUCRole.Role.valueOf((String)roleStr);
                        }
                    }
                    Iterator statusIter = x.elementIterator("status");
                    while (statusIter.hasNext()) {
                        Element status = (Element)statusIter.next();
                        if (status == null) continue;
                        String code = status.attributeValue("code");
                        int num = Integer.parseInt(code);
                        statusCodes.add(MucStatusCode.lookup(num));
                    }
                }
                if (pres.getType() == Presence.Type.unavailable) {
                    p = this.removeParticipant(new IMAddr(fromNick));
                    if (p != null) {
                        IMLeftChatNotification left = new IMLeftChatNotification(p.getAddress(), isMe, this.getThreadId(), statusCodes);
                        this.mPersona.postIMNotification(left);
                    }
                } else {
                    IMAddr toUse = new IMAddr(fromNick);
                    boolean isNewPart = false;
                    if (!this.hasParticipant(toUse)) {
                        isNewPart = true;
                    }
                    p = this.updateParticipant(true, toUse, isMe, fromNick, fromFullJID, role, affiliation);
                    IMChatPresenceNotification not = new IMChatPresenceNotification(toUse, this.getThreadId(), isNewPart, p, statusCodes);
                    this.mPersona.postIMNotification(not);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessagePacket(boolean toMe, Message msg) {
        int seqNoStart;
        block27: {
            block26: {
                seqNoStart = this.getHighestSeqNo();
                try {
                    Element inviteElement;
                    String mucInvitationFrom = null;
                    String messageFrom = msg.getFrom().toBareJID();
                    String subject = msg.getSubject();
                    IMMessage.TextPart bodyPart = null;
                    boolean isError = false;
                    if (msg.getType() == Message.Type.error) {
                        isError = true;
                        bodyPart = new IMMessage.TextPart("ERROR: " + msg.toXML());
                        IMErrorMessageNotification notification = new IMErrorMessageNotification(messageFrom, this.getThreadId(), false, System.currentTimeMillis(), msg.toXML(), msg.getError().getCondition());
                        this.mPersona.postIMNotification(notification);
                        Object var15_11 = null;
                        if (this.getHighestSeqNo() > seqNoStart) {
                            this.enableTimer(TIMER_STATE.WAITING_TO_SAVE);
                            return;
                        }
                        this.enableTimer(TIMER_STATE.WAITING_TO_CLOSE);
                        return;
                    }
                    Element htmlElt = msg.getChildElement("html", "http://jabber.org/protocol/xhtml-im");
                    if (htmlElt != null) {
                        List elements = htmlElt.elements("body");
                        for (Element e : elements) {
                            if (!"http://www.w3.org/1999/xhtml".equals(e.getNamespaceURI())) continue;
                            bodyPart = new IMMessage.TextPart(msg.getBody(), e);
                        }
                    }
                    if (bodyPart == null && msg.getBody() != null && msg.getBody().length() > 0) {
                        bodyPart = new IMMessage.TextPart(msg.getBody());
                    }
                    Element xElt = null;
                    xElt = msg.getChildElement("x", "http://jabber.org/protocol/muc#user");
                    if (xElt != null && (inviteElement = xElt.element("invite")) != null) {
                        mucInvitationFrom = inviteElement.attributeValue("from");
                        if (bodyPart == null || bodyPart.getPlainText().length() == 0) {
                            Element reason = inviteElement.element("reason");
                            bodyPart = reason != null ? new IMMessage.TextPart(reason.getText() + " (/join " + msg.getFrom().toBareJID() + ")") : new IMMessage.TextPart(mucInvitationFrom + " has invited you into a groupchat " + " (/join " + msg.getFrom().toBareJID() + ")");
                        }
                    }
                    if (this.mIsMUC && messageFrom.equals(this.mDestJid.toBareJID())) {
                        String resource = msg.getFrom().getResource();
                        if (resource != null && resource.length() > 0) {
                            messageFrom = msg.getFrom().getResource();
                            if (!isError && this.getMyNickname().equals(messageFrom) && msg.getChildElement("x", "jabber:x:delay") == null) {
                                this.info("Skipping MUC message from me: %s", msg);
                                break block26;
                            }
                        } else {
                            this.debug("Message is from Conference itself", new Object[0]);
                        }
                    }
                    boolean typing = false;
                    Element x = msg.getChildElement("composing", "http://jabber.org/protocol/chatstates");
                    if (x != null) {
                        typing = true;
                    } else {
                        x = msg.getChildElement("active", "http://jabber.org/protocol/chatstates");
                        if (x != null) {
                            typing = false;
                        } else {
                            x = msg.getChildElement("x", "http://jabber.org/protocol/chatstates");
                            if (x != null) {
                                typing = x.element("composing") != null;
                            }
                        }
                    }
                    if (!(mucInvitationFrom != null || subject != null && subject.length() != 0 || bodyPart != null && bodyPart.getPlainText().length() != 0)) {
                        IMBaseMessageNotification notification = new IMBaseMessageNotification(msg.getFrom().toBareJID(), this.getThreadId(), typing, System.currentTimeMillis());
                        this.mPersona.postIMNotification(notification);
                        break block27;
                    }
                    if (mucInvitationFrom != null && this.mMessages.size() > 0) {
                        if (mucInvitationFrom != null) {
                            this.systemNotification("Automatically joining converted multi-user-chat");
                            this.joinMUCChat(msg.getFrom().toBareJID());
                        }
                        break block27;
                    }
                    if (mucInvitationFrom != null) {
                        IMChatInviteNotification inviteNot = new IMChatInviteNotification(new IMAddr(msg.getFrom().toBareJID()), this.getThreadId(), bodyPart.getPlainText());
                        this.mPersona.postIMNotification(inviteNot);
                    }
                    this.addMessage(true, new IMAddr(messageFrom), subject, bodyPart, typing);
                    assert (this.getHighestSeqNo() > seqNoStart);
                    break block27;
                }
                catch (Throwable throwable) {
                    Object var15_14 = null;
                    if (this.getHighestSeqNo() > seqNoStart) {
                        this.enableTimer(TIMER_STATE.WAITING_TO_SAVE);
                        throw throwable;
                    }
                    this.enableTimer(TIMER_STATE.WAITING_TO_CLOSE);
                    throw throwable;
                }
            }
            Object var15_12 = null;
            if (this.getHighestSeqNo() > seqNoStart) {
                this.enableTimer(TIMER_STATE.WAITING_TO_SAVE);
                return;
            }
            this.enableTimer(TIMER_STATE.WAITING_TO_CLOSE);
            return;
        }
        Object var15_13 = null;
        if (this.getHighestSeqNo() > seqNoStart) {
            this.enableTimer(TIMER_STATE.WAITING_TO_SAVE);
            return;
        }
        this.enableTimer(TIMER_STATE.WAITING_TO_CLOSE);
    }

    void systemNotification(String text) {
        IMMessage message = new IMMessage(null, new IMMessage.TextPart(text), false);
        IMMessageNotification notification = new IMMessageNotification(new IMAddr("SYSTEM"), this.getThreadId(), message, 0);
        this.mPersona.postIMNotification(notification);
    }

    void sendPresenceUpdate(Presence pres) {
        if (this.mIsMUC) {
            Presence toSend = pres.createCopy();
            toSend.setFrom(this.mPersona.getFullJidAsString());
            toSend.setTo(this.getMUCJidWithNickname());
            this.mPersona.xmppRoute((Packet)toSend);
        }
    }

    void sendMessage(OperationContext octxt, IMAddr toAddr, String threadId, IMMessage message, IMPersona sender) throws ServiceException {
        IMAddr fromAddr = this.mPersona.getAddr();
        message.setFrom(fromAddr);
        message.setTo(toAddr);
        boolean blankSubj = false;
        boolean blankBody = false;
        IMMessage.TextPart tp = message.getSubject(IMMessage.Lang.DEFAULT);
        if (tp == null || tp.getPlainText() == null || tp.getPlainText().length() == 0) {
            blankSubj = true;
        }
        if ((tp = message.getBody()) == null || tp.getPlainText() == null || tp.getPlainText().length() == 0) {
            blankBody = true;
        }
        if (!blankSubj || !blankBody) {
            this.addMessage(true, message);
        }
        Message xmppMsg = new Message();
        xmppMsg.setFrom(fromAddr.makeFullJID(sender.getResource()));
        xmppMsg.setTo(this.mDestJid);
        if (this.mIsMUC) {
            xmppMsg.setType(Message.Type.groupchat);
        } else {
            xmppMsg.setThread(this.getThreadId());
            xmppMsg.setType(Message.Type.chat);
        }
        if (message.getSubject(IMMessage.Lang.DEFAULT) != null) {
            xmppMsg.setSubject(message.getSubject(IMMessage.Lang.DEFAULT).getPlainText());
        }
        if (message.getBody(IMMessage.Lang.DEFAULT) != null) {
            xmppMsg.setBody(message.getBody(IMMessage.Lang.DEFAULT).getPlainText());
            if (message.getBody().hasXHTML()) {
                Element html = xmppMsg.addChildElement("html", "http://jabber.org/protocol/xhtml-im");
                html.add(message.getBody().getXHTML().createCopy());
            }
        }
        if (message.isTyping()) {
            xmppMsg.addChildElement("composing", "http://jabber.org/protocol/chatstates");
            Element x = xmppMsg.addChildElement("x", "jabber:x:event");
            x.addElement("composing");
            x.addElement("id").addText("composing");
        }
        this.mPersona.xmppRoute((Packet)xmppMsg);
    }

    private String getMyNickname() {
        if (this.mNickname == null) {
            this.mNickname = this.mPersona.getAddr().getNode();
            assert (this.mNickname != null && this.mNickname.length() > 0);
        }
        return this.mNickname;
    }

    private String getMUCJidWithNickname() {
        if (!this.isMUC()) {
            throw new IllegalStateException("MUC mode only");
        }
        return this.mDestJid.toString() + "/" + this.getMyNickname();
    }

    private void requestCreateChatroom() throws ServiceException {
        this.mDestJid = new JID(this.getThreadId(), this.mPersona.getMucDomain(), "");
        this.mIsMUC = true;
        JoinRoom createRoom = new JoinRoom(this.mPersona.getFullJidAsString(), this.getMUCJidWithNickname());
        this.mPersona.xmppRoute((Packet)createRoom);
        RoomConfiguration rc = new RoomConfiguration(new HashMap());
        rc.setTo(this.getMUCJidWithNickname());
        this.mPersona.xmppRoute((Packet)rc);
    }

    void joinMUCChat(String roomAddr) {
        this.mIsMUC = true;
        this.mDestJid = new JID(roomAddr);
        this.mPendingJoin = new JoinRoom(this.mPersona.getFullJidAsString(), this.getMUCJidWithNickname());
        this.mPersona.xmppRoute((Packet)this.mPendingJoin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MucStatusCode> syncJoinMUCChat(String roomAddr, String nickname, String password) throws ServiceException {
        Object pw;
        if (nickname != null) {
            this.mNickname = nickname;
        }
        this.mIsMUC = true;
        this.mDestJid = new JID(roomAddr);
        this.mPendingJoin = new JoinRoom(this.mPersona.getFullJidAsString(), this.getMUCJidWithNickname());
        if (password != null) {
            Element x = this.mPendingJoin.getChildElement("x", "http://jabber.org/protocol/muc");
            pw = x.addElement("password");
            pw.setText(password);
        }
        Presence response = null;
        pw = this.mPendingJoin;
        synchronized (pw) {
            this.mPersona.xmppRoute((Packet)this.mPendingJoin);
            try {
                this.mPendingJoin.wait(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.mJoinResponse != null) {
                response = this.mJoinResponse;
            }
        }
        ArrayList<MucStatusCode> toRet = new ArrayList<MucStatusCode>();
        this.debug("Join MUC: DestJID=" + this.mDestJid + " ResponsePres=" + response, new Object[0]);
        if (response != null) {
            if (response.getType() == Presence.Type.error) {
                Element error = response.getChildElement("error", "");
                if (error != null) {
                    String code = error.attributeValue("code");
                    int num = Integer.parseInt(code);
                    toRet.add(MucStatusCode.lookup(num));
                }
            } else {
                Element x = response.getChildElement("x", "http://jabber.org/protocol/muc#user");
                if (x != null) {
                    Iterator statusIter = x.elementIterator("status");
                    while (statusIter.hasNext()) {
                        Element status = (Element)statusIter.next();
                        if (status == null) continue;
                        String code = status.attributeValue("code");
                        int num = Integer.parseInt(code);
                        toRet.add(MucStatusCode.lookup(num));
                    }
                }
            }
        }
        return toRet;
    }

    void addUserToChat(IMAddr addr, String inviteMessage) throws ServiceException {
        if (!this.mIsMUC) {
            this.requestCreateChatroom();
            for (IMAddr currentAddr : this.mParticipants.keySet()) {
                if (currentAddr.equals(this.mPersona.getAddr()) || currentAddr.equals(addr)) continue;
                Invitation invite = new Invitation(currentAddr.toString(), inviteMessage);
                invite.setTo(this.mDestJid);
                this.mPersona.xmppRoute((Packet)invite);
            }
        }
        Invitation invite = new Invitation(addr.toString(), inviteMessage);
        invite.setTo(this.mDestJid);
        this.mPersona.xmppRoute((Packet)invite);
    }

    public String toString() {
        StringBuilder partsStr = new StringBuilder();
        boolean atStart = true;
        for (Participant part : this.mParticipants.values()) {
            if (!atStart) {
                partsStr.append(", ");
            } else {
                atStart = false;
            }
            partsStr.append(part.getAddress());
        }
        return new Formatter().format("IMChat(%s%s, dest=%s, participants={%s})", this.mThreadId, this.mIsMUC ? ", MUC" : "", this.mDestJid, partsStr.toString()).toString();
    }

    public String getThreadId() {
        return this.mThreadId;
    }

    boolean hasParticipant(IMAddr addrFrom) {
        Participant part = this.mParticipants.get(addrFrom);
        return part != null;
    }

    private Participant updateParticipant(boolean create, IMAddr addrFrom, boolean isMe, String resourceFrom, String nameFrom, MUCRole.Role role, MUCRole.Affiliation affiliation) {
        Participant part = this.mParticipants.get(addrFrom);
        if (create && part == null) {
            part = new Participant(addrFrom, isMe, resourceFrom, nameFrom, role, affiliation);
            this.mParticipants.put(addrFrom, part);
        } else if (part != null) {
            if (role != null) {
                part.setRole(role);
            }
            if (affiliation != null) {
                part.setAffiliation(affiliation);
            }
            if (nameFrom != null) {
                part.setName(nameFrom);
            }
        }
        return part;
    }

    private Participant removeParticipant(IMAddr addr) {
        Participant p = this.mParticipants.remove(addr);
        return p;
    }

    public Collection<Participant> participants() {
        return Collections.unmodifiableCollection(this.mParticipants.values());
    }

    public List<IMMessage> messages() {
        return Collections.unmodifiableList(this.mMessages);
    }

    private void addMessage(boolean notify, IMAddr from, String subject, IMMessage.TextPart bodyPart, boolean isTyping) {
        IMMessage immsg = new IMMessage(subject == null ? null : new IMMessage.TextPart(subject), bodyPart, isTyping);
        immsg.setFrom(from);
        this.addMessage(notify, immsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(boolean notify, IMMessage immsg) {
        int seqNoStart = this.getHighestSeqNo();
        try {
            this.mMessages.add(immsg);
            assert (this.getHighestSeqNo() > seqNoStart);
            int seqNo = this.mMessages.size() + this.mFirstSeqNo;
            if (notify) {
                IMMessageNotification notification = new IMMessageNotification(immsg.getFrom(), this.getThreadId(), immsg, seqNo);
                this.mPersona.postIMNotification(notification);
            }
            Object var7_6 = null;
            if (this.getHighestSeqNo() > seqNoStart) {
                this.enableTimer(TIMER_STATE.WAITING_TO_SAVE);
            } else {
                this.enableTimer(TIMER_STATE.WAITING_TO_CLOSE);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.getHighestSeqNo() > seqNoStart) {
                this.enableTimer(TIMER_STATE.WAITING_TO_SAVE);
            } else {
                this.enableTimer(TIMER_STATE.WAITING_TO_CLOSE);
            }
            throw throwable;
        }
    }

    private void enableTimer(TIMER_STATE requestedState) {
        ZimbraLog.im.debug("Chat + " + this.getThreadId() + " setting timer to " + (Object)((Object)requestedState));
        block0 : switch (requestedState) {
            case WAITING_TO_CLOSE: {
                switch (this.mTimerState) {
                    case WAITING_TO_CLOSE: {
                        break;
                    }
                    case WAITING_TO_SAVE: {
                        break;
                    }
                    case NONE: {
                        this.startCloseTimer();
                    }
                }
                break;
            }
            case WAITING_TO_SAVE: {
                switch (this.mTimerState) {
                    case WAITING_TO_CLOSE: {
                        this.startSaveTimer();
                        break;
                    }
                    case WAITING_TO_SAVE: {
                        break;
                    }
                    case NONE: {
                        this.startSaveTimer();
                    }
                }
                break;
            }
            case NONE: {
                switch (this.mTimerState) {
                    case WAITING_TO_CLOSE: 
                    case WAITING_TO_SAVE: {
                        if (this.mTimer != null) {
                            this.mTimer.cancel();
                            this.mTimer = null;
                        }
                        this.mTimerState = TIMER_STATE.NONE;
                        break block0;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timerExecute() {
        Object object = this.mPersona.getLock();
        synchronized (object) {
            ZimbraLog.im.debug("ImChat.TimerExecute " + (Object)((Object)this.mTimerState));
            this.mTimer = null;
            switch (this.mTimerState) {
                case WAITING_TO_CLOSE: {
                    this.mPersona.closeChat(null, this);
                    break;
                }
                case WAITING_TO_SAVE: {
                    this.startCloseTimer();
                    this.flush();
                    break;
                }
            }
        }
    }

    private void startSaveTimer() {
        this.mTimerState = TIMER_STATE.WAITING_TO_SAVE;
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new FlushTask();
        Zimbra.sTimer.schedule((TimerTask)this.mTimer, this.getSaveTimeout());
    }

    private void startCloseTimer() {
        this.mTimerState = TIMER_STATE.WAITING_TO_CLOSE;
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new FlushTask();
        Zimbra.sTimer.schedule((TimerTask)this.mTimer, this.getCloseTimeout());
    }

    private void flush() {
        block8: {
            assert (Thread.holdsLock(this.mPersona.getLock()));
            if (this.mLastFlushSeqNo >= this.getHighestSeqNo()) {
                return;
            }
            try {
                com.zimbra.cs.mailbox.Message msg;
                Mailbox mbox = this.mPersona.getMailbox();
                Account acct = mbox.getAccount();
                if (!acct.getBooleanAttr("zimbraPrefIMLogChats", true)) break block8;
                ZimbraLog.im.debug("Flushing chat: " + this.toString());
                ParsedMessage pm = ChatWriter.writeChat(this);
                try {
                    msg = mbox.updateOrCreateChat(null, pm, this.mSavedChatId);
                }
                catch (MailServiceException.NoSuchItemException e) {
                    msg = mbox.updateOrCreateChat(null, pm, -1);
                }
                this.mSavedChatId = msg.getId();
            }
            catch (ServiceException e) {
                System.out.println("Caught ServiceException " + e);
                e.printStackTrace();
            }
            catch (IOException e) {
                System.out.println("Caught IO exception " + e);
                e.printStackTrace();
            }
            catch (MessagingException e) {
                System.out.println("Caught messaging exception " + (Object)((Object)e));
                e.printStackTrace();
            }
        }
        this.mLastFlushSeqNo = this.getHighestSeqNo();
    }

    private class FlushTask
    extends TimerTask {
        private FlushTask() {
        }

        public void run() {
            try {
                IMChat.this.timerExecute();
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    Zimbra.halt("Caught out of memory error", e);
                }
                ZimbraLog.im.warn((Object)"Caught exception in IMChat timer", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MucStatusCode {
        EnteringRoomJIDAvailable(100),
        AffiliationChange(101),
        ShowsUnavailableMembers(102),
        DoesNotShowUnavailableMembers(103),
        ConfigurationChange(104),
        OccupantPresence(110),
        LoggingEnabled(170),
        LoggingDisabled(171),
        NonAnonymous(172),
        SemiAnonymous(173),
        FullyAnonymous(174),
        NewRoomCreated(201),
        RoomnickChanged(210),
        YouHaveBeenBanned(301),
        NewRoomNickname(303),
        KickedFromRoom(307),
        RemovedForAffiliationChange(321),
        RemovedForMembersOnly(322),
        RemovedShutdown(332),
        PasswordRequired(401),
        Banned(403),
        NoSuchRoom(404),
        NotAllowed(405),
        MustUseReservedRoomnick(406),
        NotAMember(407),
        NicknameConflict(409),
        MaxUsers(503),
        Unknown(0);

        private static final Map<Integer, MucStatusCode> sIntToCodeMap;
        private int mCode;

        public static MucStatusCode lookup(int value) {
            MucStatusCode toRet = sIntToCodeMap.get(value);
            if (toRet == null) {
                return Unknown;
            }
            return toRet;
        }

        private MucStatusCode(int code) {
            this.mCode = code;
        }

        public boolean isError() {
            return this.mCode >= 400;
        }

        static {
            sIntToCodeMap = new HashMap<Integer, MucStatusCode>();
            for (MucStatusCode code : MucStatusCode.values()) {
                sIntToCodeMap.put(code.mCode, code);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TIMER_STATE {
        WAITING_TO_CLOSE,
        WAITING_TO_SAVE,
        NONE;

    }

    public static class Participant {
        private IMAddr mAddress;
        private String mName;
        private String mResource;
        private MUCRole.Affiliation mAffiliation = null;
        private MUCRole.Role mRole = null;
        private boolean mIsMe = false;

        private void init(IMAddr address, boolean isMe, String resource, String name, MUCRole.Role role, MUCRole.Affiliation affiliation) {
            this.mAddress = address;
            this.mIsMe = isMe;
            this.mName = name;
            this.mResource = resource;
            this.mRole = role;
            this.mAffiliation = affiliation;
        }

        public IMAddr getAddress() {
            return this.mAddress;
        }

        public String getName() {
            return this.mName;
        }

        public String mResource() {
            return this.mResource;
        }

        public MUCRole.Affiliation getAffiliation() {
            return this.mAffiliation;
        }

        public MUCRole.Role getRole() {
            return this.mRole;
        }

        public void setAffiliation(MUCRole.Affiliation aff) {
            this.mAffiliation = aff;
        }

        public void setRole(MUCRole.Role r) {
            this.mRole = r;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public Participant(IMAddr address, boolean isMe) {
            this.init(address, isMe, null, null, null, null);
        }

        public Participant(IMAddr address, boolean isMe, String resource, String name, MUCRole.Role role, MUCRole.Affiliation affiliation) {
            this.init(address, isMe, resource, name, role, affiliation);
        }

        public com.zimbra.common.soap.Element toXML(com.zimbra.common.soap.Element e) {
            com.zimbra.common.soap.Element pe = e.addElement("p");
            pe.addAttribute("addr", this.getAddress().getAddr());
            if (this.mIsMe) {
                pe.addAttribute("me", true);
            }
            if (this.mName != null) {
                pe.addAttribute("fulladdr", this.mName);
            }
            if (this.getRole() != null) {
                pe.addAttribute("role", this.getRole().name());
            }
            if (this.getAffiliation() != null) {
                pe.addAttribute("affiliation", this.getAffiliation().name());
            }
            return pe;
        }
    }
}

