/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMChat;
import com.zimbra.cs.im.IMGroup;
import com.zimbra.cs.im.IMPresence;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xmpp.packet.Roster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMBuddy {
    private IMAddr mAddress;
    private String mName;
    private IMPresence mPresence;
    private SubType mSubType;
    private Roster.Ask mAsk;
    private Map<String, IMChat> mChats = new HashMap<String, IMChat>();
    private List<IMGroup> mGroups = new LinkedList<IMGroup>();

    IMBuddy(IMAddr address, String name) {
        this.mAddress = address;
        this.mName = name;
        this.mPresence = null;
        this.mSubType = SubType.UNSET;
    }

    public String toString() {
        return "BUDDY: " + this.mAddress + "(" + this.mName + ") [" + this.mPresence == null ? "null" : this.mPresence.toString() + "]";
    }

    void setAsk(Roster.Ask ask) {
        this.mAsk = ask;
    }

    void setName(String name) {
        this.mName = name;
    }

    void setSubType(SubType st) {
        this.mSubType = st;
    }

    void clearGroups() {
        this.mGroups.clear();
    }

    void removeGroup(IMGroup group) {
        this.mGroups.remove(group);
    }

    void addGroup(IMGroup group) {
        if (!this.mGroups.contains(group)) {
            this.mGroups.add(group);
        }
    }

    void setPresence(IMPresence presence) {
        this.mPresence = presence;
    }

    public void addChat(String threadId, IMChat chat) {
        this.mChats.put(threadId, chat);
    }

    public Map<String, IMChat> chats() {
        return Collections.unmodifiableMap(this.mChats);
    }

    public List<IMGroup> groups() {
        return Collections.unmodifiableList(this.mGroups);
    }

    public int numGroups() {
        return this.mGroups.size();
    }

    public IMAddr getAddress() {
        return this.mAddress;
    }

    public String getName() {
        return this.mName;
    }

    public IMPresence getPresence() {
        return this.mPresence;
    }

    public Roster.Subscription getSubscription() {
        switch (this.mSubType) {
            case UNSET: {
                return Roster.Subscription.none;
            }
            case TO: {
                return Roster.Subscription.to;
            }
            case FROM: {
                return Roster.Subscription.from;
            }
            case BOTH: {
                return Roster.Subscription.both;
            }
            case NONE: {
                return Roster.Subscription.none;
            }
        }
        return null;
    }

    public SubType getSubType() {
        return this.mSubType;
    }

    public Roster.Ask getAsk() {
        return this.mAsk;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SubType
    extends Enum<SubType> {
        public static final /* enum */ SubType TO = new SubType();
        public static final /* enum */ SubType FROM = new SubType();
        public static final /* enum */ SubType BOTH = new SubType();
        public static final /* enum */ SubType NONE = new SubType();
        public static final /* enum */ SubType UNSET = new SubType();
        private static final /* synthetic */ SubType[] $VALUES;

        public static final SubType[] values() {
            return (SubType[])$VALUES.clone();
        }

        public static SubType valueOf(String name) {
            return Enum.valueOf(SubType.class, name);
        }

        boolean isOutgoing() {
            return this == TO || this == BOTH;
        }

        boolean isIncoming() {
            return this == FROM || this == BOTH;
        }

        SubType setOutgoing() {
            switch (this) {
                case UNSET: 
                case NONE: 
                case TO: {
                    return TO;
                }
                case FROM: 
                case BOTH: {
                    return BOTH;
                }
            }
            assert (false);
            return null;
        }

        SubType setIncoming() {
            switch (this) {
                case UNSET: 
                case NONE: 
                case FROM: {
                    return FROM;
                }
                case TO: 
                case BOTH: {
                    return BOTH;
                }
            }
            assert (false);
            return null;
        }

        SubType clearOutgoing() {
            switch (this) {
                case FROM: 
                case BOTH: {
                    return FROM;
                }
                case NONE: 
                case TO: {
                    return NONE;
                }
                case UNSET: {
                    return UNSET;
                }
            }
            assert (false);
            return null;
        }

        SubType clearIncoming() {
            switch (this) {
                case NONE: 
                case FROM: {
                    return NONE;
                }
                case TO: 
                case BOTH: {
                    return TO;
                }
                case UNSET: {
                    return UNSET;
                }
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new SubType[]{TO, FROM, BOTH, NONE, UNSET};
        }
    }
}

