/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.im.IMNotification;

public class IMBaseMessageNotification
extends IMNotification {
    private String mFromAddr;
    private String mThreadId;
    private long mTimestamp;
    private boolean mTyping;

    public IMBaseMessageNotification(String fromAddr, String threadId, boolean typing, long timestamp) {
        this.mFromAddr = fromAddr;
        this.mThreadId = threadId;
        this.mTyping = typing;
        this.mTimestamp = timestamp;
    }

    public Element toXml(Element parent) throws ServiceException {
        Element e = IMBaseMessageNotification.create(parent, "message");
        e.addAttribute("from", this.mFromAddr);
        e.addAttribute("thread", this.mThreadId);
        if (this.mTyping) {
            e.addElement("typing");
        }
        e.addAttribute("ts", this.mTimestamp);
        return e;
    }

    public final String getFromAddr() {
        return this.mFromAddr;
    }

    public final String getThreadId() {
        return this.mThreadId;
    }

    public final boolean isTyping() {
        return this.mTyping;
    }

    public final long getTimestamp() {
        return this.mTimestamp;
    }
}

