/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import org.xmpp.packet.JID;

public class IMAddr {
    private String mAddr;

    public IMAddr(String addr) {
        assert (addr != null);
        assert (addr.indexOf(47) < 0);
        this.mAddr = addr;
    }

    public IMAddr(JID jid) {
        this.mAddr = jid.toBareJID();
    }

    public String getNode() {
        return this.makeJID().getNode();
    }

    public String getAddr() {
        return this.mAddr;
    }

    public String toString() {
        return this.mAddr;
    }

    public String getDomain() {
        return this.makeJID().getDomain();
    }

    public JID makeJID() {
        int domainSplit = this.mAddr.indexOf(64);
        if (domainSplit > 0) {
            String namePart = this.mAddr.substring(0, domainSplit);
            String domainPart = this.mAddr.substring(domainSplit + 1);
            return new JID(namePart, domainPart, "");
        }
        return new JID(this.mAddr);
    }

    public JID makeFullJID(String resource) {
        int domainSplit = this.mAddr.indexOf(64);
        if (domainSplit > 0) {
            String namePart = this.mAddr.substring(0, domainSplit);
            String domainPart = this.mAddr.substring(domainSplit + 1);
            return new JID(namePart, domainPart, resource);
        }
        return new JID(this.mAddr);
    }

    public static IMAddr fromJID(JID jid) {
        return new IMAddr(jid.toBareJID());
    }

    public boolean equals(Object other) {
        return ((IMAddr)other).mAddr.equals(this.mAddr);
    }

    public int hashCode() {
        return this.mAddr.hashCode();
    }
}

