/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.html.HtmlDefang;
import com.zimbra.cs.html.HtmlEntityMapper;
import com.zimbra.cs.im.IMChat;
import com.zimbra.cs.im.IMMessage;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.im.IMGetChat;
import com.zimbra.cs.util.JMSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

class ChatWriter {
    private static final String[] sColors = new String[]{"#0000FF", "#FF0000", "#00FF00", "#FF00FF"};
    private static final String TAB_STR = "&nbsp;&nbsp;&nbsp;&nbsp;";

    ChatWriter() {
    }

    static ParsedMessage writeChat(IMChat chat) throws MessagingException, ServiceException {
        MimeMessage mm = new MimeMessage(JMSession.getSession());
        MimeMultipart mmp = new MimeMultipart("alternative");
        mm.setContent((Multipart)mmp);
        StringBuilder subject = new StringBuilder();
        StringBuilder plainText = new StringBuilder();
        ArrayList<InternetAddress> addrs = new ArrayList<InternetAddress>();
        SimpleDateFormat df = new SimpleDateFormat("h:mm a");
        Date highestDate = new Date(0L);
        StringBuilder html = new StringBuilder("<html>");
        Integer colorOff = 0;
        HashMap<String, String> colorMap = new HashMap<String, String>();
        for (IMMessage msg : chat.messages()) {
            String msgBody;
            InternetAddress ia = new InternetAddress(msg.getFrom().getAddr());
            if (!addrs.contains(ia)) {
                addrs.add(ia);
            }
            String from = msg.getFrom() != null ? msg.getFrom().toString() : "";
            String string = msgBody = msg.getBody() != null ? msg.getBody().getPlainText() : "";
            if (msgBody.length() > 0 && msgBody.charAt(msgBody.length() - 1) == '\n') {
                msgBody = msgBody.substring(0, msgBody.length() - 1);
            }
            if (subject.length() < 40) {
                subject.append(msgBody).append("   ");
            }
            plainText.append(new Formatter().format("%s[%s]: %s\n", from, df.format(msg.getDate()), msgBody));
            if (msg.getDate().after(highestDate)) {
                highestDate = msg.getDate();
            }
            String msgBodyHtml = "";
            IMMessage.TextPart body = msg.getBody();
            if (body != null) {
                msgBodyHtml = body.hasXHTML() ? body.getXHTMLAsString() : StringUtil.escapeHtml(body.getPlainText());
            }
            msgBodyHtml = HtmlEntityMapper.unicodeToHtmlEntity(msgBodyHtml);
            try {
                msgBodyHtml = HtmlDefang.defang(msgBodyHtml, true);
            }
            catch (IOException ex) {
                ZimbraLog.im.warn("Unable to htmldefang text: " + msgBodyHtml);
                msgBodyHtml = "defang_error";
            }
            if (!colorMap.containsKey(from)) {
                if (colorOff == -1) {
                    colorMap.put(from, "#000000");
                } else {
                    Integer ex = colorOff;
                    Integer n = colorOff = Integer.valueOf(colorOff + 1);
                    colorMap.put(from, sColors[ex]);
                }
                if (colorOff >= sColors.length) {
                    colorOff = -1;
                }
            }
            String colorId = (String)colorMap.get(from);
            html.append(new Formatter().format("<font color=\"%s\"><b>%s</b><i>[%s]</i>: %s</font><br>\n", colorId, msg.getFrom().toString(), df.format(msg.getDate()), msgBodyHtml));
        }
        html.append("</html>");
        int subjLen = Math.min(40, subject.length());
        mm.setSubject(subject.substring(0, subjLen), "utf-8");
        Address[] addrArray = new Address[addrs.size()];
        addrs.toArray(addrArray);
        mm.addFrom(addrArray);
        mm.setSentDate(highestDate);
        MimeBodyPart textPart = new MimeBodyPart();
        mmp.addBodyPart((BodyPart)textPart);
        textPart.setText(plainText.toString(), "utf-8");
        MimeBodyPart htmlPart = new MimeBodyPart();
        htmlPart.setDataHandler(new DataHandler(new HtmlPartDataSource(html.toString())));
        mmp.addBodyPart((BodyPart)htmlPart);
        Element.XMLElement root = new Element.XMLElement("im");
        IMGetChat.chatToXml(chat, root);
        MimeBodyPart xmlPart = new MimeBodyPart();
        mmp.addBodyPart((BodyPart)xmlPart);
        xmlPart.setDataHandler(new DataHandler(new ImXmlPartDataSource(root)));
        mm.saveChanges();
        ParsedMessage pm = new ParsedMessage(mm, true);
        return pm;
    }

    private static class HtmlPartDataSource
    implements DataSource {
        private String mText;
        private byte[] mBuf = null;

        HtmlPartDataSource(String text) {
            this.mText = text;
        }

        public String getContentType() {
            return "text/html; charset=utf-8";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws IOException {
            HtmlPartDataSource htmlPartDataSource = this;
            synchronized (htmlPartDataSource) {
                if (this.mBuf == null) {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    OutputStreamWriter wout = new OutputStreamWriter((OutputStream)buf, "utf-8");
                    String text = this.mText;
                    wout.write(text);
                    wout.flush();
                    this.mBuf = buf.toByteArray();
                }
            }
            ByteArrayInputStream in = new ByteArrayInputStream(this.mBuf);
            return in;
        }

        public String getName() {
            return "HtmlPartDataSource";
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ImXmlPartDataSource
    implements DataSource {
        private Element mElt;
        private byte[] mBuf = null;

        ImXmlPartDataSource(Element elt) {
            this.mElt = elt;
        }

        public String getContentType() {
            return "application/zimbra-im-xml";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws IOException {
            ImXmlPartDataSource imXmlPartDataSource = this;
            synchronized (imXmlPartDataSource) {
                if (this.mBuf == null) {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    OutputStreamWriter wout = new OutputStreamWriter((OutputStream)buf, "utf-8");
                    String text = this.mElt.toXML().asXML();
                    text = HtmlEntityMapper.unicodeToHtmlEntity(text);
                    wout.write(text);
                    wout.flush();
                    this.mBuf = buf.toByteArray();
                }
            }
            ByteArrayInputStream in = new ByteArrayInputStream(this.mBuf);
            return in;
        }

        public String getName() {
            return "ImXmlPartDataSource";
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }
    }
}

