/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.httpclient;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class URLUtil {
    private static Log mLog = LogFactory.getLog(URLUtil.class);
    private static final String PROTO_HTTP = "http";
    private static final String PROTO_HTTPS = "https";
    private static int DEFAULT_HTTP_PORT = 80;
    private static int DEFAULT_HTTPS_PORT = 443;
    private static final Map<Character, String> sUrlEscapeMap = new HashMap<Character, String>();

    public static String getSoapURL(Server server, boolean preferSSL) throws ServiceException {
        return URLUtil.getServiceURL(server, "/service/soap/", preferSSL);
    }

    public static String getSoapPublicURL(Server server, Domain domain, boolean preferSSL) throws ServiceException {
        return URLUtil.getPublicURLForDomain(server, domain, "/service/soap/", preferSSL);
    }

    public static String getAdminURL(Server server, String path) {
        String hostname = server.getAttr("zimbraServiceHostname");
        int port = server.getIntAttr("zimbraAdminPort", 0);
        StringBuffer sb = new StringBuffer(128);
        sb.append(LC.zimbra_admin_service_scheme.value()).append(hostname).append(":").append(port).append(path);
        return sb.toString();
    }

    public static String getAdminURL(Server server, String path, boolean checkPort) throws ServiceException {
        String hostname = server.getAttr("zimbraServiceHostname");
        int port = server.getIntAttr("zimbraAdminPort", 0);
        if (checkPort && port <= 0) {
            throw ServiceException.FAILURE("server " + server.getName() + " does not have admin port enabled", null);
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(LC.zimbra_admin_service_scheme.value()).append(hostname).append(":").append(port).append(path);
        return sb.toString();
    }

    public static String getAdminURL(String hostname) {
        int port = (int)LC.zimbra_admin_service_port.longValue();
        StringBuffer sb = new StringBuffer(128);
        sb.append(LC.zimbra_admin_service_scheme.value()).append(hostname).append(":").append(port).append("/service/admin/soap/");
        return sb.toString();
    }

    public static String getAdminURL(Server server) {
        return URLUtil.getAdminURL(server, "/service/admin/soap/");
    }

    public static String getMtaAuthURL(String authHost) throws ServiceException {
        for (Server server : Provisioning.getInstance().getAllServers()) {
            String serviceName = server.getAttr("zimbraServiceHostname", null);
            if (!authHost.equalsIgnoreCase(serviceName)) continue;
            return URLUtil.getSoapURL(server, true);
        }
        throw ServiceException.INVALID_REQUEST("specified zimbraMtaAuthHost does not correspond to a valid service hostname: " + authHost, null);
    }

    public static String getPublicURLForDomain(Server server, Domain domain, String path, boolean preferSSL) throws ServiceException {
        String publicURLForDomain = URLUtil.getPublicURLForDomain(domain, path);
        if (publicURLForDomain != null) {
            return publicURLForDomain;
        }
        return URLUtil.getServiceURL(server, path, preferSSL);
    }

    private static String getPublicURLForDomain(Domain domain, String path) {
        if (domain == null) {
            return null;
        }
        String hostname = domain.getAttr("zimbraPublicServiceHostname", null);
        if (hostname == null) {
            return null;
        }
        String proto = domain.getAttr("zimbraPublicServiceProtocol", PROTO_HTTP);
        int defaultPort = PROTO_HTTP.equals(proto) ? DEFAULT_HTTP_PORT : DEFAULT_HTTPS_PORT;
        int port = domain.getIntAttr("zimbraPublicServicePort", defaultPort);
        boolean printPort = PROTO_HTTP.equals(proto) && port != DEFAULT_HTTP_PORT || PROTO_HTTPS.equals(proto) && port != DEFAULT_HTTPS_PORT;
        StringBuilder buf = new StringBuilder();
        buf.append(proto).append("://").append(hostname);
        if (printPort) {
            buf.append(":").append(port);
        }
        buf.append(path);
        return buf.toString();
    }

    public static String getServiceURL(Server server, String path, boolean useSSL) throws ServiceException {
        int port;
        String proto;
        String hostname = server.getAttr("zimbraServiceHostname");
        if (hostname == null) {
            throw ServiceException.INVALID_REQUEST("server " + server.getName() + " does not have " + "zimbraServiceHostname", null);
        }
        String modeString = server.getAttr("zimbraMailMode", null);
        if (modeString == null) {
            throw ServiceException.INVALID_REQUEST("server " + server.getName() + " does not have " + "zimbraMailMode" + " set, maybe it is not a store server?", null);
        }
        Provisioning.MailMode mailMode = Provisioning.MailMode.fromString(modeString);
        if (mailMode != Provisioning.MailMode.http && useSSL || mailMode == Provisioning.MailMode.https) {
            proto = PROTO_HTTPS;
            port = server.getIntAttr("zimbraMailSSLPort", DEFAULT_HTTPS_PORT);
        } else {
            proto = PROTO_HTTP;
            port = server.getIntAttr("zimbraMailPort", DEFAULT_HTTP_PORT);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(proto).append("://").append(hostname);
        buf.append(":").append(port);
        buf.append(path);
        return buf.toString();
    }

    public static boolean reverseProxiedMode(Server server) throws ServiceException {
        String referMode = server.getAttr("zimbraMailReferMode", "wronghost");
        return "reverse-proxied".equals(referMode);
    }

    public static String urlEscape(String str) {
        StringBuilder buf = null;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            String escaped = null;
            if (c < '\u007f') {
                escaped = sUrlEscapeMap.get(Character.valueOf(c));
            }
            if (escaped != null || c >= '\u007f') {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(str.substring(0, i));
                }
                if (escaped != null) {
                    buf.append(escaped);
                    continue;
                }
                try {
                    byte[] raw;
                    for (byte b : raw = Character.valueOf(c).toString().getBytes("UTF-8")) {
                        int unsignedB = b & 0xFF;
                        buf.append("%").append(Integer.toHexString(unsignedB).toUpperCase());
                    }
                    continue;
                }
                catch (IOException e) {
                    mLog.info((Object)("can't decode character " + c), e);
                    buf.append(c);
                    continue;
                }
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            return buf.toString();
        }
        return str;
    }

    static {
        sUrlEscapeMap.put(Character.valueOf(' '), "%20");
        sUrlEscapeMap.put(Character.valueOf('\"'), "%22");
        sUrlEscapeMap.put(Character.valueOf('#'), "%23");
        sUrlEscapeMap.put(Character.valueOf('%'), "%25");
        sUrlEscapeMap.put(Character.valueOf('&'), "%26");
        sUrlEscapeMap.put(Character.valueOf('?'), "%3F");
        sUrlEscapeMap.put(Character.valueOf('['), "%5B");
        sUrlEscapeMap.put(Character.valueOf('\\'), "%5C");
        sUrlEscapeMap.put(Character.valueOf(']'), "%5D");
        sUrlEscapeMap.put(Character.valueOf('^'), "%5E");
        sUrlEscapeMap.put(Character.valueOf('`'), "%60");
        sUrlEscapeMap.put(Character.valueOf('{'), "%7B");
        sUrlEscapeMap.put(Character.valueOf('|'), "%7C");
        sUrlEscapeMap.put(Character.valueOf('}'), "%7D");
    }
}

