/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.httpclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class HttpProxyUtil {
    private static String sProxyUrl = null;
    private static URI sProxyUri = null;
    private static AuthScope sProxyAuthScope = null;
    private static UsernamePasswordCredentials sProxyCreds = null;

    public static synchronized void configureProxy(HttpClient client) {
        try {
            String url = Provisioning.getInstance().getLocalServer().getAttr("zimbraHttpProxyURL", null);
            if (url == null) {
                return;
            }
            if (sProxyUrl == null || !sProxyUrl.equals(url)) {
                int i;
                sProxyUrl = url;
                sProxyUri = new URI(url);
                sProxyAuthScope = null;
                sProxyCreds = null;
                String userInfo = sProxyUri.getUserInfo();
                if (userInfo != null && (i = userInfo.indexOf(58)) != -1) {
                    sProxyAuthScope = new AuthScope(sProxyUri.getHost(), sProxyUri.getPort(), null);
                    sProxyCreds = new UsernamePasswordCredentials(userInfo.substring(0, i), userInfo.substring(i + 1));
                }
            }
            if (ZimbraLog.misc.isDebugEnabled()) {
                ZimbraLog.misc.debug("setting proxy: " + url);
            }
            client.getHostConfiguration().setProxy(sProxyUri.getHost(), sProxyUri.getPort());
            if (sProxyAuthScope != null && sProxyCreds != null) {
                client.getState().setProxyCredentials(sProxyAuthScope, sProxyCreds);
            }
        }
        catch (ServiceException e) {
            ZimbraLog.misc.warn((Object)("Unable to configureProxy: " + e.getMessage()), e);
        }
        catch (URISyntaxException e) {
            ZimbraLog.misc.warn((Object)("Unable to configureProxy: " + e.getMessage()), e);
        }
    }
}

