/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.html;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HtmlEntityMapper {
    private static final Map<String, Integer> sHtmlEntityToUnicodeMap = new HashMap<String, Integer>();
    private static final Map<Integer, String> sUnicodeToHtmlEntityMap = new HashMap<Integer, String>();
    private static final Pattern htmlEntityPat = Pattern.compile("&([A-Za-z0-9]{2,6});");
    private static final Pattern numEntityPat = Pattern.compile("&#([0-9]{1,5});");

    public static String htmlEntitiesToNumeric(String s) {
        String prefix = "&#";
        Pattern regex = htmlEntityPat;
        Map<String, Integer> map = sHtmlEntityToUnicodeMap;
        StringBuilder toRet = new StringBuilder();
        int curIdx = 0;
        Matcher m = regex.matcher(s);
        while (curIdx < s.length()) {
            if (m.find(curIdx)) {
                toRet.append(s.substring(curIdx, m.start()));
                String id = m.group(1);
                if (map.containsKey(id)) {
                    toRet.append(prefix).append(map.get(id)).append(";");
                } else {
                    toRet.append(m.group(0));
                }
                curIdx = m.end();
                continue;
            }
            toRet.append(s.substring(curIdx));
            curIdx = s.length();
        }
        return toRet.toString();
    }

    public static String numericEntitiesToHtml(String s) {
        String prefix = "&";
        Pattern regex = numEntityPat;
        Map<Integer, String> map = sUnicodeToHtmlEntityMap;
        StringBuilder toRet = new StringBuilder();
        int curIdx = 0;
        Matcher m = regex.matcher(s);
        while (curIdx < s.length()) {
            if (m.find(curIdx)) {
                toRet.append(s.substring(curIdx, m.start()));
                boolean ok = false;
                try {
                    Integer id = Integer.parseInt(m.group(1));
                    if (map.containsKey(id)) {
                        toRet.append(prefix).append(map.get(id)).append(";");
                        ok = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (!ok) {
                    toRet.append(m.group(0));
                }
                curIdx = m.end();
                continue;
            }
            toRet.append(s.substring(curIdx));
            curIdx = s.length();
        }
        return toRet.toString();
    }

    public static String unicodeToHtmlEntity(String s) {
        StringBuilder toRet = new StringBuilder();
        for (char c : s.toCharArray()) {
            String rep = sUnicodeToHtmlEntityMap.get(c);
            if (rep != null) {
                toRet.append("&").append(rep).append(";");
                continue;
            }
            toRet.append(c);
        }
        return toRet.toString();
    }

    private static void test(String test1) {
        System.out.println(test1);
        String result = HtmlEntityMapper.htmlEntitiesToNumeric(test1);
        System.out.println(result);
        String result2 = HtmlEntityMapper.numericEntitiesToHtml(result);
        System.out.println(result2);
        if (!result2.equals(test1)) {
            System.out.println("Final result NOT EQUAL to initial!\n");
        } else {
            System.out.println("OK!\n");
        }
    }

    private static void addToMap(String s, Integer code) {
        sHtmlEntityToUnicodeMap.put(s, code);
        sUnicodeToHtmlEntityMap.put(code, s);
    }

    public static void main(String[] argv) {
        HtmlEntityMapper.test("abc&nbsp;def&nbsp;&nbsp;ghi&nbsp;&foo;&#1234;zug");
        HtmlEntityMapper.test("abc&nbsp;def&#z231;&#9999999999;&#99999;&1321asdd;&nbsp;&nbsp;ghi&nbsp;&foo;&le;&sube;&#1234;zug&or;");
    }

    static {
        HtmlEntityMapper.addToMap("OElig", 338);
        HtmlEntityMapper.addToMap("oelig", 339);
        HtmlEntityMapper.addToMap("Scaron", 352);
        HtmlEntityMapper.addToMap("scaron", 353);
        HtmlEntityMapper.addToMap("Yuml", 376);
        HtmlEntityMapper.addToMap("circ", 710);
        HtmlEntityMapper.addToMap("tilde", 732);
        HtmlEntityMapper.addToMap("ensp", 8194);
        HtmlEntityMapper.addToMap("emsp", 8195);
        HtmlEntityMapper.addToMap("thinsp", 8201);
        HtmlEntityMapper.addToMap("zwnj", 8204);
        HtmlEntityMapper.addToMap("zwj", 8205);
        HtmlEntityMapper.addToMap("lrm", 8206);
        HtmlEntityMapper.addToMap("rlm", 8207);
        HtmlEntityMapper.addToMap("ndash", 8211);
        HtmlEntityMapper.addToMap("mdash", 8212);
        HtmlEntityMapper.addToMap("lsquo", 8216);
        HtmlEntityMapper.addToMap("rsquo", 8217);
        HtmlEntityMapper.addToMap("sbquo", 8218);
        HtmlEntityMapper.addToMap("ldquo", 8220);
        HtmlEntityMapper.addToMap("rdquo", 8221);
        HtmlEntityMapper.addToMap("bdquo", 8222);
        HtmlEntityMapper.addToMap("dagger", 8224);
        HtmlEntityMapper.addToMap("Dagger", 8225);
        HtmlEntityMapper.addToMap("permil", 8240);
        HtmlEntityMapper.addToMap("lsaquo", 8249);
        HtmlEntityMapper.addToMap("rsaquo", 8250);
        HtmlEntityMapper.addToMap("euro", 8364);
        HtmlEntityMapper.addToMap("nbsp", 160);
        HtmlEntityMapper.addToMap("iexcl", 161);
        HtmlEntityMapper.addToMap("cent", 162);
        HtmlEntityMapper.addToMap("pound", 163);
        HtmlEntityMapper.addToMap("curren", 164);
        HtmlEntityMapper.addToMap("yen", 165);
        HtmlEntityMapper.addToMap("brvbar", 166);
        HtmlEntityMapper.addToMap("sect", 167);
        HtmlEntityMapper.addToMap("uml", 168);
        HtmlEntityMapper.addToMap("copy", 169);
        HtmlEntityMapper.addToMap("ordf", 170);
        HtmlEntityMapper.addToMap("laquo", 171);
        HtmlEntityMapper.addToMap("not", 172);
        HtmlEntityMapper.addToMap("shy", 173);
        HtmlEntityMapper.addToMap("reg", 174);
        HtmlEntityMapper.addToMap("macr", 175);
        HtmlEntityMapper.addToMap("deg", 176);
        HtmlEntityMapper.addToMap("plusmn", 177);
        HtmlEntityMapper.addToMap("sup2", 178);
        HtmlEntityMapper.addToMap("sup3", 179);
        HtmlEntityMapper.addToMap("acute", 180);
        HtmlEntityMapper.addToMap("micro", 181);
        HtmlEntityMapper.addToMap("para", 182);
        HtmlEntityMapper.addToMap("middot", 183);
        HtmlEntityMapper.addToMap("cedil", 184);
        HtmlEntityMapper.addToMap("sup1", 185);
        HtmlEntityMapper.addToMap("ordm", 186);
        HtmlEntityMapper.addToMap("raquo", 187);
        HtmlEntityMapper.addToMap("frac14", 188);
        HtmlEntityMapper.addToMap("frac12", 189);
        HtmlEntityMapper.addToMap("frac34", 190);
        HtmlEntityMapper.addToMap("iquest", 191);
        HtmlEntityMapper.addToMap("Agrave", 192);
        HtmlEntityMapper.addToMap("Aacute", 193);
        HtmlEntityMapper.addToMap("Acirc", 194);
        HtmlEntityMapper.addToMap("Atilde", 195);
        HtmlEntityMapper.addToMap("Auml", 196);
        HtmlEntityMapper.addToMap("Aring", 197);
        HtmlEntityMapper.addToMap("AElig", 198);
        HtmlEntityMapper.addToMap("Ccedil", 199);
        HtmlEntityMapper.addToMap("Egrave", 200);
        HtmlEntityMapper.addToMap("Eacute", 201);
        HtmlEntityMapper.addToMap("Ecirc", 202);
        HtmlEntityMapper.addToMap("Euml", 203);
        HtmlEntityMapper.addToMap("Igrave", 204);
        HtmlEntityMapper.addToMap("Iacute", 205);
        HtmlEntityMapper.addToMap("Icirc", 206);
        HtmlEntityMapper.addToMap("Iuml", 207);
        HtmlEntityMapper.addToMap("ETH", 208);
        HtmlEntityMapper.addToMap("Ntilde", 209);
        HtmlEntityMapper.addToMap("Ograve", 210);
        HtmlEntityMapper.addToMap("Oacute", 211);
        HtmlEntityMapper.addToMap("Ocirc", 212);
        HtmlEntityMapper.addToMap("Otilde", 213);
        HtmlEntityMapper.addToMap("Ouml", 214);
        HtmlEntityMapper.addToMap("times", 215);
        HtmlEntityMapper.addToMap("Oslash", 216);
        HtmlEntityMapper.addToMap("Ugrave", 217);
        HtmlEntityMapper.addToMap("Uacute", 218);
        HtmlEntityMapper.addToMap("Ucirc", 219);
        HtmlEntityMapper.addToMap("Uuml", 220);
        HtmlEntityMapper.addToMap("Yacute", 221);
        HtmlEntityMapper.addToMap("THORN", 222);
        HtmlEntityMapper.addToMap("szlig", 223);
        HtmlEntityMapper.addToMap("agrave", 224);
        HtmlEntityMapper.addToMap("aacute", 225);
        HtmlEntityMapper.addToMap("acirc", 226);
        HtmlEntityMapper.addToMap("atilde", 227);
        HtmlEntityMapper.addToMap("auml", 228);
        HtmlEntityMapper.addToMap("aring", 229);
        HtmlEntityMapper.addToMap("aelig", 230);
        HtmlEntityMapper.addToMap("ccedil", 231);
        HtmlEntityMapper.addToMap("egrave", 232);
        HtmlEntityMapper.addToMap("eacute", 233);
        HtmlEntityMapper.addToMap("ecirc", 234);
        HtmlEntityMapper.addToMap("euml", 235);
        HtmlEntityMapper.addToMap("igrave", 236);
        HtmlEntityMapper.addToMap("iacute", 237);
        HtmlEntityMapper.addToMap("icirc", 238);
        HtmlEntityMapper.addToMap("iuml", 239);
        HtmlEntityMapper.addToMap("eth", 240);
        HtmlEntityMapper.addToMap("ntilde", 241);
        HtmlEntityMapper.addToMap("ograve", 242);
        HtmlEntityMapper.addToMap("oacute", 243);
        HtmlEntityMapper.addToMap("ocirc", 244);
        HtmlEntityMapper.addToMap("otilde", 245);
        HtmlEntityMapper.addToMap("ouml", 246);
        HtmlEntityMapper.addToMap("divide", 247);
        HtmlEntityMapper.addToMap("oslash", 248);
        HtmlEntityMapper.addToMap("ugrave", 249);
        HtmlEntityMapper.addToMap("uacute", 250);
        HtmlEntityMapper.addToMap("ucirc", 251);
        HtmlEntityMapper.addToMap("uuml", 252);
        HtmlEntityMapper.addToMap("yacute", 253);
        HtmlEntityMapper.addToMap("thorn", 254);
        HtmlEntityMapper.addToMap("yuml", 255);
        HtmlEntityMapper.addToMap("fnof", 402);
        HtmlEntityMapper.addToMap("Alpha", 913);
        HtmlEntityMapper.addToMap("Beta", 914);
        HtmlEntityMapper.addToMap("Gamma", 915);
        HtmlEntityMapper.addToMap("Delta", 916);
        HtmlEntityMapper.addToMap("Epsilon", 917);
        HtmlEntityMapper.addToMap("Zeta", 918);
        HtmlEntityMapper.addToMap("Eta", 919);
        HtmlEntityMapper.addToMap("Theta", 920);
        HtmlEntityMapper.addToMap("Iota", 921);
        HtmlEntityMapper.addToMap("Kappa", 922);
        HtmlEntityMapper.addToMap("Lambda", 923);
        HtmlEntityMapper.addToMap("Mu", 924);
        HtmlEntityMapper.addToMap("Nu", 925);
        HtmlEntityMapper.addToMap("Xi", 926);
        HtmlEntityMapper.addToMap("Omicron", 927);
        HtmlEntityMapper.addToMap("Pi", 928);
        HtmlEntityMapper.addToMap("Rho", 929);
        HtmlEntityMapper.addToMap("Sigma", 931);
        HtmlEntityMapper.addToMap("Tau", 932);
        HtmlEntityMapper.addToMap("Upsilon", 933);
        HtmlEntityMapper.addToMap("Phi", 934);
        HtmlEntityMapper.addToMap("Chi", 935);
        HtmlEntityMapper.addToMap("Psi", 936);
        HtmlEntityMapper.addToMap("Omega", 937);
        HtmlEntityMapper.addToMap("alpha", 945);
        HtmlEntityMapper.addToMap("beta", 946);
        HtmlEntityMapper.addToMap("gamma", 947);
        HtmlEntityMapper.addToMap("delta", 948);
        HtmlEntityMapper.addToMap("epsilon", 949);
        HtmlEntityMapper.addToMap("zeta", 950);
        HtmlEntityMapper.addToMap("eta", 951);
        HtmlEntityMapper.addToMap("theta", 952);
        HtmlEntityMapper.addToMap("iota", 953);
        HtmlEntityMapper.addToMap("kappa", 954);
        HtmlEntityMapper.addToMap("lambda", 955);
        HtmlEntityMapper.addToMap("mu", 956);
        HtmlEntityMapper.addToMap("nu", 957);
        HtmlEntityMapper.addToMap("xi", 958);
        HtmlEntityMapper.addToMap("omicron", 959);
        HtmlEntityMapper.addToMap("pi", 960);
        HtmlEntityMapper.addToMap("rho", 961);
        HtmlEntityMapper.addToMap("sigmaf", 962);
        HtmlEntityMapper.addToMap("sigma", 963);
        HtmlEntityMapper.addToMap("tau", 964);
        HtmlEntityMapper.addToMap("upsilon", 965);
        HtmlEntityMapper.addToMap("phi", 966);
        HtmlEntityMapper.addToMap("chi", 967);
        HtmlEntityMapper.addToMap("psi", 968);
        HtmlEntityMapper.addToMap("omega", 969);
        HtmlEntityMapper.addToMap("thetasym", 977);
        HtmlEntityMapper.addToMap("upsih", 978);
        HtmlEntityMapper.addToMap("piv", 982);
        HtmlEntityMapper.addToMap("bull", 8226);
        HtmlEntityMapper.addToMap("hellip", 8230);
        HtmlEntityMapper.addToMap("prime", 8242);
        HtmlEntityMapper.addToMap("Prime", 8243);
        HtmlEntityMapper.addToMap("oline", 8254);
        HtmlEntityMapper.addToMap("frasl", 8260);
        HtmlEntityMapper.addToMap("weierp", 8472);
        HtmlEntityMapper.addToMap("image", 8465);
        HtmlEntityMapper.addToMap("real", 8476);
        HtmlEntityMapper.addToMap("trade", 8482);
        HtmlEntityMapper.addToMap("alefsym", 8501);
        HtmlEntityMapper.addToMap("larr", 8592);
        HtmlEntityMapper.addToMap("uarr", 8593);
        HtmlEntityMapper.addToMap("rarr", 8594);
        HtmlEntityMapper.addToMap("darr", 8595);
        HtmlEntityMapper.addToMap("harr", 8596);
        HtmlEntityMapper.addToMap("crarr", 8629);
        HtmlEntityMapper.addToMap("lArr", 8656);
        HtmlEntityMapper.addToMap("uArr", 8657);
        HtmlEntityMapper.addToMap("rArr", 8658);
        HtmlEntityMapper.addToMap("dArr", 8659);
        HtmlEntityMapper.addToMap("hArr", 8660);
        HtmlEntityMapper.addToMap("forall", 8704);
        HtmlEntityMapper.addToMap("part", 8706);
        HtmlEntityMapper.addToMap("exist", 8707);
        HtmlEntityMapper.addToMap("empty", 8709);
        HtmlEntityMapper.addToMap("nabla", 8711);
        HtmlEntityMapper.addToMap("isin", 8712);
        HtmlEntityMapper.addToMap("notin", 8713);
        HtmlEntityMapper.addToMap("ni", 8715);
        HtmlEntityMapper.addToMap("prod", 8719);
        HtmlEntityMapper.addToMap("sum", 8721);
        HtmlEntityMapper.addToMap("minus", 8722);
        HtmlEntityMapper.addToMap("lowast", 8727);
        HtmlEntityMapper.addToMap("radic", 8730);
        HtmlEntityMapper.addToMap("prop", 8733);
        HtmlEntityMapper.addToMap("infin", 8734);
        HtmlEntityMapper.addToMap("ang", 8736);
        HtmlEntityMapper.addToMap("and", 8743);
        HtmlEntityMapper.addToMap("or", 8744);
        HtmlEntityMapper.addToMap("cap", 8745);
        HtmlEntityMapper.addToMap("cup", 8746);
        HtmlEntityMapper.addToMap("int", 8747);
        HtmlEntityMapper.addToMap("there4", 8756);
        HtmlEntityMapper.addToMap("sim", 8764);
        HtmlEntityMapper.addToMap("cong", 8773);
        HtmlEntityMapper.addToMap("asymp", 8776);
        HtmlEntityMapper.addToMap("ne", 8800);
        HtmlEntityMapper.addToMap("equiv", 8801);
        HtmlEntityMapper.addToMap("le", 8804);
        HtmlEntityMapper.addToMap("ge", 8805);
        HtmlEntityMapper.addToMap("sub", 8834);
        HtmlEntityMapper.addToMap("sup", 8835);
        HtmlEntityMapper.addToMap("nsub", 8836);
        HtmlEntityMapper.addToMap("sube", 8838);
        HtmlEntityMapper.addToMap("supe", 8839);
        HtmlEntityMapper.addToMap("oplus", 8853);
        HtmlEntityMapper.addToMap("otimes", 8855);
        HtmlEntityMapper.addToMap("perp", 8869);
        HtmlEntityMapper.addToMap("sdot", 8901);
        HtmlEntityMapper.addToMap("lceil", 8968);
        HtmlEntityMapper.addToMap("rceil", 8969);
        HtmlEntityMapper.addToMap("lfloor", 8970);
        HtmlEntityMapper.addToMap("rfloor", 8971);
        HtmlEntityMapper.addToMap("lang", 9001);
        HtmlEntityMapper.addToMap("rang", 9002);
        HtmlEntityMapper.addToMap("loz", 9674);
        HtmlEntityMapper.addToMap("spades", 9824);
        HtmlEntityMapper.addToMap("clubs", 9827);
        HtmlEntityMapper.addToMap("hearts", 9829);
        HtmlEntityMapper.addToMap("diams", 9830);
    }
}

