/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.html;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.html.DefangFilter;
import com.zimbra.cs.html.DefangWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;

public class HtmlDefang {
    public static String defang(String html, boolean neuterImages) throws IOException {
        return HtmlDefang.defang(new StringReader(html), neuterImages);
    }

    public static String defang(InputStream html, boolean neuterImages) throws IOException {
        StringWriter writer = new StringWriter();
        HtmlDefang.defang(html, neuterImages, (Writer)writer);
        return writer.toString();
    }

    public static void defang(InputStream html, boolean neuterImages, Writer out) throws IOException {
        XMLInputSource source = new XMLInputSource(null, null, null, html, null);
        HtmlDefang.defang(source, neuterImages, out);
    }

    public static String defang(Reader htmlReader, boolean neuterImages) throws IOException {
        StringWriter writer = new StringWriter();
        HtmlDefang.defang(htmlReader, neuterImages, (Writer)writer);
        return writer.toString();
    }

    public static void defang(Reader htmlReader, boolean neuterImages, Writer out) throws IOException {
        XMLInputSource source = new XMLInputSource(null, null, null, htmlReader, null);
        HtmlDefang.defang(source, neuterImages, out);
    }

    public static void defang(XMLInputSource source, boolean neuterImages, Writer out) throws IOException {
        DefangWriter writer = new DefangWriter(out, "utf-8");
        DefangFilter defang = new DefangFilter(neuterImages);
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{defang, writer};
        HTMLConfiguration parser = new HTMLConfiguration();
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
        parser.setFeature("http://cyberneko.org/html/features/balance-tags", false);
        parser.setFeature("http://xml.org/sax/features/namespaces", false);
        parser.parse(source);
    }

    public static void main(String[] args) throws IOException {
        String html = new String(ByteUtil.getContent(new File(args[0])));
        System.out.println(HtmlDefang.defang(html, true));
    }
}

