/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.html;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.cyberneko.html.filters.DefaultFilter;

public class DefangFilter
extends DefaultFilter {
    private static final boolean ENABLE_INPUT_TAGS = true;
    private static final boolean ENABLE_TABLE_TAGS = true;
    private static final boolean ENABLE_PHRASE_TAGS = true;
    private static final boolean ENABLE_LIST_TAGS = true;
    private static final boolean ENABLE_FONT_STYLE_TAGS = true;
    protected static final Object NULL = new Object();
    private static final Pattern AV_JS_ENTITY = Pattern.compile("&\\{[^}]*\\}");
    private static final Pattern AV_SCRIPT_TAG = Pattern.compile("</?script/?>", 2);
    private static final Pattern VALID_URL = Pattern.compile("^(https?://[\\w-].*|mailto:.*|cid:.*|notes:.*|smb:.*|[^:]*)$", 2);
    private static HashMap mAttrSetCache = new HashMap();
    private static HashMap mAcceptedElements = new HashMap();
    private static HashMap mRemovedElements = new HashMap();
    private String mBaseHref = null;
    private URI mBaseHrefURI = null;
    boolean mNeuterImages;
    protected String mRemovalElementName;
    protected int mRemovalElementCount;
    protected int mStyleDepth;
    private static String CORE = "id,class,title,style,";
    private static String LANG = "dir,lang,xml:lang,";
    private static String CORE_LANG = CORE + LANG;
    private static String KBD = "accesskey,tabindex,";

    public DefangFilter(boolean neuterImages) {
        this.mNeuterImages = neuterImages;
    }

    public static void acceptElement(String element, String attributes) {
        element = element.toLowerCase();
        HashSet<String> set = (HashSet<String>)mAttrSetCache.get(attributes);
        if (set != null) {
            mAcceptedElements.put(element, set);
            return;
        }
        set = new HashSet<String>();
        String[] attrs = attributes.toLowerCase().split(",");
        if (attrs != null && attrs.length > 0) {
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i].length() <= 0) continue;
                set.add(attrs[i]);
            }
        }
        mAcceptedElements.put(element, set);
        mAttrSetCache.put(attributes, set);
    }

    public static void removeElement(String element) {
        String key = element.toLowerCase();
        Object value = NULL;
        mRemovedElements.put(key, value);
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext nscontext, Augmentations augs) throws XNIException {
        this.mRemovalElementCount = 0;
        super.startDocument(locator, encoding, nscontext, augs);
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        this.startDocument(locator, encoding, null, augs);
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.startPrefixMapping(prefix, uri, augs);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        String name = element.localpart;
        if (this.mRemovalElementName == null) {
            if (this.handleOpenTag(element, attributes)) {
                super.startElement(element, attributes, augs);
            }
        } else if (name.equalsIgnoreCase(this.mRemovalElementName)) {
            ++this.mRemovalElementCount;
        }
        if (name.equalsIgnoreCase("style")) {
            ++this.mStyleDepth;
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null && this.handleOpenTag(element, attributes)) {
            super.emptyElement(element, attributes, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.comment(text, augs);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.processingInstruction(target, data, augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            if (this.mStyleDepth > 0) {
                String result = text.toString().replaceAll("[uU][Rr][Ll]\\s*\\(.*\\)", "url()");
                result = result.replaceAll("expression\\s*\\(.*\\)", "");
                super.characters(new XMLString(result.toCharArray(), 0, result.length()), augs);
            } else {
                super.characters(text, augs);
            }
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.ignorableWhitespace(text, augs);
        }
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier id, String encoding, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.startGeneralEntity(name, id, encoding, augs);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.textDecl(version, encoding, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.endGeneralEntity(name, augs);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.startCDATA(augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.endCDATA(augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        String name = element.localpart;
        if (this.mRemovalElementName == null) {
            if (DefangFilter.elementAccepted(element.rawname)) {
                super.endElement(element, augs);
            }
        } else if (name.equalsIgnoreCase(this.mRemovalElementName) && --this.mRemovalElementCount == 0) {
            this.mRemovalElementName = null;
        }
        if (name.equalsIgnoreCase("style")) {
            --this.mStyleDepth;
        }
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
        if (this.mRemovalElementName == null) {
            super.endPrefixMapping(prefix, augs);
        }
    }

    protected static boolean elementAccepted(String element) {
        String key = element.toLowerCase();
        return mAcceptedElements.containsKey(key);
    }

    protected static boolean elementRemoved(String element) {
        String key = element.toLowerCase();
        return mRemovedElements.containsKey(key);
    }

    protected boolean handleOpenTag(QName element, XMLAttributes attributes) {
        String eName;
        block17: {
            int index;
            eName = element.rawname.toLowerCase();
            if (eName.equals("base") && (index = attributes.getIndex("href")) != -1) {
                this.mBaseHref = attributes.getValue(index);
                if (this.mBaseHref != null) {
                    try {
                        this.mBaseHrefURI = new URI(this.mBaseHref);
                    }
                    catch (URISyntaxException e) {
                        if (this.mBaseHref.endsWith("/")) break block17;
                        this.mBaseHref = this.mBaseHref + "/";
                    }
                }
            }
        }
        if (DefangFilter.elementAccepted(element.rawname)) {
            Object value = mAcceptedElements.get(eName);
            if (value != NULL) {
                HashSet anames = (HashSet)value;
                int attributeCount = attributes.getLength();
                for (int i = 0; i < attributeCount; ++i) {
                    String aName = attributes.getQName(i).toLowerCase();
                    if (!anames.contains(aName)) {
                        attributes.removeAttributeAt(i--);
                        --attributeCount;
                        continue;
                    }
                    this.sanatizeAttrValue(eName, aName, attributes, i);
                }
            } else {
                attributes.removeAllAttributes();
            }
            if (eName.equals("img")) {
                this.fixUrlBase(attributes, "src");
            } else if (eName.equals("a")) {
                this.fixUrlBase(attributes, "href");
            }
            this.fixUrlBase(attributes, "background");
            if (eName.equals("img") && this.mNeuterImages) {
                this.neuterTag(attributes, "src");
            } else if (eName.equals("a")) {
                this.fixATag(attributes);
            }
            if (this.mNeuterImages) {
                this.neuterTag(attributes, "background");
            }
            return true;
        }
        if (DefangFilter.elementRemoved(element.rawname)) {
            this.mRemovalElementName = element.rawname;
            this.mRemovalElementCount = 1;
        }
        return false;
    }

    private void fixUrlBase(XMLAttributes attributes, String attrName) {
        int index = attributes.getIndex(attrName);
        if (index != -1) {
            String value = attributes.getValue(index);
            if (this.mBaseHref != null && value != null && value.indexOf(":") == -1) {
                if (this.mBaseHrefURI != null) {
                    try {
                        attributes.setValue(index, this.mBaseHrefURI.resolve(value).toString());
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                attributes.setValue(index, this.mBaseHref + value);
            }
        }
    }

    private void neuterTag(XMLAttributes attributes, String aName) {
        String df_aName = "df" + aName;
        int dfIndex = attributes.getIndex(df_aName);
        int index = attributes.getIndex(aName);
        if (index != -1) {
            String aValue = attributes.getValue(index);
            if (dfIndex != -1) {
                attributes.setValue(dfIndex, aValue);
            } else {
                attributes.addAttribute(new QName("", df_aName, df_aName, null), "CDATA", aValue);
            }
            attributes.removeAttributeAt(index);
            index = attributes.getIndex(aName);
            while (index != -1) {
                attributes.removeAttributeAt(index);
                index = attributes.getIndex(aName);
            }
        }
    }

    private void fixATag(XMLAttributes attributes) {
        int index = attributes.getIndex("href");
        if (index == -1) {
            return;
        }
        String href = attributes.getValue(index);
        if (href.indexOf(35) == 0) {
            return;
        }
        index = attributes.getIndex("target");
        if (index != -1) {
            attributes.setValue(index, "_blank");
        } else {
            attributes.addAttribute(new QName("", "target", "target", null), "CDATA", "_blank");
        }
    }

    private void sanatizeAttrValue(String eName, String aName, XMLAttributes attributes, int i) {
        String value = attributes.getValue(i);
        String result = AV_JS_ENTITY.matcher(value).replaceAll("JS-ENTITY-BLOCKED");
        result = AV_SCRIPT_TAG.matcher(result).replaceAll("SCRIPT-TAG-BLOCKED");
        if ((aName.equalsIgnoreCase("href") || aName.equalsIgnoreCase("src") || aName.equalsIgnoreCase("longdesc") || aName.equalsIgnoreCase("usemap")) && !VALID_URL.matcher(result).matches()) {
            result = "about:blank";
        }
        if (aName.equalsIgnoreCase("style")) {
            result = value.replaceAll("/\\*.*\\*/", "");
            result = result.replaceAll("[uU][Rr][Ll]\\s*\\(.*\\)", "none");
            result = result.replaceAll("expression\\s*\\(.*\\)", "");
        }
        if (!result.equals(value)) {
            attributes.setValue(i, result);
        }
    }

    static {
        DefangFilter.acceptElement("a", CORE + KBD + ",charset,coords,href,hreflang,name,rel,rev,shape,target,type");
        DefangFilter.acceptElement("address", CORE_LANG);
        DefangFilter.acceptElement("bdo", CORE_LANG);
        DefangFilter.acceptElement("blockquote", CORE_LANG + "cite");
        DefangFilter.acceptElement("body", CORE_LANG + "background");
        DefangFilter.acceptElement("br", CORE + "clear");
        DefangFilter.acceptElement("center", CORE_LANG);
        DefangFilter.acceptElement("del", CORE_LANG + "cite,datetime");
        DefangFilter.acceptElement("div", CORE_LANG + "align");
        DefangFilter.acceptElement("head", LANG);
        DefangFilter.acceptElement("h1", CORE_LANG + "align");
        DefangFilter.acceptElement("h2", CORE_LANG + "align");
        DefangFilter.acceptElement("h3", CORE_LANG + "align");
        DefangFilter.acceptElement("h4", CORE_LANG + "align");
        DefangFilter.acceptElement("h5", CORE_LANG + "align");
        DefangFilter.acceptElement("h6", CORE_LANG + "align");
        DefangFilter.acceptElement("hr", CORE_LANG + "align,noshade,size,width");
        DefangFilter.acceptElement("html", LANG + "xmlns");
        DefangFilter.acceptElement("img", CORE_LANG + "align,alt,border,height,hspace,ismap,longdesc,src,usemap,vspace,width");
        DefangFilter.acceptElement("ins", CORE_LANG + "cite");
        DefangFilter.acceptElement("label", CORE_LANG + "for");
        DefangFilter.acceptElement("p", CORE_LANG + "align");
        DefangFilter.acceptElement("pre", CORE_LANG + "width");
        DefangFilter.acceptElement("q", CORE_LANG + "cite");
        DefangFilter.acceptElement("span", CORE_LANG);
        DefangFilter.acceptElement("style", CORE_LANG);
        DefangFilter.acceptElement("sub", CORE_LANG);
        DefangFilter.acceptElement("sup", CORE_LANG);
        DefangFilter.acceptElement("title", "");
        DefangFilter.acceptElement("b", CORE_LANG);
        DefangFilter.acceptElement("basefont", CORE_LANG + "color,face,size");
        DefangFilter.acceptElement("big", CORE_LANG);
        DefangFilter.acceptElement("font", CORE_LANG + "color,face,size");
        DefangFilter.acceptElement("i", CORE_LANG);
        DefangFilter.acceptElement("s", CORE_LANG);
        DefangFilter.acceptElement("small", CORE_LANG);
        DefangFilter.acceptElement("strike", CORE_LANG);
        DefangFilter.acceptElement("tt", CORE_LANG);
        DefangFilter.acceptElement("u", CORE_LANG);
        DefangFilter.acceptElement("dir", CORE_LANG + "compact");
        DefangFilter.acceptElement("dl", CORE_LANG);
        DefangFilter.acceptElement("dt", CORE_LANG);
        DefangFilter.acceptElement("li", CORE_LANG + "type,value");
        DefangFilter.acceptElement("ol", CORE_LANG + "compact,start,type");
        DefangFilter.acceptElement("ul", CORE_LANG + "compact,type");
        DefangFilter.acceptElement("dd", CORE_LANG);
        DefangFilter.acceptElement("menu", CORE_LANG + "compact");
        DefangFilter.acceptElement("abbr", CORE_LANG);
        DefangFilter.acceptElement("acronym", CORE_LANG);
        DefangFilter.acceptElement("cite", CORE_LANG);
        DefangFilter.acceptElement("code", CORE_LANG);
        DefangFilter.acceptElement("dfn", CORE_LANG);
        DefangFilter.acceptElement("em", CORE_LANG);
        DefangFilter.acceptElement("kbd", CORE_LANG);
        DefangFilter.acceptElement("samp", CORE_LANG);
        DefangFilter.acceptElement("strong", CORE_LANG);
        DefangFilter.acceptElement("var", CORE_LANG);
        DefangFilter.acceptElement("caption", CORE_LANG + "align");
        DefangFilter.acceptElement("col", CORE_LANG + "alink,background,char,charoff,span,valign,width");
        DefangFilter.acceptElement("colgroup", CORE_LANG + "alink,background,char,charoff,span,valign,width");
        DefangFilter.acceptElement("table", CORE_LANG + "align,valign,background,bgcolor,border,cellpadding,cellspacing,frame,rules,summary,width");
        DefangFilter.acceptElement("tbody", CORE_LANG + "align,background,char,charoff,valign");
        DefangFilter.acceptElement("td", CORE_LANG + "abbr,align,axis,background,bgcolor,char,charoff,colspan,headers,height,nowrap,rowspan,scope,,valign,width");
        DefangFilter.acceptElement("tfoot", CORE_LANG + "align,background,char,charoff,valign");
        DefangFilter.acceptElement("th", CORE_LANG + "abbr,align,axis,background,bgcolor,char,charoff,colspan,headers,height,nowrap,rowspan,scope,valign,width");
        DefangFilter.acceptElement("thead", CORE_LANG + "align,background,char,charoff,valign");
        DefangFilter.acceptElement("tr", CORE_LANG + "align,background,bgcolor,char,charoff,valign");
        DefangFilter.acceptElement("area", CORE_LANG + KBD + "alt,coords,href,nohref,shape,target");
        DefangFilter.acceptElement("button", CORE_LANG + KBD + "disabled,name,type,value");
        DefangFilter.acceptElement("fieldset", CORE_LANG);
        DefangFilter.acceptElement("form", CORE_LANG + "action,accept,acceptcharset,enctype,method,name,target");
        DefangFilter.acceptElement("input", CORE_LANG + "accept,align,alt,checked,disabled,maxlength,name,readonly,size,src,type,value");
        DefangFilter.acceptElement("legend", CORE_LANG + "align");
        DefangFilter.acceptElement("map", CORE_LANG + "name");
        DefangFilter.acceptElement("optgroup", CORE_LANG + "disabled,label");
        DefangFilter.acceptElement("option", CORE_LANG + KBD + "disabled,label,selected,value");
        DefangFilter.acceptElement("select", CORE_LANG + KBD + "disabled,multiple,name,size");
        DefangFilter.acceptElement("textarea", CORE_LANG + "cols,disabled,name,readonly,rows");
        DefangFilter.removeElement("applet");
        DefangFilter.removeElement("frame");
        DefangFilter.removeElement("frameset");
        DefangFilter.removeElement("iframe");
        DefangFilter.removeElement("object");
        DefangFilter.removeElement("script");
        DefangFilter.removeElement("style");
    }
}

