/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.gal;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.ldap.LdapUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class GalSyncToken {
    static final String LDAP_GENERALIZED_TIME_FORMAT = "yyyyMMddHHmmss'Z'";
    private String mLdapTimestamp;
    private HashMap<String, String> mChangeIdMap;

    public GalSyncToken(String token) {
        this.parse(token);
    }

    public GalSyncToken(String ldapTs, String accountId, int changeId) {
        this.mLdapTimestamp = ldapTs;
        this.mChangeIdMap = new HashMap();
        this.mChangeIdMap.put(accountId, "" + changeId);
    }

    private void parse(String token) {
        this.mChangeIdMap = new HashMap();
        int pos = token.indexOf(58);
        if (pos == -1) {
            this.mLdapTimestamp = token;
            return;
        }
        this.mLdapTimestamp = token.substring(0, pos);
        boolean finished = false;
        while (!finished) {
            int sep = (token = token.substring(pos + 1)).indexOf(58);
            if (sep == -1) {
                return;
            }
            String key = token.substring(0, sep);
            String value = null;
            pos = token.indexOf(58, sep + 1);
            if (pos == -1) {
                finished = true;
                value = token.substring(sep + 1);
            } else {
                value = token.substring(sep + 1, pos);
            }
            this.mChangeIdMap.put(key, value);
        }
    }

    public String getLdapTimestamp() {
        return this.mLdapTimestamp;
    }

    public String getLdapTimestamp(String format) throws ServiceException {
        SimpleDateFormat standardFormat = new SimpleDateFormat(LDAP_GENERALIZED_TIME_FORMAT);
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        try {
            Date ts = standardFormat.parse(this.mLdapTimestamp);
            return fmt.format(ts);
        }
        catch (ParseException e) {
            return this.mLdapTimestamp;
        }
    }

    public int getChangeId(String accountId) {
        String cid = this.mChangeIdMap.get(accountId);
        if (cid != null) {
            return Integer.parseInt(cid);
        }
        return 0;
    }

    public boolean doMailboxSync() {
        return this.mLdapTimestamp.length() == 0 || this.mChangeIdMap.size() > 0;
    }

    public void merge(GalSyncToken that) {
        ZimbraLog.gal.debug("merging token " + this + " with " + that);
        this.mLdapTimestamp = LdapUtil.getEarlierTimestamp(this.mLdapTimestamp, that.mLdapTimestamp);
        for (String aid : that.mChangeIdMap.keySet()) {
            this.mChangeIdMap.put(aid, that.mChangeIdMap.get(aid));
        }
        ZimbraLog.gal.debug("result: " + this);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.mLdapTimestamp);
        for (String aid : this.mChangeIdMap.keySet()) {
            buf.append(":").append(aid).append(":").append(this.mChangeIdMap.get(aid));
        }
        return buf.toString();
    }
}

