/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.gal;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.gal.GalSearchParams;
import com.zimbra.cs.gal.GalSyncToken;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalSearchResultCallback
implements GalContact.Visitor {
    private Element mResponse;
    private ItemIdFormatter mFormatter;
    private boolean mIdOnly;

    public GalSearchResultCallback(GalSearchParams params) {
        this.reset(params);
    }

    public void reset(GalSearchParams params) {
        if (params.getSoapContext() != null) {
            this.mResponse = params.getSoapContext().createElement(params.getResponseName());
            this.mFormatter = new ItemIdFormatter(params.getSoapContext());
        } else {
            this.mResponse = Element.XMLElement.mFactory.createElement(params.getResponseName());
            this.mFormatter = new ItemIdFormatter();
        }
        params.setGalResult(Provisioning.SearchGalResult.newSearchGalResult(this));
        this.mIdOnly = params.isIdOnly();
    }

    @Override
    public void visit(GalContact c) throws ServiceException {
        this.handleContact(c);
    }

    public Element getResponse() {
        return this.mResponse;
    }

    public Element handleContact(Contact c) throws ServiceException {
        if (this.mIdOnly) {
            return this.mResponse.addElement("cn").addAttribute("id", this.mFormatter.formatItemId(c));
        }
        return ToXML.encodeContact(this.mResponse, this.mFormatter, c, true, null);
    }

    public void handleContact(GalContact c) throws ServiceException {
        ToXML.encodeGalContact(this.mResponse, c);
    }

    public void handleElement(Element e) throws ServiceException {
        this.mResponse.addElement(e.detach());
    }

    public void handleDeleted(ItemId id) {
        this.mResponse.addElement("deleted").addAttribute("id", id.toString());
    }

    protected HashMap<String, Object> parseContactElement(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator<Element> iter = e.elementIterator("a");
        while (iter.hasNext()) {
            Element elem = iter.next();
            String key = elem.getAttribute("n", null);
            String value = elem.getText();
            if (key == null) continue;
            Object obj = map.get(key);
            if (obj != null) {
                if (obj instanceof String) {
                    String[] str = new String[]{(String)obj, value};
                    map.put(key, str);
                    continue;
                }
                if (!(obj instanceof String[])) continue;
                ArrayList<String> arr = new ArrayList<String>();
                arr.addAll(Arrays.asList((String[])obj));
                arr.add(value);
                map.put(key, arr.toArray(new String[0]));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public void setNewToken(String newToken) {
        this.setNewToken(new GalSyncToken(newToken));
    }

    public void setNewToken(GalSyncToken newToken) {
        String oldToken = this.mResponse.getAttribute("token", null);
        if (oldToken != null) {
            newToken.merge(new GalSyncToken(oldToken));
        }
        this.mResponse.addAttribute("token", newToken.toString());
    }

    public void setSortBy(String sortBy) {
        this.mResponse.addAttribute("sortBy", sortBy);
    }

    public void setQueryOffset(int offset) {
        this.mResponse.addAttribute("offset", offset);
    }

    public void setHasMoreResult(boolean more) {
        this.mResponse.addAttribute("more", more);
    }
}

