/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.gal;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.gal.GalOp;
import com.zimbra.cs.account.gal.GalUtil;
import com.zimbra.cs.gal.GalSearchConfig;
import com.zimbra.cs.gal.GalSearchResultCallback;
import com.zimbra.cs.gal.GalSyncToken;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.soap.ZimbraSoapContext;
import org.dom4j.QName;

public class GalSearchParams {
    private GalSearchConfig mConfig;
    private Provisioning.GAL_SEARCH_TYPE mType;
    private int mLimit;
    private int mPageSize;
    private String mQuery;
    private GalSyncToken mSyncToken;
    private Provisioning.SearchGalResult mResult;
    private ZimbraSoapContext mSoapContext;
    private Account mAccount;
    private Account mGalSyncAccount;
    private Domain mDomain;
    private SearchParams mSearchParams;
    private GalSearchResultCallback mResultCallback;
    private Element mRequest;
    private QName mResponse;
    private DataSource mDataSource;
    private boolean mIdOnly;

    public GalSearchParams(Account account) {
        this.mAccount = account;
        this.mResult = Provisioning.SearchGalResult.newSearchGalResult(null);
        this.mResponse = AccountConstants.SEARCH_GAL_RESPONSE;
    }

    public GalSearchParams(Account account, ZimbraSoapContext ctxt) {
        this(account);
        this.mSoapContext = ctxt;
    }

    public GalSearchParams(Domain domain, ZimbraSoapContext ctxt) {
        this.mDomain = domain;
        this.mSoapContext = ctxt;
    }

    public GalSearchParams(DataSource ds) throws ServiceException {
        this(ds.getAccount());
        this.mDataSource = ds;
        this.mConfig = GalSearchConfig.create(this.mDataSource);
    }

    public GalSearchConfig getConfig() {
        return this.mConfig;
    }

    public Provisioning.GAL_SEARCH_TYPE getType() {
        return this.mType;
    }

    public int getLimit() {
        return this.mLimit;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    public String getQuery() {
        return this.mQuery;
    }

    public String getSyncToken() {
        if (this.mSyncToken == null) {
            return null;
        }
        return this.mSyncToken.getLdapTimestamp();
    }

    public GalSyncToken getGalSyncToken() {
        return this.mSyncToken;
    }

    public Provisioning.SearchGalResult getResult() {
        return this.mResult;
    }

    public Account getAccount() {
        return this.mAccount;
    }

    public Account getGalSyncAccount() {
        return this.mGalSyncAccount;
    }

    public Domain getDomain() throws ServiceException {
        if (this.mDomain != null) {
            return this.mDomain;
        }
        return Provisioning.getInstance().getDomain(this.mAccount);
    }

    public ZimbraSoapContext getSoapContext() {
        return this.mSoapContext;
    }

    public SearchParams getSearchParams() {
        return this.mSearchParams;
    }

    public GalSearchResultCallback getResultCallback() {
        if (this.mResultCallback == null) {
            return this.createResultCallback();
        }
        return this.mResultCallback;
    }

    public Element getRequest() {
        return this.mRequest;
    }

    public QName getResponseName() {
        return this.mResponse;
    }

    public boolean isIdOnly() {
        return this.mIdOnly;
    }

    public void setSearchConfig(GalSearchConfig config) {
        this.mConfig = config;
    }

    public void setType(Provisioning.GAL_SEARCH_TYPE type) {
        this.mType = type;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public void setPageSize(int pageSize) {
        this.mPageSize = pageSize;
    }

    public void setQuery(String query) {
        this.mQuery = query;
    }

    public void setToken(String token) {
        this.mSyncToken = new GalSyncToken(token);
    }

    public void setGalResult(Provisioning.SearchGalResult result) {
        this.mResult = result;
    }

    public void createSearchParams(String searchQuery) {
        this.mSearchParams = new SearchParams();
        this.mSearchParams.setLimit(this.mLimit + 1);
        this.mSearchParams.setSortBy(SortBy.NAME_ASCENDING);
        this.mSearchParams.setQueryStr(searchQuery);
        this.mSearchParams.setTypes(new byte[]{6});
    }

    public void parseSearchParams(Element request, String searchQuery) throws ServiceException {
        if (request == null || this.mSoapContext == null) {
            this.createSearchParams(searchQuery);
            return;
        }
        this.setRequest(request);
        this.mSearchParams = SearchParams.parse(request, this.mSoapContext, searchQuery);
        this.mSearchParams.setTypes(new byte[]{6});
        this.setLimit(this.mSearchParams.getLimit());
    }

    public void setResultCallback(GalSearchResultCallback callback) {
        this.mResultCallback = callback;
    }

    public GalSearchResultCallback createResultCallback() {
        this.mResultCallback = new GalSearchResultCallback(this);
        return this.mResultCallback;
    }

    public void setRequest(Element req) {
        this.mRequest = req;
    }

    public void setResponseName(QName response) {
        this.mResponse = response;
    }

    public void createSearchConfig(GalOp op, GalSearchConfig.GalType type) throws ServiceException {
        this.mConfig = GalSearchConfig.create(this.getDomain(), op, type, this.mType);
    }

    public String generateLdapQuery() throws ServiceException {
        assert (this.mConfig != null);
        String token = this.mSyncToken != null ? this.mSyncToken.getLdapTimestamp(this.mConfig.mTimestampFormat) : null;
        return GalUtil.expandFilter(this.mConfig.getTokenizeKey(), this.mConfig.getFilter(), this.mQuery, token, false);
    }

    public void setGalSyncAccount(Account acct) {
        this.mGalSyncAccount = acct;
    }

    public void setIdOnly(boolean idOnly) {
        this.mIdOnly = idOnly;
    }
}

