/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.gal;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttrProvisioning;
import com.zimbra.cs.account.gal.GalOp;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.db.DbDataSource;
import com.zimbra.cs.gal.GalSearchConfig;
import com.zimbra.cs.gal.GalSearchParams;
import com.zimbra.cs.gal.GalSearchResultCallback;
import com.zimbra.cs.gal.GalSyncToken;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.index.ContactHit;
import com.zimbra.cs.index.ResultsPager;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.util.TypedIdList;
import com.zimbra.cs.service.util.ItemId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GalSearchControl {
    private GalSearchParams mParams;

    public GalSearchControl(GalSearchParams params) {
        this.mParams = params;
    }

    public void autocomplete() throws ServiceException {
        String query = this.mParams.getQuery();
        if (query == null) {
            query = "";
        }
        if (query.endsWith("*")) {
            query = query.substring(0, query.length() - 1);
        }
        this.mParams.setQuery(query);
        if (this.mParams.getAccount().isGalSyncAccountBasedAutoCompleteEnabled()) {
            try {
                Account galAcct = this.mParams.getGalSyncAccount();
                if (galAcct != null) {
                    this.accountSearch(galAcct);
                } else {
                    for (Account galAccount : this.getGalSyncAccounts()) {
                        this.accountSearch(galAccount);
                    }
                }
                return;
            }
            catch (GalAccountNotConfiguredException galAccountNotConfiguredException) {
                // empty catch block
            }
        }
        this.mParams.setQuery(query + "*");
        this.mParams.getResultCallback().reset(this.mParams);
        this.mParams.setLimit(100);
        this.ldapSearch(GalOp.autocomplete);
    }

    public void search() throws ServiceException {
        String query = this.mParams.getQuery();
        if (query == null) {
            query = "";
        }
        this.mParams.setQuery(query);
        try {
            Account galAcct = this.mParams.getGalSyncAccount();
            if (galAcct != null) {
                this.accountSearch(galAcct);
            } else {
                for (Account galAccount : this.getGalSyncAccounts()) {
                    this.accountSearch(galAccount);
                }
            }
        }
        catch (GalAccountNotConfiguredException e) {
            if (!query.endsWith("*")) {
                query = query + "*";
            }
            if (!query.startsWith("*")) {
                query = "*" + query;
            }
            this.mParams.setQuery(query);
            this.mParams.getResultCallback().reset(this.mParams);
            this.mParams.setLimit(100);
            this.ldapSearch(GalOp.search);
        }
    }

    public void sync() throws ServiceException {
        this.mParams.setQuery("");
        Account galAcct = this.mParams.getGalSyncAccount();
        try {
            if (galAcct != null) {
                this.accountSync(galAcct);
            } else {
                for (Account galAccount : this.getGalSyncAccounts()) {
                    this.accountSync(galAccount);
                }
            }
            GalSyncToken gst = this.mParams.getGalSyncToken();
            if (this.mParams.isIdOnly() && gst.doMailboxSync()) {
                return;
            }
        }
        catch (GalAccountNotConfiguredException e) {
            this.mParams.getResultCallback().reset(this.mParams);
        }
        this.ldapSearch(GalOp.sync);
    }

    private Account[] getGalSyncAccounts() throws GalAccountNotConfiguredException, ServiceException {
        Domain d = this.mParams.getDomain();
        String[] accts = d.getGalAccountId();
        if (accts.length == 0) {
            throw new GalAccountNotConfiguredException();
        }
        Provisioning prov = Provisioning.getInstance();
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (String acctId : accts) {
            Account a = prov.getAccountById(acctId);
            if (a == null) {
                throw new GalAccountNotConfiguredException();
            }
            for (DataSource ds : a.getAllDataSources()) {
                if (ds.getType() != DataSource.Type.gal) continue;
                if (ds.getAttr("zimbraGalLastSuccessfulSyncTimestamp", null) == null) {
                    throw new GalAccountNotConfiguredException();
                }
                if (ds.getAttr("zimbraGalStatus").compareTo("enabled") != 0) {
                    throw new GalAccountNotConfiguredException();
                }
                if (ds.getAttr("zimbraDataSourceEnabled").compareTo("TRUE") == 0) continue;
                throw new GalAccountNotConfiguredException();
            }
            accounts.add(a);
        }
        return accounts.toArray(new Account[0]);
    }

    private void generateSearchQuery(Account galAcct) throws ServiceException, GalAccountNotConfiguredException {
        String query = this.mParams.getQuery();
        Provisioning.GAL_SEARCH_TYPE type = this.mParams.getType();
        StringBuilder searchQuery = new StringBuilder();
        if (query.length() > 0) {
            searchQuery.append("contact:(").append(query).append(") AND");
        }
        ZAttrProvisioning.GalMode galMode = Provisioning.getInstance().getDomain(galAcct).getGalMode();
        boolean first = true;
        for (DataSource ds : galAcct.getAllDataSources()) {
            if (ds.getType() != DataSource.Type.gal) continue;
            String galType = ds.getAttr("zimbraGalType");
            if (galMode == ZAttrProvisioning.GalMode.ldap && galType.compareTo("zimbra") == 0 || galMode == ZAttrProvisioning.GalMode.zimbra && galType.compareTo("ldap") == 0) continue;
            if (first) {
                searchQuery.append("(");
            } else {
                searchQuery.append(" OR");
            }
            first = false;
            searchQuery.append(" inid:").append(ds.getFolderId());
        }
        if (!first) {
            searchQuery.append(")");
        }
        switch (type) {
            case CALENDAR_RESOURCE: {
                searchQuery.append(" AND #zimbraAccountCalendarUserType:RESOURCE");
                break;
            }
            case USER_ACCOUNT: {
                searchQuery.append(" AND !(#zimbraAccountCalendarUserType:RESOURCE)");
                break;
            }
        }
        ZimbraLog.gal.debug("query: " + searchQuery.toString());
        this.mParams.parseSearchParams(this.mParams.getRequest(), searchQuery.toString());
    }

    private void accountSearch(Account galAcct) throws ServiceException, GalAccountNotConfiguredException {
        if (!galAcct.getAccountStatus().isActive()) {
            ZimbraLog.gal.info("GalSync account " + galAcct.getId() + " is in " + galAcct.getAccountStatus().name());
            throw new GalAccountNotConfiguredException();
        }
        if (Provisioning.onLocalServer(galAcct)) {
            this.generateSearchQuery(galAcct);
            if (!this.doLocalGalAccountSearch(galAcct)) {
                throw new GalAccountNotConfiguredException();
            }
        } else if (!this.proxyGalAccountSearch(galAcct)) {
            throw new GalAccountNotConfiguredException();
        }
    }

    private void accountSync(Account galAcct) throws ServiceException, GalAccountNotConfiguredException {
        if (!galAcct.getAccountStatus().isActive()) {
            ZimbraLog.gal.info("GalSync account " + galAcct.getId() + " is in " + galAcct.getAccountStatus().name());
            throw new GalAccountNotConfiguredException();
        }
        if (Provisioning.onLocalServer(galAcct) ? !this.doLocalGalAccountSync(galAcct) : !this.proxyGalAccountSearch(galAcct)) {
            throw new GalAccountNotConfiguredException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doLocalGalAccountSearch(Account galAcct) {
        ZimbraQueryResults zqr = null;
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(galAcct);
        SearchParams searchParams = this.mParams.getSearchParams();
        zqr = mbox.search(SoapProtocol.Soap12, new OperationContext(mbox), searchParams);
        ResultsPager pager = ResultsPager.create(zqr, searchParams);
        GalSearchResultCallback callback = this.mParams.getResultCallback();
        int num = 0;
        while (pager.hasNext()) {
            Element contactElem;
            ZimbraHit hit = pager.getNextHit();
            if (hit instanceof ContactHit && (contactElem = callback.handleContact(((ContactHit)hit).getContact())) != null) {
                contactElem.addAttribute("sf", hit.getSortField(pager.getSortOrder()).toString());
            }
            if (++num != this.mParams.getLimit()) continue;
            break;
        }
        callback.setSortBy(zqr.getSortBy().toString());
        callback.setQueryOffset(searchParams.getOffset());
        callback.setHasMoreResult(pager.hasNext());
        Object var11_12 = null;
        if (zqr == null) return true;
        try {
            zqr.doneWithSearchResults();
            return true;
        }
        catch (ServiceException e2) {}
        return true;
        {
            catch (Exception e) {
                ZimbraLog.gal.warn((Object)("search on GalSync account failed for " + galAcct.getId()), e);
                boolean bl = false;
                Object var11_13 = null;
                if (zqr == null) return bl;
                try {
                    zqr.doneWithSearchResults();
                    return bl;
                }
                catch (ServiceException e2) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (zqr == null) throw throwable;
            try {
                zqr.doneWithSearchResults();
                throw throwable;
            }
            catch (ServiceException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean doLocalGalAccountSync(Account galAcct) {
        GalSyncToken token = this.mParams.getGalSyncToken();
        try {
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(galAcct);
            OperationContext octxt = new OperationContext(mbox);
            GalSearchResultCallback callback = this.mParams.getResultCallback();
            HashSet<Integer> folderIds = new HashSet<Integer>();
            ZAttrProvisioning.GalMode galMode = Provisioning.getInstance().getDomain(galAcct).getGalMode();
            String syncToken = null;
            for (DataSource ds : galAcct.getAllDataSources()) {
                if (ds.getType() != DataSource.Type.gal) continue;
                String galType = ds.getAttr("zimbraGalType");
                if (galMode == ZAttrProvisioning.GalMode.ldap && galType.compareTo("zimbra") == 0 || galMode == ZAttrProvisioning.GalMode.zimbra && galType.compareTo("ldap") == 0) continue;
                int fid = ds.getFolderId();
                folderIds.add(fid);
                DbDataSource.DataSourceItem folderMapping = DbDataSource.getMapping(ds, fid);
                syncToken = LdapUtil.getEarlierTimestamp(syncToken, folderMapping.md.get("st"));
            }
            if (this.mParams.isIdOnly() && token.doMailboxSync()) {
                int changeId = token.getChangeId(galAcct.getId());
                List<Integer> deleted = mbox.getTombstones(changeId).getAll();
                Pair<List<Integer>, TypedIdList> changed = mbox.getModifiedItems(octxt, changeId, (byte)6, folderIds);
                int count = 0;
                for (int itemId : changed.getFirst()) {
                    MailItem item = mbox.getItemById(octxt, itemId, (byte)6);
                    if (item instanceof Contact) {
                        callback.handleContact((Contact)item);
                    }
                    if (++count % 100 != 0) continue;
                    ZimbraLog.gal.debug("processing #" + count);
                }
                if (changeId > 0) {
                    for (int itemId : deleted) {
                        callback.handleDeleted(new ItemId(galAcct.getId(), itemId));
                    }
                }
            }
            GalSyncToken newToken = new GalSyncToken(syncToken, galAcct.getId(), mbox.getLastChangeID());
            ZimbraLog.gal.debug("computing new sync token for " + galAcct.getId() + ": " + newToken);
            callback.setNewToken(newToken);
            callback.setHasMoreResult(false);
        }
        catch (Exception e) {
            ZimbraLog.gal.warn((Object)("search on GalSync account failed for " + galAcct.getId()), e);
            return false;
        }
        return true;
    }

    private boolean proxyGalAccountSearch(Account targetAcct) {
        try {
            boolean hasMore;
            Element req;
            Provisioning prov = Provisioning.getInstance();
            String serverUrl = URLUtil.getAdminURL(prov.getServerByName(targetAcct.getMailHost()));
            SoapHttpTransport transport = new SoapHttpTransport(serverUrl);
            transport.setAuthToken(AuthToken.getZimbraAdminAuthToken().toZAuthToken());
            transport.setTargetAcctId(targetAcct.getId());
            if (this.mParams.getSoapContext() != null) {
                transport.setResponseProtocol(this.mParams.getSoapContext().getResponseProtocol());
            }
            if ((req = this.mParams.getRequest()) == null) {
                req = Element.create(SoapProtocol.Soap12, AccountConstants.SEARCH_GAL_REQUEST);
                req.addAttribute("type", "account");
                req.addAttribute("name", this.mParams.getQuery());
            }
            req.addAttribute("id", targetAcct.getId());
            Element resp = transport.invokeWithoutSession(req.detach());
            GalSearchResultCallback callback = this.mParams.getResultCallback();
            Iterator<Element> iter = resp.elementIterator("cn");
            while (iter.hasNext()) {
                callback.handleElement(iter.next());
            }
            iter = resp.elementIterator("deleted");
            while (iter.hasNext()) {
                callback.handleElement(iter.next());
            }
            String newTokenStr = resp.getAttribute("token", null);
            if (newTokenStr != null) {
                GalSyncToken newToken = new GalSyncToken(newTokenStr);
                ZimbraLog.gal.debug("computing new sync token for proxied account " + targetAcct.getId() + ": " + newToken);
                callback.setNewToken(newToken);
            }
            if (hasMore = resp.getAttributeBool("more", false)) {
                callback.setHasMoreResult(true);
                callback.setSortBy(resp.getAttribute("sortBy"));
                callback.setQueryOffset((int)resp.getAttributeLong("offset"));
            }
        }
        catch (Exception e) {
            ZimbraLog.gal.warn((Object)("remote search on GalSync account failed for" + targetAcct.getName()), e);
            return false;
        }
        return true;
    }

    private void ldapSearch(GalOp op) throws ServiceException {
        ZAttrProvisioning.GalMode galMode = this.mParams.getDomain().getGalMode();
        int limit = this.mParams.getLimit();
        if (galMode == ZAttrProvisioning.GalMode.both) {
            this.mParams.setLimit(limit / 2);
        }
        GalSearchConfig.GalType type = GalSearchConfig.GalType.ldap;
        if (galMode != ZAttrProvisioning.GalMode.ldap) {
            type = GalSearchConfig.GalType.zimbra;
        }
        this.mParams.createSearchConfig(op, type);
        try {
            LdapUtil.galSearch(this.mParams);
        }
        catch (Exception e) {
            throw ServiceException.FAILURE("ldap search failed", e);
        }
        boolean hadMore = this.mParams.getResult().getHadMore();
        String newToken = this.mParams.getResult().getToken();
        if (this.mParams.getResult().getTokenizeKey() != null) {
            hadMore = true;
        }
        if (galMode == ZAttrProvisioning.GalMode.both) {
            this.mParams.createSearchConfig(op, GalSearchConfig.GalType.ldap);
            try {
                LdapUtil.galSearch(this.mParams);
            }
            catch (Exception e) {
                throw ServiceException.FAILURE("ldap search failed", e);
            }
            hadMore |= this.mParams.getResult().getHadMore();
            newToken = LdapUtil.getLaterTimestamp(newToken, this.mParams.getResult().getToken());
            if (this.mParams.getResult().getTokenizeKey() != null) {
                hadMore = true;
            }
        }
        if (op == GalOp.sync) {
            this.mParams.getResultCallback().setNewToken(newToken);
        }
        this.mParams.getResultCallback().setHasMoreResult(hadMore);
    }

    private static class GalAccountNotConfiguredException
    extends Exception {
        private static final long serialVersionUID = 679221874958248740L;
    }
}

