/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.gal;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttrProvisioning;
import com.zimbra.cs.account.gal.GalOp;
import com.zimbra.cs.account.gal.GalUtil;
import com.zimbra.cs.account.ldap.LdapGalMapRules;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;

public class GalSearchConfig {
    protected GalOp mOp;
    protected GalType mGalType;
    protected String[] mUrl;
    protected boolean mStartTlsEnabled;
    protected String mFilter;
    protected String mSearchBase;
    protected String mAuthMech;
    protected String mBindDn;
    protected String mBindPassword;
    protected String mKerberosPrincipal;
    protected String mKerberosKeytab;
    protected String mTimestampFormat;
    protected String mTokenizeKey;
    protected int mPageSize;
    protected LdapGalMapRules mRules;

    public static GalSearchConfig create(Domain domain, GalOp op, GalType type, Provisioning.GAL_SEARCH_TYPE stype) throws ServiceException {
        switch (type) {
            case zimbra: {
                return new ZimbraConfig(domain, op, stype);
            }
            case ldap: {
                return new LdapConfig(domain, op);
            }
        }
        return null;
    }

    public static GalSearchConfig create(DataSource ds) throws ServiceException {
        return new DataSourceConfig(ds);
    }

    protected void loadZimbraConfig(Domain domain, GalOp op, Provisioning.GAL_SEARCH_TYPE stype) throws ServiceException {
        this.mRules = new LdapGalMapRules(domain.getMultiAttr("zimbraGalLdapAttrMap"));
        this.mOp = op;
        String filterName = null;
        switch (op) {
            case sync: {
                filterName = stype == Provisioning.GAL_SEARCH_TYPE.ALL ? "zimbraSync" : (stype == Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE ? "zimbraResourceSync" : "zimbraAccountSync");
                break;
            }
            case search: {
                filterName = stype == Provisioning.GAL_SEARCH_TYPE.ALL ? "zimbraSearch" : (stype == Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE ? "zimbraResources" : "zimbraAccounts");
                this.mTokenizeKey = domain.getAttr("zimbraGalTokenizeSearchKey", null);
                break;
            }
            case autocomplete: {
                filterName = stype == Provisioning.GAL_SEARCH_TYPE.ALL ? "zimbraAutoComplete" : (stype == Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE ? "zimbraResourceAutoComplete" : "zimbraAccountAutoComplete");
                this.mTokenizeKey = domain.getAttr("zimbraGalTokenizeAutoCompleteKey", null);
            }
        }
        if (filterName != null) {
            this.mFilter = LdapProvisioning.getFilterDef(filterName);
        }
        this.mAuthMech = "simple";
        this.mFilter = "(&(" + this.mFilter + ")(!(zimbraHideInGal=TRUE))(!(zimbraIsSystemResource=TRUE)))";
        this.mSearchBase = LdapUtil.getZimbraSearchBase(domain, op);
        this.mGalType = GalType.zimbra;
        this.mTimestampFormat = "yyyyMMddHHmmss'Z'";
        this.mPageSize = 1000;
    }

    private boolean isConfigComplete() {
        return this.mUrl.length > 0 && this.mFilter != null && (this.mAuthMech.equals("none") || this.mAuthMech.equals("simple") && this.mBindDn != null && this.mBindPassword != null || this.mAuthMech.equals("kerberos5") && this.mKerberosKeytab != null && this.mKerberosPrincipal != null);
    }

    protected void loadConfig(Domain domain, GalOp op) throws ServiceException {
        this.mRules = new LdapGalMapRules(domain.getMultiAttr("zimbraGalLdapAttrMap"));
        this.mOp = op;
        ZAttrProvisioning.GalMode galMode = domain.getGalMode();
        if (galMode == ZAttrProvisioning.GalMode.zimbra) {
            this.loadZimbraConfig(domain, op, null);
        }
        switch (op) {
            case sync: {
                this.mUrl = domain.getMultiAttr("zimbraGalSyncLdapURL");
                this.mFilter = domain.getAttr("zimbraGalLdapFilter");
                this.mSearchBase = domain.getAttr("zimbraGalSyncLdapSearchBase", "");
                this.mStartTlsEnabled = domain.getBooleanAttr("zimbraGalSyncLdapStartTlsEnabled", false);
                this.mAuthMech = domain.getAttr("zimbraGalSyncLdapAuthMech", "simple");
                this.mBindDn = domain.getAttr("zimbraGalSyncLdapBindDn");
                this.mBindPassword = domain.getAttr("zimbraGalSyncLdapBindPassword");
                this.mKerberosPrincipal = domain.getAttr("zimbraGalSyncLdapKerberos5Principal");
                this.mKerberosKeytab = domain.getAttr("zimbraGalSyncLdapKerberos5Keytab");
                this.mTimestampFormat = domain.getAttr("zimbraGalSyncTimestampFormat", "yyyyMMddHHmmss'Z'");
                this.mPageSize = domain.getIntAttr("zimbraGalSyncLdapPageSize", 1000);
                if (this.isConfigComplete()) break;
            }
            case search: {
                this.mUrl = domain.getMultiAttr("zimbraGalLdapURL");
                this.mFilter = domain.getAttr("zimbraGalLdapFilter");
                this.mSearchBase = domain.getAttr("zimbraGalLdapSearchBase", "");
                this.mStartTlsEnabled = domain.getBooleanAttr("zimbraGalLdapStartTlsEnabled", false);
                this.mAuthMech = domain.getAttr("zimbraGalLdapAuthMech", "simple");
                this.mBindDn = domain.getAttr("zimbraGalLdapBindDn");
                this.mBindPassword = domain.getAttr("zimbraGalLdapBindPassword");
                this.mKerberosPrincipal = domain.getAttr("zimbraGalLdapKerberos5Principal");
                this.mKerberosKeytab = domain.getAttr("zimbraGalLdapKerberos5Keytab");
                this.mTokenizeKey = domain.getAttr("zimbraGalTokenizeSearchKey");
                this.mPageSize = domain.getIntAttr("zimbraGalLdapPageSize", 1000);
                break;
            }
            case autocomplete: {
                this.mUrl = domain.getMultiAttr("zimbraGalLdapURL");
                this.mFilter = domain.getAttr("zimbraGalAutoCompleteLdapFilter");
                this.mSearchBase = domain.getAttr("zimbraGalLdapSearchBase", "");
                this.mStartTlsEnabled = domain.getBooleanAttr("zimbraGalLdapStartTlsEnabled", false);
                this.mAuthMech = domain.getAttr("zimbraGalLdapAuthMech", "simple");
                this.mBindDn = domain.getAttr("zimbraGalLdapBindDn");
                this.mBindPassword = domain.getAttr("zimbraGalLdapBindPassword");
                this.mKerberosPrincipal = domain.getAttr("zimbraGalLdapKerberos5Principal");
                this.mKerberosKeytab = domain.getAttr("zimbraGalLdapKerberos5Keytab");
                this.mTokenizeKey = domain.getAttr("zimbraGalTokenizeAutoCompleteKey");
                this.mPageSize = domain.getIntAttr("zimbraGalLdapPageSize", 1000);
            }
        }
        if (this.mFilter != null && this.mFilter.indexOf("(") == -1) {
            this.mFilter = LdapProvisioning.getFilterDef(this.mFilter);
        }
        this.mGalType = GalType.ldap;
    }

    public GalOp getOp() {
        return this.mOp;
    }

    public GalType getGalType() {
        return this.mGalType;
    }

    public String[] getUrl() {
        return this.mUrl;
    }

    public boolean getStartTlsEnabled() {
        return this.mStartTlsEnabled;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public String getSearchBase() {
        return this.mSearchBase;
    }

    public String getAuthMech() {
        return this.mAuthMech;
    }

    public String getBindDn() {
        return this.mBindDn;
    }

    public String getBindPassword() {
        return this.mBindPassword;
    }

    public String getKerberosPrincipal() {
        return this.mKerberosPrincipal;
    }

    public String getKerberosKeytab() {
        return this.mKerberosKeytab;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    public LdapGalMapRules getRules() {
        return this.mRules;
    }

    public String getTokenizeKey() {
        return this.mTokenizeKey;
    }

    public void setGalType(GalType galType) {
        this.mGalType = galType;
    }

    public void setUrl(String[] url) {
        this.mUrl = url;
    }

    public void setStartTlsEnabled(boolean startTlsEnabled) {
        this.mStartTlsEnabled = startTlsEnabled;
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public void setSearchBase(String searchBase) {
        this.mSearchBase = searchBase;
    }

    public void setAuthMech(String authMech) {
        this.mAuthMech = authMech;
    }

    public void setBindDn(String bindDn) {
        this.mBindDn = bindDn;
    }

    public void setBindPassword(String bindPassword) {
        this.mBindPassword = bindPassword;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.mKerberosPrincipal = kerberosPrincipal;
    }

    public void setKerberosKeytab(String kerberosKeytab) {
        this.mKerberosKeytab = kerberosKeytab;
    }

    public void setRules(LdapGalMapRules rules) {
        this.mRules = rules;
    }

    public void setTokenizeKey(String tokenizeKey) {
        this.mTokenizeKey = tokenizeKey;
    }

    private static class DataSourceConfig
    extends GalSearchConfig {
        private static final String DEFAULT_FILTER = "(&(|(displayName=*)(cn=*)(sn=*)(gn=*)(mail=*)(zimbraMailDeliveryAddress=*)(zimbraMailAlias=*))(|(objectclass=zimbraAccount)(objectclass=zimbraDistributionList))(!(zimbraHideInGal=TRUE))(!(zimbraIsSystemResource=TRUE)))";

        public DataSourceConfig(DataSource ds) throws ServiceException {
            String[] attrs;
            this.mGalType = GalType.fromString(ds.getAttr("zimbraGalType"));
            Domain domain = Provisioning.getInstance().getDomain(ds.getAccount());
            if (this.mGalType == GalType.zimbra) {
                this.loadZimbraConfig(domain, GalOp.sync, null);
                this.mFilter = LdapProvisioning.getFilterDef("zimbraSync");
                if (this.mFilter == null) {
                    this.mFilter = DEFAULT_FILTER;
                }
            } else {
                String[] url;
                this.loadConfig(domain, GalOp.sync);
                if (this.mUrl.length == 0 || this.mFilter == null) {
                    this.loadConfig(domain, GalOp.search);
                }
                if ((url = ds.getMultiAttr("zimbraGalSyncLdapURL")) != null && url.length > 0) {
                    this.mUrl = url;
                }
                this.mFilter = ds.getAttr("zimbraGalSyncLdapFilter", this.mFilter);
                this.mSearchBase = ds.getAttr("zimbraGalSyncLdapSearchBase", this.mSearchBase);
                this.mStartTlsEnabled = ds.getBooleanAttr("zimbraGalSyncLdapStartTlsEnabled", this.mStartTlsEnabled);
                this.mAuthMech = ds.getAttr("zimbraGalSyncLdapAuthMech", this.mAuthMech);
                this.mBindDn = ds.getAttr("zimbraGalSyncLdapBindDn", this.mBindDn);
                this.mBindPassword = ds.getAttr("zimbraGalSyncLdapBindPassword", this.mBindPassword);
                this.mKerberosPrincipal = ds.getAttr("zimbraGalSyncLdapKerberos5Principal", this.mKerberosPrincipal);
                this.mKerberosKeytab = ds.getAttr("zimbraGalSyncLdapKerberos5Keytab", this.mKerberosKeytab);
                this.mTimestampFormat = ds.getAttr("zimbraGalSyncTimestampFormat", this.mTimestampFormat);
                this.mPageSize = ds.getIntAttr("zimbraGalSyncLdapPageSize", this.mPageSize);
            }
            if ((attrs = ds.getMultiAttr("zimbraGalLdapAttrMap")).length > 0) {
                this.mRules = new LdapGalMapRules(attrs);
            }
            this.mFilter = GalUtil.expandFilter(null, this.mFilter, "", null, false);
        }
    }

    private static class LdapConfig
    extends GalSearchConfig {
        public LdapConfig(Domain domain, GalOp op) throws ServiceException {
            this.loadConfig(domain, op);
        }
    }

    private static class ZimbraConfig
    extends GalSearchConfig {
        public ZimbraConfig(Domain domain, GalOp op, Provisioning.GAL_SEARCH_TYPE stype) throws ServiceException {
            this.loadZimbraConfig(domain, op, stype);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GalType {
        zimbra,
        ldap;


        public static GalType fromString(String s) throws ServiceException {
            try {
                return GalType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown gal type: " + s, e);
            }
        }
    }
}

