/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.gal;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.datasource.MailItemImport;
import com.zimbra.cs.db.DbDataSource;
import com.zimbra.cs.gal.GalSearchParams;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedContact;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalImport
extends MailItemImport {
    private static final String TYPE = "t";
    private static final String FOLDER = "f";
    public static final String SYNCTOKEN = "st";
    private static String[] ZIMBRA_ATTRS = new String[]{"zimbraAccountCalendarUserType", "zimbraCalResType", "zimbraCalResLocationDisplayName", "zimbraCalResCapacity", "zimbraCalResContactEmail"};

    public GalImport(DataSource ds) throws ServiceException {
        super(ds);
    }

    @Override
    public void importData(List<Integer> folderIds, boolean fullSync) throws ServiceException {
        if (folderIds == null) {
            this.importGal(this.dataSource.getFolderId(), fullSync, false);
        } else {
            for (int fid : folderIds) {
                this.importGal(fid, fullSync, false);
            }
        }
    }

    @Override
    public void test() throws ServiceException {
        try {
            this.searchGal(null, Provisioning.SearchGalResult.newSearchGalResult(null));
        }
        catch (NamingException e) {
            throw ServiceException.FAILURE("Error executing gal search", e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Error executing gal search", e);
        }
    }

    private void setStatus(boolean success) throws ServiceException {
        Date now = new Date();
        DataSource ds = this.getDataSource();
        HashMap<String, String> attrs = new HashMap<String, String>();
        String attr = success ? "zimbraGalLastSuccessfulSyncTimestamp" : "zimbraGalLastFailedSyncTimestamp";
        attrs.put(attr, DateUtil.toGeneralizedTime(now));
        Provisioning.getInstance().modifyAttrs(ds, attrs);
    }

    public void importGal(int fid, boolean fullSync, boolean force) throws ServiceException {
        this.mbox.beginTrackingSync();
        DataSource ds = this.getDataSource();
        DbDataSource.DataSourceItem folderMapping = DbDataSource.getMapping(ds, fid);
        if (folderMapping.md == null) {
            folderMapping.itemId = fid;
            folderMapping.md = new Metadata();
            folderMapping.md.put(TYPE, FOLDER);
            DbDataSource.addMapping(ds, folderMapping);
        }
        String syncToken = fullSync ? "" : folderMapping.md.get(SYNCTOKEN, "");
        HashMap<String, DbDataSource.DataSourceItem> allMappings = new HashMap<String, DbDataSource.DataSourceItem>();
        if (fullSync || force) {
            for (DbDataSource.DataSourceItem dsItem : DbDataSource.getAllMappings(ds)) {
                if (dsItem.md != null && dsItem.md.get(TYPE, null) != null) continue;
                allMappings.put(dsItem.remoteId, dsItem);
            }
        }
        OperationContext octxt = new OperationContext(this.mbox);
        Provisioning.SearchGalResult result = Provisioning.SearchGalResult.newSearchGalResult(new GalSearchVisitor(this.mbox, allMappings, fid, force));
        try {
            this.searchGal(syncToken, result);
        }
        catch (Exception e) {
            this.setStatus(false);
            ZimbraLog.gal.error((Object)"Error executing gal search", e);
            return;
        }
        folderMapping.md.put(SYNCTOKEN, result.getToken());
        DbDataSource.updateMapping(ds, folderMapping);
        if (allMappings.size() == 0 || !fullSync) {
            this.setStatus(true);
            return;
        }
        ArrayList<Integer> deleted = new ArrayList<Integer>();
        int[] deletedIds = new int[allMappings.size()];
        int i = 0;
        for (DbDataSource.DataSourceItem dsItem : allMappings.values()) {
            deleted.add(dsItem.itemId);
            deletedIds[i++] = dsItem.itemId;
        }
        try {
            this.mbox.delete(octxt, deletedIds, (byte)6, null);
        }
        catch (ServiceException e) {
            ZimbraLog.gal.warn((Object)"Ignoring error deleting gal contacts", e);
        }
        DbDataSource.deleteMappings(this.getDataSource(), deleted);
        this.setStatus(true);
    }

    private void searchGal(String syncToken, Provisioning.SearchGalResult result) throws ServiceException, NamingException, IOException {
        ZimbraLog.gal.debug("searchGal: " + syncToken);
        DataSource ds = this.getDataSource();
        GalSearchParams params = new GalSearchParams(ds);
        params.setGalResult(result);
        params.setToken(syncToken);
        params.setQuery("*");
        for (String attr : ZIMBRA_ATTRS) {
            params.getConfig().getRules().add(attr + "=" + attr);
        }
        LdapUtil.galSearch(params);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GalSearchVisitor
    implements GalContact.Visitor {
        Mailbox mbox;
        OperationContext octxt;
        Map<String, DbDataSource.DataSourceItem> mappings;
        int fid;
        boolean force;
        private String[] FILE_AS_STR_KEYS = new String[]{"fullName", "email", "email2", "email3"};

        private GalSearchVisitor(Mailbox mbox, Map<String, DbDataSource.DataSourceItem> mappings, int fid, boolean force) throws ServiceException {
            this.mbox = mbox;
            this.octxt = new OperationContext(mbox);
            this.mappings = mappings;
            this.fid = fid;
            this.force = force;
        }

        private void addFileAsStr(Map<String, Object> attrs) {
            for (String key : this.FILE_AS_STR_KEYS) {
                Object fileAsStr = attrs.get(key);
                if (fileAsStr == null || !(fileAsStr instanceof String)) continue;
                attrs.put("fileAs", "8:" + (String)fileAsStr);
                return;
            }
        }

        @Override
        public void visit(GalContact contact) throws ServiceException {
            Map<String, Object> attrs = contact.getAttrs();
            String id = contact.getId();
            attrs.put("dn", id);
            ZimbraLog.gal.debug("processing gal contact " + id);
            DbDataSource.DataSourceItem dsItem = DbDataSource.getReverseMapping(GalImport.this.getDataSource(), id);
            String modifiedDate = (String)contact.getAttrs().get("modifyTimeStamp");
            this.addFileAsStr(attrs);
            if (dsItem.itemId == 0) {
                ZimbraLog.gal.debug("creating new contact " + id);
                dsItem.remoteId = id;
                ParsedContact pc = new ParsedContact(attrs);
                dsItem.itemId = this.mbox.createContact(this.octxt, pc, this.fid, null).getId();
                DbDataSource.addMapping(GalImport.this.getDataSource(), dsItem);
            } else {
                String syncDate = this.mbox.getContactById(this.octxt, dsItem.itemId).get("modifyTimeStamp");
                if (this.force || syncDate == null || !syncDate.equals(modifiedDate)) {
                    ZimbraLog.gal.debug("modifying contact " + id);
                    ParsedContact pc = new ParsedContact(attrs);
                    this.mbox.modifyContact(this.octxt, dsItem.itemId, pc);
                }
            }
            this.mappings.remove(id);
        }
    }
}

