/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter.jsieve;

import com.zimbra.cs.filter.jsieve.ActionFlag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.Block;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.commands.AbstractActionCommand;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.MailAdapter;

public class Flag
extends AbstractActionCommand {
    private static Map<String, ActionFlag> FLAGS = new HashMap<String, ActionFlag>();

    protected Object executeBasic(MailAdapter mail, Arguments args, Block arg2, SieveContext context) {
        String flagName = (String)((StringListArgument)args.getArgumentList().get(0)).getList().get(0);
        ActionFlag action = FLAGS.get(flagName);
        mail.addAction((Action)action);
        return null;
    }

    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
        List args = arguments.getArgumentList();
        if (args.size() != 1) {
            throw new SyntaxException("Exactly 1 argument permitted. Found " + args.size());
        }
        Object argument = args.get(0);
        if (!(argument instanceof StringListArgument)) {
            throw new SyntaxException("Expecting a string-list");
        }
        List strList = ((StringListArgument)argument).getList();
        if (1 != strList.size()) {
            throw new SyntaxException("Expecting exactly one argument");
        }
        String flagName = (String)strList.get(0);
        if (!FLAGS.containsKey(flagName.toLowerCase())) {
            throw new SyntaxException("Invalid flag: " + flagName);
        }
    }

    static {
        FLAGS.put("read", new ActionFlag(-10, false, "read"));
        FLAGS.put("unread", new ActionFlag(-10, true, "unread"));
        FLAGS.put("flagged", new ActionFlag(-6, true, "flagged"));
        FLAGS.put("unflagged", new ActionFlag(-6, false, "unflagged"));
    }
}

