/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter.jsieve;

import com.zimbra.cs.filter.ZimbraMailAdapter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ListIterator;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.tests.AbstractTest;

public class DateTest
extends AbstractTest {
    static DateFormat mShortDateFormat = new SimpleDateFormat("yyyyMMdd");
    static final String BEFORE = ":before";
    static final String AFTER = ":after";

    protected boolean executeBasic(MailAdapter mail, Arguments arguments, SieveContext context) throws SieveException {
        Object argument;
        String comparator = null;
        Date date = null;
        ListIterator argumentsIter = arguments.getArgumentList().listIterator();
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof TagArgument) {
            String tag = ((TagArgument)argument).getTag();
            if (tag.equals(BEFORE) || tag.equals(AFTER)) {
                comparator = tag;
            } else {
                throw new SyntaxException("Found unexpected: \"" + tag + "\"");
            }
        }
        if (null == comparator) {
            throw new SyntaxException("Expecting \":before\" or \":after\"");
        }
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof StringListArgument) {
            StringListArgument strList = (StringListArgument)argument;
            String datestr = (String)strList.getList().get(0);
            try {
                date = mShortDateFormat.parse(datestr);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (null == date) {
            throw new SyntaxException("Expecting a valid date (yyyyMMdd)");
        }
        if (argumentsIter.hasNext()) {
            throw new SyntaxException("Found unexpected argument(s)");
        }
        if (!(mail instanceof ZimbraMailAdapter)) {
            return false;
        }
        return this.test(mail, comparator, date);
    }

    protected void validateArguments(Arguments arguments, SieveContext context) {
    }

    private boolean test(MailAdapter mail, String comparator, Date date) throws SieveException {
        MimeMessage mimeMsg = ((ZimbraMailAdapter)mail).getMimeMessage();
        try {
            Date msgDate = mimeMsg.getSentDate();
            if (msgDate == null) {
                throw new SieveException("Invalid date (" + mail.getHeader("Date").get(0) + ")");
            }
            if (BEFORE.equals(comparator)) {
                return msgDate.before(date);
            }
            if (AFTER.equals(comparator)) {
                return msgDate.after(date);
            }
        }
        catch (MessagingException e) {
            throw new SieveException(e.getMessage());
        }
        return false;
    }
}

