/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter.jsieve;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.HtmlTextExtractor;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.filter.ZimbraMailAdapter;
import com.zimbra.cs.mime.MPartInfo;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.tests.AbstractTest;

public class BodyTest
extends AbstractTest {
    static final String CONTAINS = ":contains";

    protected boolean executeBasic(MailAdapter mail, Arguments arguments, SieveContext context) throws SieveException {
        Object argument;
        String comparator = null;
        String key = null;
        ListIterator argumentsIter = arguments.getArgumentList().listIterator();
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof TagArgument) {
            String tag = ((TagArgument)argument).getTag();
            if (tag.equals(CONTAINS)) {
                comparator = tag;
            } else {
                throw new SyntaxException("Found unexpected TagArgument: \"" + tag + "\"");
            }
        }
        if (null == comparator) {
            throw new SyntaxException("Expecting \":contains\"");
        }
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof StringListArgument) {
            StringListArgument strList = (StringListArgument)argument;
            key = (String)strList.getList().get(0);
        }
        if (null == key) {
            throw new SyntaxException("Expecting a string");
        }
        if (argumentsIter.hasNext()) {
            throw new SyntaxException("Found unexpected argument(s)");
        }
        if (!(mail instanceof ZimbraMailAdapter)) {
            return false;
        }
        return this.test(mail, key);
    }

    protected void validateArguments(Arguments arguments, SieveContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean test(MailAdapter mail, String substring) {
        ZimbraMailAdapter zimbraMail = (ZimbraMailAdapter)mail;
        ParsedMessage pm = zimbraMail.getParsedMessage();
        if (pm == null) {
            return false;
        }
        Account acct = null;
        try {
            acct = zimbraMail.getMailbox().getAccount();
        }
        catch (ServiceException e) {
            // empty catch block
        }
        String charset = acct == null ? null : acct.getAttr("zimbraPrefMailDefaultCharset", null);
        Iterator<MPartInfo> i$ = pm.getMessageParts().iterator();
        while (true) {
            Object var16_18;
            InputStream in;
            block18: {
                boolean bl;
                Reader reader;
                if (!i$.hasNext()) {
                    return false;
                }
                MPartInfo mpi = i$.next();
                String cType = mpi.getContentType();
                if ("attachment".equals(mpi.getDisposition())) continue;
                if (cType.equals("text/plain")) {
                    Object var14_17;
                    block16: {
                        boolean bl2;
                        in = null;
                        try {
                            try {
                                in = mpi.getMimePart().getInputStream();
                                InputStreamReader inputStreamReader = reader = charset == null ? new InputStreamReader(in) : new InputStreamReader(in, charset);
                                if (!this.contains(reader, substring)) break block16;
                                bl2 = true;
                                var14_17 = null;
                            }
                            catch (Exception e) {
                                ZimbraLog.filter.warn("Unable to test text body for substring '%s'", (Object)substring, e);
                                var14_17 = null;
                                ByteUtil.closeStream(in);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            var14_17 = null;
                            ByteUtil.closeStream(in);
                            throw throwable;
                        }
                        ByteUtil.closeStream(in);
                        return bl2;
                    }
                    var14_17 = null;
                    ByteUtil.closeStream(in);
                    continue;
                }
                if (!cType.equals("text/html")) continue;
                in = null;
                try {
                    try {
                        in = mpi.getMimePart().getInputStream();
                        reader = Mime.getTextReader(in, cType, charset);
                        String text = HtmlTextExtractor.extract(reader, 0x100000);
                        if (!this.contains(new StringReader(text), substring)) break block18;
                        bl = true;
                        var16_18 = null;
                    }
                    catch (Exception e) {
                        ZimbraLog.filter.warn("Unable to test HTML body for substring '%s'", (Object)substring, e);
                        var16_18 = null;
                        ByteUtil.closeStream(in);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var16_18 = null;
                    ByteUtil.closeStream(in);
                    throw throwable;
                }
                ByteUtil.closeStream(in);
                return bl;
            }
            var16_18 = null;
            ByteUtil.closeStream(in);
        }
    }

    private boolean contains(Reader reader, String substring) throws IOException {
        int matchIndex = 0;
        substring = substring.toLowerCase();
        PushbackReader pb = new PushbackReader(reader);
        int c = -1;
        while ((c = this.getNextChar(pb)) > 0) {
            matchIndex = substring.charAt(matchIndex) == Character.toLowerCase(c) ? ++matchIndex : 0;
            if (matchIndex != substring.length()) continue;
            return true;
        }
        return false;
    }

    private int getNextChar(PushbackReader reader) throws IOException {
        int c = reader.read();
        if (c != 13 && c != 10) {
            return c;
        }
        while ((c = reader.read()) == 13 || c == 10) {
        }
        if (c >= 0) {
            reader.unread(c);
        }
        return 32;
    }
}

