/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter.jsieve;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.filter.ZimbraMailAdapter;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.OperationContext;
import java.io.IOException;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.tests.AbstractTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressBookTest
extends AbstractTest {
    static final String IN = ":in";
    static final String CONTACTS = "contacts";
    static final String GAL = "GAL";
    static final byte[] SEARCH_TYPE = new byte[]{6};
    private static Log mLog = LogFactory.getLog(AddressBookTest.class);

    protected boolean executeBasic(MailAdapter mail, Arguments arguments, SieveContext context) throws SieveException {
        int i;
        StringListArgument strList;
        Object argument;
        Object argument2;
        String comparator = null;
        HashSet<String> abooks = null;
        ListIterator argumentsIter = arguments.getArgumentList().listIterator();
        if (argumentsIter.hasNext() && (argument2 = argumentsIter.next()) instanceof TagArgument) {
            String tag = ((TagArgument)argument2).getTag();
            if (tag.equals(IN)) {
                comparator = tag;
            } else {
                throw new SyntaxException("Found unexpected: \"" + tag + "\"");
            }
        }
        if (null == comparator) {
            throw new SyntaxException("Expecting \":in\"");
        }
        String[] headers = null;
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof StringListArgument) {
            strList = (StringListArgument)argument;
            headers = new String[strList.getList().size()];
            for (i = 0; i < headers.length; ++i) {
                headers[i] = (String)strList.getList().get(i);
            }
        }
        if (headers == null) {
            throw new SyntaxException("No headers are found");
        }
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof StringListArgument) {
            strList = (StringListArgument)argument;
            abooks = new HashSet<String>();
            for (i = 0; i < strList.getList().size(); ++i) {
                String abookName = (String)strList.getList().get(i);
                if (!CONTACTS.equals(abookName) && !GAL.equals(abookName)) {
                    throw new SyntaxException("Unknown address book name: " + abookName);
                }
                abooks.add(abookName);
            }
        }
        if (abooks == null || abooks.isEmpty()) {
            throw new SyntaxException("Expecting address book name(s)");
        }
        if (argumentsIter.hasNext()) {
            throw new SyntaxException("Found unexpected argument(s)");
        }
        if (!(mail instanceof ZimbraMailAdapter)) {
            return false;
        }
        return this.test(mail, comparator, headers, abooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean test(MailAdapter mail, String comparator, String[] headers, Set<String> abooks) throws SieveException {
        zimbraMail = (ZimbraMailAdapter)mail;
        i$ = abooks.iterator();
        block15: while (true) {
            if (i$.hasNext() == false) return false;
            abookName = i$.next();
            if (!"contacts".equals(abookName)) continue;
            mbox = zimbraMail.getMailbox();
            i = 0;
            while (true) {
                if (i < headers.length) ** break;
                continue block15;
                headerVals = mail.getHeader(headers[i]);
                for (k = 0; k < headerVals.size(); ++k) {
                    block19: {
                        headerVal = ((String)headerVals.get(k)).toLowerCase();
                        results = null;
                        try {
                            try {
                                iaddrStr = headerVal;
                                try {
                                    iaddr = new InternetAddress(headerVal);
                                    iaddrStr = iaddr.getAddress();
                                }
                                catch (AddressException e1) {
                                    // empty catch block
                                }
                                results = mbox.search(new OperationContext(mbox), "To:" + iaddrStr, AddressBookTest.SEARCH_TYPE, SortBy.DATE_ASCENDING, 100);
                                AddressBookTest.mLog.debug("searching for " + iaddrStr);
                                if (!results.hasNext()) break block19;
                                AddressBookTest.mLog.debug("found " + iaddrStr + " in contacts");
                                var15_20 = true;
                                var17_21 = null;
                                if (results == null) return var15_20;
                            }
                            catch (IOException e) {
                                var17_21 = null;
                                if (results == null) continue;
                                try {
                                    results.doneWithSearchResults();
                                }
                                catch (ServiceException e) {}
                                continue;
                            }
                            catch (ParseException e) {
                                var17_21 = null;
                                if (results == null) continue;
                                try {}
                                catch (ServiceException e) {}
                                results.doneWithSearchResults();
                                continue;
                            }
                            catch (ServiceException e) {
                                var17_21 = null;
                                if (results == null) continue;
                                try {}
                                catch (ServiceException e) {}
                                results.doneWithSearchResults();
                                continue;
                            }
                        }
                        catch (Throwable var16_23) {
                            var17_21 = null;
                            if (results == null) throw var16_23;
                            ** try [egrp 3[TRYBLOCK] [10 : 303->313)] { 
lbl66:
                            // 1 sources

                            results.doneWithSearchResults();
                            throw var16_23;
lbl68:
                            // 1 sources

                            catch (ServiceException e) {
                                // empty catch block
                            }
                            throw var16_23;
                        }
                        try {}
                        catch (ServiceException e) {
                            // empty catch block
                            return var15_20;
                        }
                        results.doneWithSearchResults();
                        return var15_20;
                    }
                    var17_21 = null;
                    if (results == null) continue;
                    try {}
                    catch (ServiceException e) {}
                    results.doneWithSearchResults();
                }
                ++i;
            }
            break;
        }
    }

    protected void validateArguments(Arguments arguments, SieveContext context) {
    }
}

