/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.filter.FilterAddress;
import com.zimbra.cs.filter.FilterHandler;
import com.zimbra.cs.filter.ZimbraSieveException;
import com.zimbra.cs.filter.jsieve.ActionFlag;
import com.zimbra.cs.filter.jsieve.ActionTag;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.util.ItemId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionFileInto;
import org.apache.jsieve.mail.ActionKeep;
import org.apache.jsieve.mail.ActionRedirect;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mail.MailUtils;
import org.apache.jsieve.mail.SieveMailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraMailAdapter
implements MailAdapter {
    private Mailbox mMailbox;
    private FilterHandler mHandler;
    private Integer mFlagBitmask;
    private String mTags;
    private boolean mAllowFilterToMountpoint = true;
    private Set<String> mFiledIntoPaths = new HashSet<String>();
    private static Set<String> sAddrHdrs = new HashSet<String>();
    private List<Action> mActions = new ArrayList<Action>();
    protected List<ItemId> mAddedMessageIds = new ArrayList<ItemId>();

    public ZimbraMailAdapter(Mailbox mailbox, FilterHandler handler) {
        this.mMailbox = mailbox;
        this.mHandler = handler;
    }

    public void setAllowFilterToMountpoint(boolean allowFilterToMountpoint) {
        this.mAllowFilterToMountpoint = allowFilterToMountpoint;
    }

    public ParsedMessage getParsedMessage() {
        try {
            return this.mHandler.getParsedMessage();
        }
        catch (ServiceException e) {
            ZimbraLog.filter.warn((Object)"Unable to get ParsedMessage.", e);
            return null;
        }
    }

    public MimeMessage getMimeMessage() {
        try {
            return this.mHandler.getMimeMessage();
        }
        catch (ServiceException e) {
            ZimbraLog.filter.warn((Object)"Unable to get MimeMessage.", e);
            return null;
        }
    }

    public List<Action> getActions() {
        return this.mActions;
    }

    public ListIterator<Action> getActionsIterator() {
        return this.mActions.listIterator();
    }

    public void addAction(Action action) {
        this.mActions.add(action);
    }

    public void executeActions() throws SieveException {
        try {
            this.mHandler.beforeFiltering();
            String messageId = Mime.getMessageID(this.mHandler.getMimeMessage());
            if (this.getActions().size() == 0) {
                ZimbraLog.filter.info("Discarding message with Message-ID %s from %s", messageId, Mime.getSender(this.mHandler.getMimeMessage()));
                this.mHandler.discard();
                return;
            }
            List<Action> deliveryActions = this.getDeliveryActions();
            if (deliveryActions.size() == 0) {
                this.doDefaultFiling();
            }
            for (Action action : deliveryActions) {
                if (action instanceof ActionKeep) {
                    if (((ActionKeep)action).isImplicit()) {
                        this.doDefaultFiling();
                        continue;
                    }
                    this.explicitKeep();
                    continue;
                }
                if (action instanceof ActionFileInto) {
                    ActionFileInto fileinto = (ActionFileInto)action;
                    String folderPath = fileinto.getDestination();
                    try {
                        if (!this.mAllowFilterToMountpoint && ZimbraMailAdapter.isMountpoint(this.mMailbox, folderPath)) {
                            ZimbraLog.filter.info("Filing to mountpoint \"%s\" is not allowed.  Filing to the default folder instead.", folderPath);
                            this.explicitKeep();
                            continue;
                        }
                        this.fileInto(folderPath);
                    }
                    catch (ServiceException e) {
                        ZimbraLog.filter.info("Unable to file message to %s.  Filing to %s instead.", (Object)folderPath, (Object)this.mHandler.getDefaultFolderPath(), e);
                        this.explicitKeep();
                    }
                    continue;
                }
                if (action instanceof ActionRedirect) {
                    ActionRedirect redirect = (ActionRedirect)action;
                    String addr = redirect.getAddress();
                    ZimbraLog.filter.info("Redirecting message to %s.", addr);
                    try {
                        this.mHandler.redirect(addr);
                    }
                    catch (Exception e) {
                        ZimbraLog.filter.warn("Unable to redirect to %s.  Filing message to %s.", (Object)addr, (Object)this.mHandler.getDefaultFolderPath(), e);
                        this.explicitKeep();
                    }
                    continue;
                }
                throw new SieveException("unknown action " + action);
            }
            this.mHandler.afterFiltering();
        }
        catch (ServiceException e) {
            throw new ZimbraSieveException(e);
        }
    }

    private static boolean isMountpoint(Mailbox mbox, String folderPath) throws ServiceException {
        Pair<Folder, String> pair = mbox.getFolderByPathLongestMatch(null, 1, folderPath);
        Folder f = pair.getFirst();
        return f != null && f instanceof Mountpoint;
    }

    private List<Action> getDeliveryActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Action action : this.mActions) {
            if (!(action instanceof ActionKeep) && !(action instanceof ActionFileInto) && !(action instanceof ActionRedirect)) continue;
            actions.add(action);
        }
        return actions;
    }

    private List<Action> getTagActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Action action : this.mActions) {
            if (!(action instanceof ActionTag)) continue;
            actions.add(action);
        }
        return actions;
    }

    private List<Action> getFlagActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Action action : this.mActions) {
            if (!(action instanceof ActionFlag)) continue;
            actions.add(action);
        }
        return actions;
    }

    public Message doDefaultFiling() throws ServiceException {
        String folderPath = this.mHandler.getDefaultFolderPath();
        Message msg = null;
        if (this.mFiledIntoPaths.contains(folderPath)) {
            ZimbraLog.filter.info("Ignoring second attempt to file into %s.", folderPath);
        } else {
            msg = this.mHandler.implicitKeep(this.getFlagBitmask(), this.getTags());
            if (msg != null) {
                this.mFiledIntoPaths.add(folderPath);
                this.mAddedMessageIds.add(new ItemId(msg));
            }
        }
        return msg;
    }

    private Message explicitKeep() throws ServiceException {
        String folderPath = this.mHandler.getDefaultFolderPath();
        Message msg = null;
        if (this.mFiledIntoPaths.contains(folderPath)) {
            ZimbraLog.filter.info("Ignoring second attempt to file into %s.", folderPath);
        } else {
            msg = this.mHandler.explicitKeep(this.getFlagBitmask(), this.getTags());
            if (msg != null) {
                this.mFiledIntoPaths.add(folderPath);
                this.mAddedMessageIds.add(new ItemId(msg));
            }
        }
        return msg;
    }

    private void fileInto(String folderPath) throws ServiceException {
        if (this.mFiledIntoPaths.contains(folderPath)) {
            ZimbraLog.filter.info("Ignoring second attempt to file into %s.", folderPath);
        } else {
            ItemId id = this.mHandler.fileInto(folderPath, this.getFlagBitmask(), this.getTags());
            if (id != null) {
                this.mFiledIntoPaths.add(folderPath);
                this.mAddedMessageIds.add(id);
            }
        }
    }

    private String getTags() throws ServiceException {
        if (this.mTags == null) {
            StringBuilder tagsBuf = null;
            for (Action action : this.getTagActions()) {
                Tag tag;
                block7: {
                    String tagName = ((ActionTag)action).getTagName();
                    tag = null;
                    try {
                        tag = this.mMailbox.getTagByName(tagName);
                    }
                    catch (MailServiceException e) {
                        if (!e.getCode().equals("mail.NO_SUCH_TAG")) break block7;
                        ZimbraLog.filter.info("Could not find tag %s.  Automatically creating it.", tagName);
                        try {
                            tag = this.mMailbox.createTag(null, tagName, (byte)0);
                        }
                        catch (ServiceException e2) {
                            ZimbraLog.filter.warn("Could not create tag %s.  Not applying tag.", (Object)tagName, e2);
                        }
                    }
                }
                if (tag == null) continue;
                if (tagsBuf == null) {
                    tagsBuf = new StringBuilder(Integer.toString(tag.getId()));
                    continue;
                }
                tagsBuf.append(",").append(tag.getId());
            }
            this.mTags = tagsBuf == null ? "" : tagsBuf.toString();
        }
        return this.mTags;
    }

    private int getFlagBitmask() {
        if (this.mFlagBitmask == null) {
            int flagBits = this.mHandler.getDefaultFlagBitmask();
            for (Action action : this.getFlagActions()) {
                ActionFlag flagAction = (ActionFlag)action;
                int flagId = flagAction.getFlagId();
                try {
                    Flag flag = this.mMailbox.getFlagById(flagId);
                    if (flagAction.isSetFlag()) {
                        flagBits = (int)((long)flagBits | flag.getBitmask());
                        continue;
                    }
                    flagBits = (int)((long)flagBits & (flag.getBitmask() ^ 0xFFFFFFFFFFFFFFFFL));
                }
                catch (ServiceException e) {
                    ZimbraLog.filter.warn((Object)"Unable to flag message", e);
                }
            }
            this.mFlagBitmask = flagBits;
        }
        return this.mFlagBitmask;
    }

    private List<String> handleIDN(String headerName, String[] headers) {
        ArrayList<String> hdrs = new ArrayList<String>();
        for (int i = 0; i < headers.length; ++i) {
            boolean altered = false;
            if (headers[i].contains("xn--")) {
                StringTokenizer st = new StringTokenizer(headers[i], ",;", true);
                StringBuffer addrs = new StringBuffer();
                while (st.hasMoreTokens()) {
                    String address = st.nextToken();
                    String delim = st.hasMoreTokens() ? st.nextToken() : "";
                    try {
                        InternetAddress inetAddr = new InternetAddress(address);
                        String addr = inetAddr.getAddress();
                        String unicodeAddr = IDNUtil.toUnicode(addr);
                        if (unicodeAddr.equalsIgnoreCase(addr)) {
                            addrs.append(address).append(delim);
                            continue;
                        }
                        altered = true;
                        inetAddr.setAddress(unicodeAddr);
                        addrs.append(inetAddr.toString()).append(delim);
                    }
                    catch (AddressException e) {
                        ZimbraLog.filter.warn("handleIDN encountered invalid address " + address + "in header " + headerName);
                        addrs.append(address).append(delim);
                    }
                }
                if (altered) {
                    String unicodeAddrs = addrs.toString();
                    ZimbraLog.filter.debug("handleIDN added value " + unicodeAddrs + " for header " + headerName);
                    hdrs.add(unicodeAddrs);
                }
            }
            hdrs.add(headers[i]);
        }
        return hdrs;
    }

    public List<String> getHeader(String name) {
        MimeMessage msg = null;
        try {
            msg = this.mHandler.getMimeMessage();
        }
        catch (ServiceException e) {
            ZimbraLog.filter.warn((Object)"Unable to get MimeMessage.", e);
            return Collections.emptyList();
        }
        String[] headers = Mime.getHeaders(msg, name);
        if (headers == null) {
            return Collections.emptyList();
        }
        if (sAddrHdrs.contains(name.toLowerCase())) {
            return this.handleIDN(name, headers);
        }
        return Arrays.asList(headers);
    }

    public List<String> getHeaderNames() throws SieveMailException {
        HashSet<String> headerNames = new HashSet<String>();
        MimeMessage msg = null;
        try {
            msg = this.mHandler.getMimeMessage();
        }
        catch (ServiceException e) {
            ZimbraLog.filter.warn((Object)"Unable to get MimeMessage.", e);
            return Collections.emptyList();
        }
        try {
            Enumeration allHeaders = msg.getAllHeaders();
            while (allHeaders.hasMoreElements()) {
                headerNames.add(((Header)allHeaders.nextElement()).getName());
            }
            return new ArrayList<String>(headerNames);
        }
        catch (MessagingException ex) {
            throw new SieveMailException((Throwable)ex);
        }
    }

    public List<String> getMatchingHeader(String name) throws SieveMailException {
        List result = MailUtils.getMatchingHeader((MailAdapter)this, (String)name);
        return result;
    }

    public int getSize() throws SieveMailException {
        try {
            return this.mHandler.getParsedMessage().getRawSize();
        }
        catch (Exception e) {
            throw new SieveMailException((Throwable)e);
        }
    }

    public List<ItemId> getAddedMessageIds() {
        return Collections.unmodifiableList(this.mAddedMessageIds);
    }

    public Mailbox getMailbox() {
        return this.mMailbox;
    }

    public Object getContent() {
        return "";
    }

    public String getContentType() {
        return "text/plain";
    }

    public MailAdapter.Address[] parseAddresses(String headerName) {
        MimeMessage msg = null;
        try {
            msg = this.mHandler.getMimeMessage();
        }
        catch (ServiceException e) {
            ZimbraLog.filter.warn((Object)"Unable to get MimeMessage.", e);
            return FilterAddress.EMPTY_ADDRESS_ARRAY;
        }
        String[] addresses = Mime.getHeaders(msg, headerName);
        if (addresses == null) {
            return FilterAddress.EMPTY_ADDRESS_ARRAY;
        }
        MailAdapter.Address[] retVal = new MailAdapter.Address[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            retVal[i] = new FilterAddress(addresses[i]);
        }
        return retVal;
    }

    static {
        sAddrHdrs.add("bcc");
        sAddrHdrs.add("cc");
        sAddrHdrs.add("from");
        sAddrHdrs.add("reply-to");
        sAddrHdrs.add("sender");
        sAddrHdrs.add("to");
    }
}

