/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.filter.FilterUtil;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;

public class SoapToSieve {
    private Element mRoot;
    private StringBuilder mBuf;

    public SoapToSieve(Element filterRulesRoot) throws ServiceException {
        String name = filterRulesRoot.getName();
        if (!name.equals("filterRules")) {
            throw ServiceException.FAILURE("Invalid element: " + name, null);
        }
        this.mRoot = filterRulesRoot;
    }

    public String getSieveScript() throws ServiceException {
        if (this.mBuf == null) {
            this.mBuf = new StringBuilder();
            this.mBuf.append("require [\"fileinto\", \"reject\", \"tag\", \"flag\"];\n");
            for (Element rule : this.mRoot.listElements("filterRule")) {
                this.mBuf.append("\n");
                this.handleRule(rule);
            }
        }
        return this.mBuf.toString();
    }

    private void handleRule(Element rule) throws ServiceException {
        String name = rule.getAttribute("name");
        boolean isActive = rule.getAttributeBool("active", true);
        Element testsElement = rule.getElement("filterTests");
        String s = testsElement.getAttribute("condition", FilterUtil.Condition.allof.toString());
        s = s.toLowerCase();
        FilterUtil.Condition condition = FilterUtil.Condition.fromString(s);
        this.mBuf.append("# ").append(name).append("\n");
        if (isActive) {
            this.mBuf.append("if ");
        } else {
            this.mBuf.append("disabled_if ");
        }
        this.mBuf.append((Object)condition).append(" (");
        List<Element> testElements = testsElement.listElements();
        TreeMap tests = new TreeMap();
        for (Element test : testElements) {
            s = this.handleTest(test);
            if (s == null) continue;
            int index = FilterUtil.getIndex(test);
            FilterUtil.addToMap(tests, index, s);
        }
        this.mBuf.append(StringUtil.join(",\n  ", tests.values()));
        this.mBuf.append(") {\n");
        Element actionsElement = rule.getElement("filterActions");
        TreeMap actions = new TreeMap();
        for (Element element : actionsElement.listElements()) {
            s = this.handleAction(element);
            if (s == null) continue;
            int index = FilterUtil.getIndex(element);
            FilterUtil.addToMap(actions, index, s);
        }
        for (String string : actions.values()) {
            this.mBuf.append("    ").append(string).append(";\n");
        }
        this.mBuf.append("}\n");
    }

    private String handleTest(Element test) throws ServiceException {
        String name = test.getName();
        String snippet = null;
        if (name.equals("headerTest")) {
            String header = test.getAttribute("header");
            String s = test.getAttribute("stringComparison");
            s = s.toLowerCase();
            FilterUtil.StringComparison comparison = FilterUtil.StringComparison.fromString(s);
            String value = test.getAttribute("value");
            snippet = String.format("header :%s \"%s\" \"%s\"", new Object[]{comparison, FilterUtil.escape(header), FilterUtil.escape(value)});
            if (comparison == FilterUtil.StringComparison.matches && value != null && value.contains("*****")) {
                throw ServiceException.INVALID_REQUEST("Wildcard match value cannot contain more than four asterisks in a row.", null);
            }
        } else if (name.equals("headerExistsTest")) {
            String header = test.getAttribute("header");
            snippet = String.format("exists \"%s\"", FilterUtil.escape(header));
        } else if (name.equals("sizeTest")) {
            String s = test.getAttribute("numberComparison");
            s = s.toLowerCase();
            FilterUtil.NumberComparison comparison = FilterUtil.NumberComparison.fromString(s);
            String sizeString = test.getAttribute("s");
            try {
                FilterUtil.parseSize(sizeString);
            }
            catch (NumberFormatException e) {
                throw ServiceException.INVALID_REQUEST("Invalid size: " + sizeString, e);
            }
            snippet = String.format("size :%s %s", new Object[]{comparison, sizeString});
        } else if (name.equals("dateTest")) {
            String s = test.getAttribute("dateComparison");
            s = s.toLowerCase();
            FilterUtil.DateComparison comparison = FilterUtil.DateComparison.fromString(s);
            Date date = new Date(test.getAttributeLong("d") * 1000L);
            snippet = String.format("date :%s \"%s\"", new Object[]{comparison, FilterUtil.SIEVE_DATE_PARSER.format(date)});
        } else if (name.equals("bodyTest")) {
            String value = test.getAttribute("value");
            snippet = String.format("body :contains \"%s\"", FilterUtil.escape(value));
        } else if (name.equals("addressBookTest")) {
            String header = test.getAttribute("header");
            String folderPath = test.getAttribute("folderPath");
            snippet = String.format("addressbook :in \"%s\" \"%s\"", FilterUtil.escape(header), FilterUtil.escape(folderPath));
        } else if (name.equals("attachmentTest")) {
            snippet = "attachment";
        } else if (name.equals("inviteTest")) {
            snippet = "invite";
        } else {
            ZimbraLog.soap.debug("Ignoring unexpected test %s.", name);
        }
        if (snippet != null && test.getAttributeBool("negative", false)) {
            snippet = "not " + snippet;
        }
        return snippet;
    }

    private String handleAction(Element action) throws ServiceException {
        String name = action.getName();
        if (name.equals("actionKeep")) {
            return "keep";
        }
        if (name.equals("actionDiscard")) {
            return "discard";
        }
        if (name.equals("actionFileInto")) {
            String folderPath = action.getAttribute("folderPath");
            return String.format("fileinto \"%s\"", FilterUtil.escape(folderPath));
        }
        if (name.equals("actionTag")) {
            String tagName = action.getAttribute("tagName");
            return String.format("tag \"%s\"", FilterUtil.escape(tagName));
        }
        if (name.equals("actionFlag")) {
            String s = action.getAttribute("flagName");
            FilterUtil.Flag flag = FilterUtil.Flag.valueOf(s);
            return String.format("flag \"%s\"", new Object[]{flag});
        }
        if (name.equals("actionRedirect")) {
            String address = action.getAttribute("a");
            return String.format("redirect \"%s\"", FilterUtil.escape(address));
        }
        if (name.equals("actionStop")) {
            return "stop";
        }
        ZimbraLog.soap.debug("Ignoring unexpected action '%s'", name);
        return null;
    }
}

